<?php

class melipayamakProvider
{

    public $request;

    public function __construct($request)
    {

        $this->request = $request;
    }


    public function send()
    {
        $data = array('username' => $this->request->get_username(), 
            'password' => $this->request->get_apiKey(),
            'text'     => $this->request->get_otp(),
            'to'       => $this->request->get_phone() ,
            "bodyId"   => $this->request->get_patternID()
        );

        $post_data = http_build_query($data);
        $handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber');
        curl_setopt($handle, CURLOPT_HTTPHEADER, array(
            'content-type' => 'application/x-www-form-urlencoded'
        ));
        curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($handle, CURLOPT_POST, true);
        curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
        $response = curl_exec($handle);

        $result = json_decode( $response );
        
        $result = $this->validationResponse( $result );

        if( is_wp_error( $result ) )
        {
            return $result;
        }

        return $this->request->get_otp();

    }

    public function validationResponse($response)
    {


        if( isset( $response->StrRetStatus ) && $response->StrRetStatus === 'InvalidData') {

            return new WP_Error('panel-have-problem', __('اطلاعات وارد شده پنل صحیح نمی باشد', 'woodmartplus'));
        }

        if(is_null($response)) {
            return new WP_Error('panel-have-problem', __('مشکلی پیش آمده', 'woodmartplus'));
        }

        if(isset($response->status) && $response->RetStatus == '-7') {

            return new WP_Error('panel-user-pass', 'خطایی در شماره فرستنده رخ داده است با پشتیبانی تماس بگیرید');
        }

        if(isset($response->status) && $response->RetStatus == '-5') {

            return new WP_Error('panel-phone-number', ' متن ارسالی باتوجه به متغیرهای مشخص شده در متن پیشفرض همخوانی ندارد');
        }

        if(isset($response->status) && $response->RetStatus == '0') {

            return new WP_Error('panel-phone-number', 'نام کاربری یا رمزعبور صحیح نمی‌باشد');
        }


        return true;

    }

}