<?php

if( !class_exists( 'recently_viewed' ) )
{
    class recently_viewed
    {
    
        private $meta_key = 'wplus_user_recently_viewed';
    
        public function __construct( )
        {
            if( 'on' === wplus_helper::get_general_option( 'recenlty_viwed_enable' ) )
            {
                #add_action('template_redirect',[$this,'process_recenlty_viewed_start']);
                add_action('woocommerce_load_recenlty_viwed',[$this, 'load_template_recenlty_viwed' ]);
            }
        }
    
        public function load_template_recenlty_viwed()
        {
            
            // $products = $this->get_recently_viewed_product( get_current_user_id(), wplus_helper::get_general_option( 'recenlty_viewed_show_nummber' ) );
            $products = $this->get_last_product_shop();

            if( $products )
            {
                return core_load_template('myaccount.recently-viewed.index',[
                    'products' => $this->get_last_product_shop(),
                ]);
            }
            return core_load_template('myaccount.recently-viewed.empty');
        }

        public function get_last_product_shop()
        {
            $args = [
                'limit' => wplus_helper::get_general_option( 'recenlty_viewed_show_nummber' ) ? wplus_helper::get_general_option( 'recenlty_viewed_show_nummber' ) : 4,
                'orderby' => 'date',
                'order' => 'DESC',
                'status' => 'publish'
            ];

            $products = wc_get_products( $args );

            $data = [];

            foreach( $products as $product )
            {
                $regular_price = $product->get_regular_price();
    
                    if( $product->get_type() == 'variable' )
                    {
                        $regular_price = $product->get_variation_regular_price('max');
                    }
    
                    $data [] = [
                        'id' => $product->get_id(),
                        'title' => $product->get_title(),
                        'is_on_sale' => $product->is_on_sale(),
                        'regular_price' => $regular_price,
                        'price' => $product->get_price(),
                        'percentage' => wplus_helper::_price_discount( $product ),
                        'image_url' => wp_get_attachment_url($product->get_image_id()) ? wp_get_attachment_url($product->get_image_id()) : "",
                        'permalink' => $product->get_permalink(),
                    ];
            }
            return $data;

        }

        public function process_recenlty_viewed_start()
        {
    
            if( is_singular( 'product' ) && is_user_logged_in() )
            {
                global $post;
                $this->process_add_to_recenlty_viewed( get_current_user_id() , $post->ID );
            }
            
        }
    
        public function process_add_to_recenlty_viewed( $user_id , $product_id )
        {
            
            
            $viewed = $this->get_recently_viewed( $user_id );
    
            if( $viewed )
            {
            
                if( !$this->already_exists_product_viewed( $user_id , $product_id ) )
                {
                    $viewed []= $product_id;
    
                    return update_user_meta( $user_id, $this->meta_key, $viewed );
    
                }
    
                return false;
    
            }else{
    
                $new_value = (array) $product_id;
    
                return add_user_meta( $user_id, $this->meta_key, $new_value );
            }
    
        }
    
        public function already_exists_product_viewed( $user_id , $product_id )
        {
            $viewed = $this->get_recently_viewed( $user_id  ) ? $this->get_recently_viewed( $user_id  ) : [] ;
    
            foreach( $viewed as $value )
            {
                if( $value === $product_id )
                {
                    return true;
                }
            }
    
            return false;
        }
    
        public function get_recently_viewed( $user_id )
        {
            return get_user_meta( $user_id , $this->meta_key, true );
        }
    
        public function get_recently_viewed_product( $user_id , $count_show = 1 )
        {
            if( !$count_show )
            {
                $count_show = 4;
            }

            $product_ids = $this->get_recently_viewed( $user_id );
            
            $data = [];
    
            if( $product_ids )
            {
                foreach( $product_ids as $key => $product_id )
                {
                    if( $key+1 > $count_show )
                        break;
    
                    $product = wc_get_product( $product_id );
    
                    $regular_price = $product->get_regular_price();
    
                    if( $product->get_type() == 'variable' )
                    {
                        $regular_price = $product->get_variation_regular_price('max');
                    }
    
                    $data [] = [
                        'id' => $product->get_id(),
                        'title' => $product->get_title(),
                        'is_on_sale' => $product->is_on_sale(),
                        'regular_price' => $regular_price,
                        'price' => $product->get_price(),
                        'percentage' => wplus_helper::_price_discount( $product ),
                        'image_url' => wp_get_attachment_url($product->get_image_id()) ? wp_get_attachment_url($product->get_image_id()) : "",
                        'permalink' => $product->get_permalink(),
                    ];
                }
            }
            return $data;
        }
    }
    
    new recently_viewed();
}

