<?php


class woodplus_offer{



    public function __construct()
    {
        add_filter( 'woocommerce_account_menu_items', [$this , 'add_offer_item_tab'] );
        
        add_action( 'init', [ $this , 'new_end_point_myaccount_offers_page' ] );

        add_action( 'woocommerce_account_offers_endpoint', [ $this,'add_page_offer_myaccount' ] );

        add_filter( 'query_vars', [ $this , 'add_new_args_myaccount_offers_page' ] );

        add_action('init', [$this, 'save_offer_option']);
    }

    public function add_offer_item_tab( $item )
    {
        $item['offers'] = __( 'Offers', 'woodmartplus' );
        return $item;
    }

    public function new_end_point_myaccount_offers_page()
    {
        add_rewrite_endpoint( 'offers', EP_ROOT | EP_PAGES );
    }

    public function add_page_offer_myaccount()
    {
        if( isset($_GET['show_offer'])  )
        {
            
            $id = absint( $_GET['show_offer'] );
            
            if( $this->show_offer( $id ) ){
                
                $data = [
                    'offers' =>  $this->show_offer( $id ),
                ];
    
                return core_load_template('offers.show',$data);
            }
        }

        if( !isset( $this->get_offer_option()['offer_section'] )  )
        {
            return core_load_template('offers.empty');
        }

        $data = [
            'offers' => $this->get_offer_option(),
        ];

        return core_load_template('offers.index',$data);
    }

    public function add_new_args_myaccount_offers_page($vars)
    {
        $vars[] = 'offers';

        return $vars;
    }

    public function save_offer_option()
    {
    

        if( isset( $_POST['offers_save'] ) && !empty( $_POST['offers_save']  ) && 'save' === $_POST['offers_save'] )
        {
         
            $new_offer_data ['offer_section'] = [
                [
                'title' => '',
                'coupon' => '',
                'image' => '',
                'description' => '',
                ]
            ];
            
            $new_offer_data['enable_offer_data'] = 'off';
            $new_offer_data['show_offer_number'] = 4;

            if(  !isset($_POST['offer_data']) )
            {
                delete_option('woodplus_option_offer');
                return ;
            }   

            if( isset( $_POST['offer_data'] ) )
            {
                
                if( isset( $_POST['offer_data']['setting_offer_enable'] ) && !empty( $_POST['offer_data']['setting_offer_enable'] ) )
                {
                    $enable_disable_offer = sanitize_text_field( $_POST['offer_data']['setting_offer_enable'] );

                    $new_offer_data['enable_offer_data'] = $enable_disable_offer;

                }

                if( isset( $_POST['offer_data']['show_offer_number'] ) && !empty( $_POST['offer_data']['show_offer_number'] ) )
                {
                    $show_offer_number = sanitize_text_field( $_POST['offer_data']['show_offer_number'] );

                    $new_offer_data['show_offer_number'] = $show_offer_number;

                }
                
                if( isset( $_POST['offer_data']['offer_section'] ) )
                {

                    
                    foreach( $_POST['offer_data']['offer_section'] as $key => $data )
                    {
                        $new_offer_data['offer_section'][$key] = [
                            'title' => isset( $data['offer_title'] ) && !empty( $data['offer_title'] ) ? sanitize_text_field( $data['offer_title'] ) : '',
                            'coupon' => isset( $data['offer_coupon'] ) && !empty( $data['offer_coupon'] ) ? sanitize_text_field( $data['offer_coupon'] ) : '',
                            'image' => isset( $data['offer_image'] ) && !empty( $data['offer_image'] ) ? sanitize_text_field( $data['offer_image'] ) : '',
                            'description' => isset( $data['offer_description'] ) && !empty( $data['offer_description'] ) ? sanitize_text_field( $data['offer_description'] ) : '',
                        ];
                    }
                }
                
               
                if( count($new_offer_data['offer_section']) <= 1 && !array_filter($new_offer_data['offer_section'][0]) )
                {
                    
                    unset($new_offer_data['offer_section']);
                }
    
                update_option('woodplus_option_offer',$new_offer_data);
            }


        }


       
    }

    public function get_offer_option()
    {
        return get_option('woodplus_option_offer');
    }

    public function show_offer( $id )
    {
        $offers = $this->get_offer_option();

        if( $offers['offer_section'] )
        {
            if( isset( $offers['offer_section'][$id] ) && !empty( $offers['offer_section'][$id] ) )
            {
                return $offers['offer_section'][$id];
            }
            return false;
        }

        return false;
    }

    
}

new woodplus_offer;