<?php

class wplus_factory{


    

    public function __construct( )
    {
        
        if( 'on' === wplus_factory::get_config_factor( 'setting_factor_enable' )  )
        {
            add_filter( 'page_template', [ $this, 'load_page_factor' ],5 );
        
            add_action( 'admin_head', [ $this, 'load_page_factor' ] );

            add_action('woocommerce_thankyou',[$this, 'load_factor']);

            add_action('add_meta_boxes',[$this,'register_meta_box_factor']);
        }

        add_action('admin_init',[ $this,'save_option_factor' ]);

        add_action( 'after_setup_theme', [$this,'factory_image_size'] );
        
    }
  

    public function register_meta_box_factor()
    {
        add_meta_box('meta-html-factor',esc_html__('Html Factor','woodmartplus'),[$this,'html_input_sho_factor'],'shop_order','side');
    }
    
    public function factory_image_size()
    {
        add_image_size('factor-image',100);
    }

    public function load_page_factor( $page_template )
    {
        

        
        if( isset( $_GET['wplus_factory'] ) && !empty( $_GET['wplus_factory'] ) )
        {
            
            $order_id = $_GET['wplus_factory'];
            
            if( $order =  wc_get_order($order_id) )
            {
                
                $order_items           = $order->get_items();
                $page_template = core_load_template('factor.index',[
                    'manager_info' => $this->get_manage_info(),
                    'buyer_info' => $this->get_buyer_info( $order ),
                    'items' => $order_items,
                    'order' => $order,
                    'total_discount' => $this->get_total_discount($order_items,$order),
                    'total_quantity'    => $this->get_total_quantity($order_items),
                    'more_manager_info' => $this->get_manage_info(true),
                    'order_barcode'     => $this->generate_barcode_for_orders($order_id),
                ]);

                exit;
            }
        }
        return $page_template;
        
    }

    public function load_factor( $order_id )
    {
        
        $this->add_some_meta_order( $order_id ); 
        ?>
            <a href="<?php echo add_query_arg(['wplus_factory'=>$order_id]); ?>">
                فاکتور
            </a>
        <?php

    }
    public function add_some_meta_order( $order_id )
    {
        $order = wc_get_order( $order_id );

        $order_items = $order->get_items();

        if( $order_items )
        {
            foreach( $order_items as $item )
            {
                $product = $item->get_product();
    
                wc_update_order_item_meta( $item->get_id(),'_order_product_regular_price',$product->get_regular_price() );
            }
        }
        
    }

    public function generate_barcode_for_orders($order_id)
    {

            include DIR_PATH . 'inc/vendor/autoload.php';
        
            $image_path = DIR_PATH . 'assets/img_barcode/' . $order_id.'.png';
    
            $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
    
            file_put_contents($image_path, $generator->getBarcode($order_id, $generator::TYPE_CODE_128, 3, 50));
        
            return $this->get_barcode_picture($order_id, $image_path);

    }

    public function get_barcode_picture($order_id, $image_path)
    {
        $image_url = WOODPLUS_ASSET . 'img_barcode/'.$order_id. '.png';

        if(is_readable($image_path)){

            return $image_url;
        }
        
        return false;
    }


    public function save_option_factor()
    {
        if( isset( $_POST['factor_save'] ) && !empty( $_POST['factor_save'] ) && 'save' === $_POST['factor_save'] )
        {
            $new_factor_detail = [
                'setting_factor_enable' => 'off',
                'logo_factor' => '',
                'manager_note' => '',
                'color_factor' => '',
                'width_factor' => '',
                'seller_info' => [
                    'seller_name' => '',
                    'national_id' => '',
                    'registration_id' => '',
                    'company_address' => '',
                    'postal_code' => '',
                    'phon_fax' => '',
                ],
            ];
            
            if( isset( $_POST['factor'] ) && !empty( $_POST['factor'] ) )
            {
                foreach( $_POST['factor'] as $key => $factor_detail )
                {

                    if( 'width_factor' === $key )
                    {
                        $new_factor_detail['width_factor'] = sanitize_text_field($factor_detail);
                    }

                    if( 'color_factor' === $key )
                    {
                        $new_factor_detail['color_factor'] = sanitize_text_field($factor_detail);
                    }

                    if( 'manager_note' === $key )
                    {
                        $new_factor_detail['manager_note'] = sanitize_text_field( $factor_detail );
                    }
                    if( 'setting_factor_enable' === $key )
                    {
                        $new_factor_detail['setting_factor_enable'] = sanitize_text_field($factor_detail);
                    }
                    if( 'logo_factor' === $key )
                    {
                        $new_factor_detail['logo_factor'] = sanitize_text_field($factor_detail);
                    }
                    if( 'seller_info' === $key )
                    {
                        foreach( $new_factor_detail['seller_info'] as $seller_key => $valu )
                        {
                            $new_factor_detail['seller_info'][$seller_key] = sanitize_text_field( $_POST['factor']['seller_info'][$seller_key] );
                        }
                       
                    }
                }
            }

            update_option('wplus_factor',$new_factor_detail);
        }

    }

    
    public function get_manage_info($logo = false)
    {
        $note = esc_html__('unknown','woodmartplus');

        if(true == $logo ){

            $image = '';

            $logo_factor_id = wplus_factory::get_config_factor( 'logo_factor' );

            if( $logo_factor_id )
            {
                 $image = wp_get_attachment_image_src($logo_factor_id,'medium');   
            }

           return $result = [
                'manager_note' => wplus_factory::get_config_factor( 'manager_note' ) ? wplus_factory::get_config_factor( 'manager_note' ) : '',
                'logo' =>  $image ?  $image[0] : $note
            ];
        }
        
        $seller_info = wplus_factory::get_config_factor( 'seller_info' );

        $data = [
            'seller' => [
                'label'   => esc_html__( 'Seller Name', 'woodmartplus' ),
                'output'  => isset( $seller_info['seller_name'] ) ? $seller_info['seller_name'] : $note,
            ],
            'nationalid' => [
                'label'   => esc_html__( 'National ID', 'woodmartplus' ),
                'output'  => isset( $seller_info['national_id'] ) ? $seller_info['national_id'] : $note,
            ],
            'registid' => [
                'label'   => esc_html__( 'Registration ID', 'woodmartplus' ),
                'output'  => isset( $seller_info['registration_id'] ) ? $seller_info['registration_id'] : $note,
            ],
            'companyadd' => [
                'label'   => esc_html__( 'Company address', 'woodmartplus' ),
                'output'  => isset( $seller_info['company_address'] ) ? $seller_info['company_address'] : $note,
            ],
            'postalcod' => [
                'label'   => esc_html__( 'Postal code', 'woodmartplus' ),
                'output'  => isset( $seller_info['postal_code'] ) ? $seller_info['postal_code'] : $note,
            ],
            'phonfax' => [
                'label'   => esc_html__( 'Phone or Fax', 'woodmartplus' ),
                'output'  => isset( $seller_info['phon_fax'] ) ? $seller_info['phon_fax']  : $note,
            ],
        ];

        return $data;
    }

    public static function get_config_factor( $option_key )
    {
        $options = get_option('wplus_factor');

        if( $options )
        {
            foreach( $options as $key => $option )
            {
                if( $option_key === $key )
                {
                    return $option;
                }
            }
        }
        
        return false;
    }

    public function get_buyer_info($order,$customer_note = false)
    {
       

        if( $customer_note ){
            
            return $order->get_customer_note();
        }

        $country = $order->get_billing_country() ? $order->get_billing_country() : false;
        
        $state   = $order->get_billing_state() ? $order->get_billing_state() : false;

        if( $country )
        {
           if( !is_numeric( $state ) )
           {
               $state =  array_search($state,WC()->countries->get_states( $country ));
           }

           $state =  WC()->countries->get_states( $country )[$state];
        }
        
        $date = wplus_helper::date_to_garegorian( $order->get_date_created()->getTimestamp() );

        $note = esc_html__('unknown','woodmartplus');
        
        $fullName = $order->get_billing_first_name() .' '. $order->get_billing_last_name();
        $data = [
            'country' => [
                'label'  => esc_html__('استان','woodmartplus') ,
                'output' => $state ? $state : $note,
            ],
            'city' => [
                'label'  => esc_html__('شهر','woodmartplus') ,
                'output' => $order->get_billing_city() ? $order->get_billing_city() : $note,
            ],
            'receiver'    => [
                'label'   => esc_html__( 'Receiver', 'woodmartplus' ),
                'output'  => $order->get_billing_address_1() ? $order->get_billing_address_1(): $note,
            ],
            'fullname'  => [
                'label'   => esc_html__( 'full name', 'woodmartplus' ),
                'output'  => $fullName ? $fullName : $note
            ],
            'postalcode'  => [
                'label'   => esc_html__( 'Postal Code', 'woodmartplus' ),
                'output'  => $order->get_billing_postcode() ? $order->get_billing_postcode() : $note
            ],
            'phonenummber'  => [
                'label'   => esc_html__( 'Phone', 'woodmartplus' ),
                'output'  => $order->get_billing_phone() ? $order->get_billing_phone() : $note
            ],
            'email'  => [
                'label'   => esc_html__( 'Email', 'woodmartplus' ),
                'output'  => $order->get_billing_email() ? $order->get_billing_email() : $note
            ],
            'order_date'  => [
                'label'   => esc_html__( 'Order Date', 'woodmartplus' ),
                'output'  => $date ? $date : $note
            ],
            'payment_method'  => [
                'label'   => esc_html__( 'Payment Method', 'woodmartplus' ),
                'output'  => $order->get_payment_method_title() ? $order->get_payment_method_title() : $note
            ],
            'shipping_method'  => [
                'label'   => esc_html__( 'Shipping method', 'woodmartplus' ),
                'output'  => $order->get_shipping_method() ? $order->get_shipping_method() : $note
            ],
        ];


        return $data;
    }

    public static function calculateOrderDiscount($product,$item,$order)
    {

            $price_purchased = $order->get_line_subtotal($item);

            $regular_price = wc_get_order_item_meta( $item->get_id(),'_order_product_regular_price',true );

            if( $regular_price && $regular_price > $price_purchased )
            {
                if( is_numeric( $regular_price ) && is_numeric( $price_purchased ) ){
                
                    $discount = ( $regular_price -  $price_purchased ) * $item->get_quantity();

                    return $discount;
                }
            }

            return esc_html('No discount','woodmartplus');


    }

    public function get_total_discount($items,$order)
    {
        $total_discount = 0;
        foreach ($items as $item) {

            $price_purchased = $order->get_line_subtotal($item);

            $regular_price = wc_get_order_item_meta( $item->get_id(),'_order_product_regular_price',true );

            if( $regular_price && $regular_price > $price_purchased )
            {
                if( is_numeric( $regular_price ) && is_numeric( $price_purchased ) ){
                    $discount = ( $regular_price -  $price_purchased ) * $item->get_quantity();
                    $total_discount += $discount;    
                }
            }
            
        }
        return $total_discount;
    }
    public function get_total_quantity($items)
    {
        $total_quantity = 0;
        foreach($items as $item)
        {
            $total_quantity += $item->get_quantity();
        }
        return $total_quantity;
    }

    public function html_input_sho_factor( $object_post )
    {
        
        ?>
            <a href="<?php echo add_query_arg(['wplus_factory' => $object_post->ID]) ?>" class="wplus_btn_html_factor button-3" target="_blank" > <?php esc_html_e('Show factor','woodmartplus') ?></a>
        <?php
    }
}


new wplus_factory;
