<?php


use Elementor\Widget_Base;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

class woodplus_rtl_amazing_slider extends Widget_Base
{

    public function get_name(){

        return 'woodplus_amazing_product_elementor';

    }

    public function get_script_depends() {

        wp_register_script('widget_rtl_amazing_slider_js',ELEMENTOR_WOODPLUS_URL . 'amazing-slider/assets/js/script.js',['jquery'],true);
        wp_register_script(
            'swiper_js',
            ELEMENTOR_ASSETS_URL . "lib/swiper/swiper.min.js",
            ["jquery"],
            false
        );

		return [ 'swiper_js','widget_rtl_amazing_slider_js' ];

	}
    public function get_style_depends() {

        wp_register_style('widget_rtl_amazing_slider_css',ELEMENTOR_WOODPLUS_URL . 'amazing-slider/assets/css/style.css');
        
        wp_register_style(
            "swiper_css",
            ELEMENTOR_ASSETS_URL . "/lib/swiper/css/swiper.min.css",
        );

		return [ 'swiper_css','widget_rtl_amazing_slider_css' ];
	}

    public function get_title(){

        return __('اسلایدر شگفت انگیز (جدید)','woodmartplus');

    }

    public function get_icon(){

        return 'eicon-slider-push';
    }

    public function get_categories(){

        return ['woodplus_elementor'];
    }
    
	
    protected function register_controls(){


        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woodmartplus' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
       
        $this->add_control(
            'how_to_display',
            [
                'label' => esc_html__( 'Show product order by', 'woodmartplus' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'all_product',
                'options' => [
                    'all_product' => esc_html__( 'All product', 'woodmartplus' ),
                    'featured' => esc_html__( 'Featured product', 'woodmartplus' ),
                    'best_selle'  => esc_html__( 'Popular product', 'woodmartplus' ),
                    'on_sale' => esc_html__( 'On sale product', 'woodmartplus' ),
                    'select_product' => esc_html__( 'Choose product', 'woodmartplus' ),
                ]
            ]
        );
    
        $this->add_control(
            'category_select_to_display_product',
            [
                'label' => esc_html__( 'Select Category', 'woodmartplus' ),
                'type'  => 'categoryproduct',
                'options'     => 'product',
                'label_block' => true,
                'multiple'    => 'true',
                'condition' => [
                        'how_to_display' => ['all_product', 'featured', 'best_selle', 'on_sale']
                ],
            ]
        );
        
        $this->add_control(
            'show_product_by_id',
            [
                'label' => esc_html__( 'Search for your product to display', 'woodmartplus' ),
                'type'  => 'chooseproduct',
                'options'     => 'product',
                'label_block' => true,
                'multiple'    => 'true',
                'condition' => [
                    'how_to_display' => 'select_product',
                ],
            ]
        );
        
        
    
        $this->add_control(
            'product_order',
            [
                'label' => esc_html__( 'Order', 'woodmartplus' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'woodmartplus' ),
                    'DESC' => esc_html__( 'Descending product', 'woodmartplus' ),
                ]
            ]
        );
    
        $this->add_control(
            'product_orderby',
            [
                'label' => esc_html__( 'Order by', 'woodmartplus' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'assumption',
                'options' => [
                    'assumption'     => esc_html__( 'Assumption' , 'woodmartplus' ),
                    'ID'     => esc_html__( 'ID' , 'woodmartplus' ),
                    'author' => esc_html__( 'Author' , 'woodmartplus' ),
                    'date' 	 => esc_html__( 'Date' , 'woodmartplus' ),
                    'rand'	 => esc_html__( 'Random' , 'woodmartplus' ),
                    'title'	 => esc_html__( 'Title' , 'woodmartplus' ),
                ]
            ]
        );
    
        $this->add_control(
            'product_per_page',
            [
                'label' => esc_html__( 'Product perpage', 'woodmartplus' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 15,
                'step' => 1,
                'default' => 6,
            ]
        );
    
        $this->add_control(
            'exclude_product_by_id',
            [
                'label' => esc_html__( 'exclude product', 'woodmartplus' ),
                'type'  => 'excludeproduct',
                'options'     => 'product',
                'label_block' => true,
                'multiple'    => 'true',
            ]
        );
    

        $this->end_controls_section();
        
        $this->start_controls_section(
            'general_section',
            [
                'label' => esc_html__( 'عمومی', 'woodmartplus' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'image_end_discount',
			[
				'label' => esc_html__( 'انتخاب تصویر', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_end_discount_dimension',
			[
				'label' => esc_html__( 'ابعاد تصویر', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
			]
		);

        $this->add_control(
			'title_amazing',
			[
				'label' => esc_html__( 'عنوان', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'عنوان پیشفرض', 'woodmartplus' ),
				'placeholder' => esc_html__( 'عنوان خود را قرار دهید', 'woodmartplus' ),
			]
		);

        $this->add_control(
			'website_link_amazing',
			[
				'label' => esc_html__( 'لینک مشاهده بیشتر', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_setting_general',
            [
                'label' => esc_html__( 'تنظیمات عمومی', 'woodmartplus' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'background_color_first_color',
			[
				'label' => esc_html__( 'رنگ پس زمینه', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .amazing_slider_container,{{WRAPPER}} .amazing_slider_container-mobile' => 'background: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_first_section',
				'selector' => '{{WRAPPER}} .amazing_slider_container,{{WRAPPER}} .amazing_slider_container-mobile',
			]
		);

        $this->add_control(
			'border-radius_first_section',
			[
				'label' => esc_html__( 'شعاع مرزی', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .amazing_slider_container,{{WRAPPER}} .amazing_slider_container-mobile' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'more_options_btn_showmore',
			[
				'label' => esc_html__( 'دکمه نمایش بیشتر', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'btn_amaznig_product',
			[
				'label' => esc_html__( 'عنوان دکمه نمایش بیشتر محصول', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'عنوان پیشفرض', 'woodmartplus' ),
				'placeholder' => esc_html__( 'عنوان خود را قرار دهید', 'woodmartplus' ),
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .amazing-slider-bg .btn-show-products a',
			]
		);

        $this->add_control(
			'text_color_btn',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .amazing-slider-bg .btn-show-products a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'رنگ پس زمینه', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .amazing-slider-bg .btn-show-products' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_border_btn_amazing_slider',
				'selector' => '{{WRAPPER}} .amazing-slider-bg .btn-show-products',
			]
		);

        $this->add_control(
			'border-radius_btn',
			[
				'label' => esc_html__( 'شعاع مرزی', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .amazing-slider-bg .btn-show-products' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);  

        $this->add_control(
			'more_options_title_up_btn',
			[
				'label' => esc_html__( 'عنوان شگفت انگیز', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .amazing-slider-bg .product-amazing' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_title_up_btn',
				'selector' => '{{WRAPPER}} .amazing-slider-bg .product-amazing',
			]
		);

        $this->add_control(
			'more_options_title_up_btn_arrow',
			[
				'label' => esc_html__( 'تنظیمات صفحه بندی', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'text_color_arrow_background',
			[
				'label' => esc_html__( 'رنگ پس زمینه', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-name,{{WRAPPER}} .product-name-mobile' => 'background: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_arrow_total',
				'selector' => '{{WRAPPER}} .product-name,{{WRAPPER}} .product-name-mobile',
			]
		);

        $this->add_control(
			'border_radius_total_arrows',
			[
				'label' => esc_html__( 'شعاع مرزی', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .product-name,{{WRAPPER}} .product-name-mobile' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_on_decstop',
            [
                'label' => esc_html__( 'تنظیمات حالت دکستاپ', 'woodmartplus' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'more_options_title_on_decstop',
			[
				'label' => esc_html__( 'عنوان', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'text_color_title_on_decstop',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .amazing-slider-title h4' => 'color: {{VALUE}}',
				],
			]
		);  

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_title_on_decstop',
				'selector' => '{{WRAPPER}} .amazing-slider-title h4',
			]
		);

        $this->add_control(
			'more_options_price_on_decstop',
			[
				'label' => esc_html__( 'قیمت', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_price_label',
				'selector' => '{{WRAPPER}} .price-label',
			]
		);

        $this->add_control(
			'text_color_price_label',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-label' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'text_color_price_regualr',
			[
				'label' => esc_html__( 'رنگ قیمت اصلی', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .original-price span.woocommerce-Price-amount.amount bdi' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_price_regular',
				'selector' => '{{WRAPPER}} .original-price span.woocommerce-Price-amount.amount bdi',
			]
		);

        $this->add_control(
			'text_color_price_discount',
			[
				'label' => esc_html__( 'رنگ قیمت تخفیف دار', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .discounted-price span.woocommerce-Price-amount.amount bdi' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_price_discount',
				'selector' => '{{WRAPPER}} .discounted-price span.woocommerce-Price-amount.amount bdi',
			]
		);

        $this->add_control(
			'more_options_btn_addtocart',
			[
				'label' => esc_html__( 'دکمه سبد خرید', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_addtocart_title',
				'selector' => '{{WRAPPER}} div.perfume-details .add-perfume-btn a',
			]
		);

        $this->add_control(
			'text_color_addtocart_title',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} div.perfume-details .add-perfume-btn a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_addtocart_btn',
				'selector' => '{{WRAPPER}} div.perfume-details .add-perfume-btn',
			]
		);

        $this->add_control(
			'border_radius_addtocart_btn',
			[
				'label' => esc_html__( 'شعاع مرزی', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} div.perfume-details .add-perfume-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'text_color_addtocart_background',
			[
				'label' => esc_html__( 'رنگ پسزمینه', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} div.perfume-details .add-perfume-btn' => 'background: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'setting_section_arrows',
            [
                'label' => esc_html__( 'تنظیمات صفحه بندی', 'woodmartplus' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography_arrow',
				'selector' => '{{WRAPPER}} .button-prev .product-name-left,{{WRAPPER}} .button-next .product-name-rigth,{{WRAPPER}} .slider-name',
			]
		);

        $this->add_control(
			'text_color_arrow',
			[
				'label' => esc_html__( 'رنگ متن', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-prev .product-name-left,{{WRAPPER}} .button-next .product-name-rigth,{{WRAPPER}} .slider-name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'background_color_arrow',
			[
				'label' => esc_html__( 'رنگ پسزمینه', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-prev,{{WRAPPER}} .button-next,{{WRAPPER}} .slider-rigth-arrow2,{{WRAPPER}} .slider-left-arrow2' => 'background: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_arrow_btn',
				'selector' => '{{WRAPPER}} .button-prev,{{WRAPPER}} .button-next',
			]
		);

        $this->add_control(
			'border_radius-arrow',
			[
				'label' => esc_html__( 'شعاع مرزی', 'woodmartplus' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .button-prev,{{WRAPPER}} .button-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

    }
    
    protected function render(){
        
        $settings = $this->get_settings_for_display();
        extract($settings);
        
        if ( ! empty( $settings['website_link_amazing']['url'] ) ) {
			$this->add_link_attributes( 'website_link_amazing', $settings['website_link_amazing'] );
		}

        $data = [
			'order' => $product_order,
			'orderby' => $product_orderby,
			'posts_per_page' => $product_per_page,
			'category' => $category_select_to_display_product,
			'product_include' => $show_product_by_id,
			'product_exclude' => $exclude_product_by_id,
		];

        $args = wplus_helper::woodplus_elementor_woocommerce_query( $how_to_display,$data );
        
        $loop = new WP_Query($args);
        
        require_once 'render-widget.php';
		
    }
        
}