
<?php


    $options = get_option('woodplus_option_offer');

    $default_options['offer_section'] = [
            'title' => '' ,
            'coupon' => '' ,
            'image' => '' ,
            'description' => '' ,
    ];

    if( !isset( $options['offer_section'] ) && empty( $options['offer_section'] ) )
    {
        $options['offer_section'] = $default_options;
    }
    
  
?>
<div class="container woodmartplus-options-page" >

    <p><?php esc_html_e('Offer page','woodmartplus'); ?></p>
    <form action="" method="POST" style="display: flex; flex-direction: column; row-gap: 21px; width: 100%;" >
        <div class="offer_setting_section"> 
            <div class="offer_setting">
                <div class="setting_offer_eable_disable">
                    <h3 style="margin-top:23px"><?php esc_html_e('Enable offer','woodmartplus'); ?></h3>
                    <input type="checkbox" hidden="hidden" id="complated"  name="offer_data[setting_offer_enable]"   style="display:none" <?php echo isset( $options['enable_offer_data'] ) && 'on' === $options['enable_offer_data'] ? 'checked' : '' ?>>
                    <label class="switch" for="complated"></label>
                </div>
            </div>

            <div class="offer_show_items">
                    <div class="number-input">
                        <label for="incorretct_otp"><?php esc_html_e('Show offer number','woodmartplus') ?>:</label>
                        <input type="number" id="incorretct_otp" name="offer_data[show_offer_number]" min="1" max="6" value="<?php echo isset( $options['show_offer_number'] ) && !empty( $options['show_offer_number'] ) ? $options['show_offer_number'] : 4 ?>">
                    </div>
            </div>
        </div>
        <div class="offer-items-rea">

            <div class="offer-items" data-repeater-list="offer_data[offer_section]" >

            <?php foreach( $options['offer_section'] as $option ):  ?>
                <div class="repeater-sections-offer" data-repeater-item>

                    <div class="offer-item-1 title-code">
                        <label ><?php esc_html_e('عنوان کد','pgs-woo-api'); ?></label>
                        <input name="offer_data[offer_section][][offer_title]" type="text" value="<?php echo esc_html( $option['title'] ) ?>"  >
                    </div>

                    <div class="offer-item-2 code-coupon" >
                        <label ><?php esc_html_e('کد تخفیف','pgs-woo-api'); ?></label>
                        <input name="offer_data[offer_section][][offer_coupon]" type="text" value="<?php echo esc_html( $option['coupon'] ) ?>" >
                    </div>

                    <div class="offer-item-3 coupon-image">

                        <label ><?php esc_html_e('آپلود تصویر','pgs-woo-api'); ?></label>
                        <?php if( isset( $option['image'])  && !empty( $option['image'] ) ): ?>
                            <?php 
                                $img_src = wp_get_attachment_image_src($option['image'],'medium');    
                            ?>
                            <div class="upload_image">
                                <img src="<?php echo esc_url( $img_src[0] ); ?>" alt="">
                            </div>
                            <input type="hidden" name="offer_data[offer_section][][offer_image]" id="" class="upload_image_id" value="<?php echo esc_attr( $option['image'] ) ?>" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Edit Image','woodmartplus'); ?></a>

                        <?php else: ?>

                            <div class="upload_image"></div>
                            <input type="hidden" name="offer_data[offer_section][][offer_image]" id="" class="upload_image_id" value="" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Add Image','woodmartplus'); ?></a>
                            <a href="javascript:void(0);" class="remove-image-button" style="display: none;" ><?php esc_html_e('remove image','woodmartplus'); ?></a>

                        <?php endif; ?>
                           
                    </div>

                    <div class="offer-item-4 coupon-description">
                        <label ><?php esc_html_e('توضیحات کوپن','pgs-woo-api'); ?></label>
                        <textarea name="offer_data[offer_section][][offer_description]" id="" cols="30" rows="10"><?php echo esc_html( $option['description'] ) ?></textarea>
                    </div>

                    <input class="button-primary" style="position: absolute; bottom: -30px; right: 55px;" data-repeater-delete type="button" value="حذف"/>

                </div>
                <?php endforeach; ?>
            </div>
            <input class="button-primary" data-repeater-create type="button" value="افزودن"/>
        </div>

        <button class="button-3" type="submit" name="offers_save" value="save" ><?php esc_html_e('save data','woodmartplus'); ?></button>

    </form>
</div>