<?php


class smsirProvider{

    public $request;

    public function __construct($request)
    {

        $this->request = $request;
    }


    public function send()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "mobile": "'.$this->request->get_phone().'",
          "templateId": '.$this->request->get_patternID().',
          "parameters": [
            {
              "name": "code",
              "value": "'.$this->request->get_otp().'"
            },
            {
                "name":"PARAMETER2",
                "value":"000000"
            }
          ]
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: '.$this->request->get_apiKey().''
          ),
        ));
  
        $response = curl_exec($curl);
        
        curl_close($curl);

        $result = json_decode( $response );
        
        $result =$this->validationResponse( $result );

        if( is_wp_error( $result ) )
        {
            return $result;
        }

        return $this->request->get_otp();

    }

    public function validationResponse($response)
    {

        if(is_null($response)) {
            return new WP_Error('panel-have-problem', __('مشکلی پیش آمده', 'woodmartplus'));
        }

        if(isset($response->status) && $response->status == '10') {
            return new WP_Error('panel-user-pass', $response->message);
        }
        if(isset($response->status) && $response->status == '113') {

            return new WP_Error('panel-phone-number', $response->message);
        }

        return true;

    }

}