<?php

use function PHPSTORM_META\elementType;

require_once DIR_PATH . 'inc/sms/otp-handler.php';
require_once DIR_PATH . 'inc/sms/otp-email-handler.php';

class woodplust_login_register
{
    private $otp_handler;
    private $otp_handler_email;
    private $email;
    private $password;
    private $phone;
    private $otp;
    private $account;
    private $username;


    public function __construct()
    {
        $this->save_option_data();

        $this->otp_handler = new otp_handler();
        $this->otp_handler_email = new otp_email_handler();

        add_action('wp_ajax_process_login', [$this,'process_woodplus_login']);
        add_action('wp_ajax_nopriv_process_login', [$this, 'process_woodplus_login']);

        add_action('wp_ajax_register_with_phone', [$this,'process_register_with_phone_number']);
        add_action('wp_ajax_nopriv_register_with_phone', [$this,'process_register_with_phone_number']);

        add_action('wp_ajax_verify_otp', [$this,'process_verify_otp']);
        add_action('wp_ajax_nopriv_verify_otp', [$this,'process_verify_otp']);

        add_action('wp_ajax_verify_otp_login', [$this,'process_verify_otp_login']);
        add_action('wp_ajax_nopriv_verify_otp_login', [$this,'process_verify_otp_login']);

        add_action('wp_ajax_action_resend_otp', [$this,'process_resend_otp']);
        add_action('wp_ajax_nopriv_action_resend_otp', [$this,'process_resend_otp']);

        add_action('wp_ajax__woocmmerce_register', [$this,'process_woocmmerce_register']);
        add_action('wp_ajax_nopriv__woocmmerce_register', [$this,'process_woocmmerce_register']);

        add_action('wp_ajax_login_register_together',[$this,'process_login_register_together']);
        add_action('wp_ajax_nopriv_login_register_together',[$this,'process_login_register_together']);
        
        add_action('wp_ajax_email_or_account_login',[$this,'process_email_or_account_login']);
        add_action('wp_ajax_nopriv_email_or_account_login',[$this, 'process_email_or_account_login']);

        add_action('wp_ajax_email_register',[$this, 'process_email_register']);
        add_action('wp_ajax_nopriv_email_register',[$this, 'process_email_register']);

        add_action('wp_ajax_verify_otp_and_do_somting',[ $this,'process_verify_otp_and_do_somting' ]);
        add_action('wp_ajax_nopriv_verify_otp_and_do_somting',[ $this,'process_verify_otp_and_do_somting' ]);

        add_action('wp_ajax_verify_otp_email_and_register',[$this, 'process_verify_otp_email_and_register']);
        add_action('wp_ajax_nopriv_verify_otp_email_and_register',[$this, 'process_verify_otp_email_and_register']);

        add_action('show_user_profile',[$this,'show_mobile_nummber_woodmart_plus'],5);
        add_action('edit_user_profile',[$this,'show_mobile_nummber_woodmart_plus'],5);
        add_action('edit_user_profile_update',[$this,'process_mobile_update_profile']);

        add_filter('manage_users_columns',[$this,'customize_column_users_woodmartplus']);
        add_filter( 'manage_users_custom_column', [$this,'add_phone_column_to_users_woodmartplus'], 10, 3 );
        add_action( 'pre_get_users', [ $this, 'wplus_member_search_with_phone' ],20);

        if('on' === wplus_helper::get_enable_disable_login_register()) {
            add_filter('page_template', [ $this, 'login_template_ui' ]);
        }


    }

    public function wplus_member_search_with_phone( $query )
    {
        global $pagenow;
        
        if( is_admin() && 'users.php' == $pagenow &&  isset( $_GET['s'] ) && !empty( $_GET['s'] ) && is_numeric($_GET['s']) )
        {
            
            $the_search = trim($query->query_vars['search']);
            $the_search = trim($query->query_vars['search'], '*');

            $query->set('meta_key', ['_wplus_phone','digits_phone_no']);
            $query->set('meta_value', $the_search );
            $query->set('meta_compare', 'LIKE');
            $query->set('search','');
        }
    }
    

    public function add_phone_column_to_users_woodmartplus( $val, $column_name, $user_id )
    {
        if( 'wplus_phone' === $column_name )
        {
            $phone = get_user_meta($user_id , '_wplus_phone',true) ? get_user_meta($user_id , '_wplus_phone',true) : '';
            return $phone;
        }
        return $val;
    }
    public function customize_column_users_woodmartplus( $output )
    {
        $new_array ['cb'] = $output['cb'] ;
        $new_array ['username'] = $output['username'] ;
        $new_array ['name'] = $output['name'] ;
        $new_array ['email'] = $output['email'] ;
        $new_array ['wplus_phone'] = esc_html__('شماره موبایل','woodmartplus') ;

        foreach( $output as $key => $value ) 
        {
            $new_array[$key] = $value;
        }
        
        return $new_array;
    }
    public function process_mobile_update_profile( $user_id )
    {
        if( isset( $_POST['mobile_woodmart_plus_profile'] ) && !empty( $_POST['mobile_woodmart_plus_profile'] ) && is_numeric( $_POST['mobile_woodmart_plus_profile'] ) )
        {
            
            $mobile = sanitize_text_field( $_POST['mobile_woodmart_plus_profile'] );

            $result = $this->validate_phone_number( $mobile );
            if( $result  && !$this->user_register_data( $mobile ) )
            {
                update_user_meta( $user_id,'_wplus_phone',$mobile );
            }
        }

    }
    public function show_mobile_nummber_woodmart_plus( $user )
    {
        $mobile_number = get_user_meta($user->ID,'_wplus_phone',true);
        

        ?>
            <table class="form-table" >
                <tbody>
                    <tr>
                        <th>
                            <label for="mobile_woodmart_plus">شماره موبایل </label>
                        </th>
                        <td>
                            <input type="text" name="mobile_woodmart_plus_profile" id="mobile_woodmart_plus" class="regular-text" value="<?php echo $mobile_number? esc_attr( $mobile_number ) : '' ?>" >
                        </td>
                    </tr>
                </tbody>
            </table>
        <?php
    }

    public function process_verify_otp_email_and_register()
    {
        if( wp_verify_nonce($_POST['nonce'], 'form_verify_otp_email') )
        {
            $email = isset( $_POST['email'] ) && !empty( $_POST['email'] ) && is_email( $_POST['email'] ) ? sanitize_text_field( $_POST['email'] ) : null;

            if( is_null( $email ) )
            {
                wp_send_json([
                    'msg' => 'موبایل نمی تواند خالی باشد',
                    'status' => 'error'
                ],400);
            }

            $otp = isset( $_POST['otp'] ) && !empty( $_POST['otp'] ) ? sanitize_text_field( $_POST['otp'] ) : null;

            if( is_null( $otp ) )
            {
                wp_send_json([
                    'msg' => 'کد ارسال شده صحیح نیست',
                    'status' => 'error'
                ],400);
            }

            $this->otp = $otp;
            $this->email = $email;
            $this->process_verify_otp_email_and_do_register();

        }
    }

    public function process_verify_otp_email_and_do_register()
    {
        $data_sended = $this->otp_handler_email->get_user_otp_email_data();
        $incorrect =  (int)$data_sended['incorrect'];
      
        $otp = $data_sended['otp'];
        
        
        $ban_time 			=  (int) wplus_helper::get_otp_config('ban_time', 120);

        $time_passed = strtotime("now") -  (int)$data_sended['created'];

        
        if($incorrect >= (int) wplus_helper::get_otp_config('incorretct_otp', 4)) {

            $unban_time_left = $ban_time - $time_passed;

            if($unban_time_left < 0) {
                $this->otp_handler_email->set_otp_data('incorrect', 0);
                $incorrect = 0;

            } else {

                wp_send_json([
                    'status' => 'error',
                    'redirect' => true,
                    'msg' => sprintf(__('Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus'), $this->otp_handler_email->getTimeDuration($unban_time_left)),
                ], 401);
            }
        }

        if( $otp == $this->otp ) {

            if(isset($data_sended['expiry']) && strtotime('now') > (int) $data_sended['expiry']) {
                wp_send_json(array( 'status' => 'error','redirect' => true, 'msg' => __('OTP Expired', 'woodmartplus') ), 401);
            }

            $this->otp_handler_email->set_otp_data(array(
                'verified' 			=> true,
                'form_token' 		=> '',
                'incorrect' 		=> 0,
                'sent_items' 		=> 0,
                'expiry' 			=> '',
                'created' 			=> '',
            ));

            wp_send_json([
                'msg' => 'ثبت نام با موفقیت انجام شد در حال انتقال',
                'status' => 'success'
            ],200);
            

        } else {

            
            $data_sended['incorrect'] = ++$incorrect;
            
            $this->otp_handler_email->set_otp_data('incorrect',$data_sended['incorrect']);

            wp_send_json([
                'status' => 'error',
                'msg' => __('invalid otp number', 'woodmartplus'),
            ], 401);
        }
    }
    public function process_verify_otp_and_do_somting()
    {
        if( wp_verify_nonce($_POST['nonce'], 'form_verify_otp') )
        {
            $phone = isset( $_POST['phone'] ) && !empty( $_POST['phone'] ) ? sanitize_text_field( $_POST['phone'] ) : null;

            if( is_null( $phone ) )
            {
                wp_send_json([
                    'msg' => 'موبایل نمی تواند خالی باشد',
                    'status' => 'error'
                ],400);
            }

            $result = $this->validate_phone_number( $phone );

            if( is_wp_error( $result ) )
            {
                wp_send_json([
                    'msg' => $result->get_error_message(),
                    'status' => 'error'
                ],400);
            }

            $otp = isset( $_POST['otp'] ) && !empty( $_POST['otp'] ) ? sanitize_text_field( $_POST['otp'] ) : null;

            if( is_null( $otp ) )
            {
                wp_send_json([
                    'msg' => 'کد ارسال شده صحیح نیست',
                    'status' => 'error'
                ],400);
            }

            $this->otp = $otp;
            $this->phone = $phone;
            $this->process_verify_otp_and_do_();

        }
    }
    public function process_verify_otp_and_do_()
    {

        $data_sended = $this->otp_handler->get_otp_data();

        $incorrect = (int) $data_sended['incorrect'];

        $otp = $data_sended['otp'];
        
        $ban_time 			= wplus_helper::get_otp_config('ban_time', 120);

        $time_passed = strtotime("now") - (int) $data_sended['created'];

        if($incorrect >= wplus_helper::get_otp_config('incorretct_otp', 4)) {

            $unban_time_left = $ban_time - $time_passed;
            if($unban_time_left < 0) {
                $this->otp_handler->set_otp_data('incorrect', 0);
            } else {
                
                wp_send_json([
                    'status' => 'error',
                    'redirect' => true,
                    'msg' => sprintf(__('Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus'), $this->otp_handler->getTimeDuration($unban_time_left)),
                ], 401);
            }
        }
        if($otp == $this->otp ) {

            if(isset($data_sended['expiry']) && strtotime('now') > (int) $data_sended['expiry']) {
                wp_send_json(array( 'status' => 'error','redirect' => true, 'msg' => __('OTP Expired', 'woodmartplus') ), 401);
            }

            $this->otp_handler->set_otp_data(array(
                'verified' 			=> true,
                'form_token' 		=> '',
                'incorrect' 		=> 0,
                'sent_items' 		=> 0,
                'expiry' 			=> '',
                'created' 			=> '',
            ));


            if( $this->is_user_registerd( $this->phone ) )
            {
                $result = $this->user_login( $this->phone );

                if( is_wp_error( $result ) )
                {
                    wp_send_json([
                        'msg' => $result->get_error_message(),
                        'status' => 'error'
                    ],400);
                }
                wp_send_json([
                    'status' => 'success',
                    'msg' => 'باموفقیت وارد شدید ، درحال انتقال...'
                ],200);
            }

            $result = $this->register_user( $this->phone );

            if( is_wp_error( $result ) )
            {
                wp_send_json([
                    'msg' => $result->get_error_message(),
                    'status' => 'error'
                ],400);
            }

            wp_send_json([
                'msg' => 'ثبت نام با موفقیت انجام شد در حال انتقال',
                'status' => 'success'
            ],200);
            

        } else {

            $data_sended['incorrect'] = ++$incorrect;

            $this->otp_handler->set_otp_data($data_sended);

            wp_send_json([
                'status' => 'error',
                'msg' => __('invalid otp number', 'woodmartplus'),
            ], 401);
        }

    }

    public function process_email_register()
    {
        if( wp_verify_nonce($_POST['nonce'], 'form_register_with_email') )
        {
            $email = isset(  $_POST['email'] ) && !empty(  $_POST['email'] ) && is_email( $_POST['email'] ) ? sanitize_text_field(  $_POST['email'] ) : null;

            if( is_null( $email ) )
            {
                wp_send_json([
                    'msg' => 'ایمیل معتبر نمیباشد',
					'status' => 'error',
                ],400);
            }

            $password = isset( $_POST['password'] ) && !empty( $_POST['password'] ) ? sanitize_text_field( $_POST['password'] ) : null;

            if( is_null( $password ) )
            {
                wp_send_json([
                    'msg' => 'رمزعبور نمی تواند خالی باشد',
					'status' => 'error',
                ],400);
            }

            $username = isset( $_POST['username'] ) && !empty( $_POST['username'] ) ? sanitize_text_field( $_POST['username'] ) : null;

            if( is_null( $password ) )
            {
                wp_send_json([
                    'msg' => 'نام‌کاربری نمی تواند خالی باشد',
					'status' => 'error',
                ],400);
            }

            if( username_exists( $username ) ) 
            {
                wp_send_json([
                    'msg' => 'نام کاربری از قبل موجود است',
					'status' => 'error',
                ],400);
            }
            

            $this->email = $email;
            $this->password = $password;
            $this->username = $username;
            
            if( !$this->process_register_with_email() )
            {
                wp_send_json([
                    'msg' => 'ثبت نام انجام نشد ، مشکلی پیش آمده مجددا اقدام فرمایید',
                    'status' => 'error',
                ],400);
            }

            wp_send_json([
                'msg' => 'ثبت نام با موفقیت انجام شد، دحال انقال ...',
                'status' => 'success'
            ],200);

        }
    }
    public function process_register_with_email()
    {
            
            $data = array(
                'user_login' => $this->username,
                'user_pass'  => $this->password,
                'user_email' => sanitize_email($this->email),
                'role'       => 'customer'
            );

            $customer_id = wp_insert_user( $data );
        
            if( !is_wp_error( $customer_id ) )
            {
                wp_clear_auth_cookie();
                wp_set_current_user($customer_id);
                wp_set_auth_cookie($customer_id);
                update_user_meta( $customer_id, 'show_admin_bar_front','false' );
                return true;
            }
            
            return false;
    }

    public function process_email_or_account_login()
    {
        if( wp_verify_nonce($_POST['nonce'], 'form_login_with_email') )
        {
            $param = isset(  $_POST['value'] ) && !empty(  $_POST['value'] )  ? sanitize_text_field(  $_POST['value'] ) : null;

            if( is_null( $param ) )
            {
                wp_send_json([
                    'msg' => 'اطلاعات معتبر نمی باشد',
                ],400);
            }

            $password = isset( $_POST['password'] ) && !empty( $_POST['password'] ) ? sanitize_text_field( $_POST['password'] ) : null;

            if( is_null( $password ) )
            {
                wp_send_json([
                    'msg' => 'رمزعبور نمی تواند خالی باشد'
                ],400);
            }

            $this->password = $password;
            
            if( is_email( $param ) )
            {
                $this->email = $param;
                
                if( $this->proccess_login_with_email() )
                {
                    wp_send_json([
                        'status' => 'success',
                        'msg' => 'شما با موفقیت وارد شدید ، درحال انتقال ...',
                    ],200);
                }

            }

            $this->account = $param;

            if( $this->process_login_with_account() )
            {
                wp_send_json([
                    'status' => 'success',
                    'msg' => 'شما با موفقیت وارد شدید ، درحال انتقال ...',
                ],200);

            }

            wp_send_json([
                'msg' => 'کاربری با این مشخصات پیدا نشد',
                'status' => 'error',
            ],400);

           

        }
        
    }

    public function process_login_with_account(  )
    {
        if( $this->check_is_account( $this->account ) )
        {
            $user = get_user_by('login', $this->account );

            if( wp_check_password($this->password, $user->user_pass, $user->ID) )
            {
                wp_clear_auth_cookie();
                wp_set_current_user($user->ID);
                wp_set_auth_cookie($user->ID);

                return true;
            }
        }
        return false;
        
    }
    
    public function proccess_login_with_email()
    {
        $user = get_user_by('email',$this->email);
        
        if( $user ) 
        {
            if( wp_check_password($this->password, $user->user_pass, $user->ID) )
            {
                wp_clear_auth_cookie();
                wp_set_current_user($user->ID);
                wp_set_auth_cookie($user->ID);

                return true;
            }
        }

        return false;

        
    }

    public function process_login_register_together()
    {
        
        if(wp_verify_nonce($_POST['nonce'], 'form_login_register')) {

            // setting_recaptcha_enable
            if( 'on' == wplus_helper::get_detail_login_register('setting_recaptcha_enable') )
            {
                $is_recaptcha_valid = isset( $_POST['captcha'] ) && !empty( $_POST['captcha'] ) ? woodplus_Recaptcha::is_recaptcha_valid( sanitize_text_field( $_POST['captcha'] ) ) : false;

                if( !$is_recaptcha_valid )
                {
                    wp_send_json([
                        'msg' => __('کپچا یک فیلد الزامیست','woodmartplus'),
                        'status' => 'error'
                    ],400);
                }
            }
            
            $value = isset( $_POST['value'] ) && !empty( $_POST['value'] ) ? sanitize_text_field( $_POST['value'] ) : null ;
            
            if( is_null( $value ) )
            {
                wp_send_json([
                    'msg' => __('The desired field cannot be empty','woodmartplus'),
                    'status' => 'error'
                ],404);
            }

            if( is_email( $value ) )
            {
                $this->process_login_register_with_email( $value );
            }

            if( is_numeric( $value ) )
            {
                $result = $this->validate_phone_number( $value );

                if( is_wp_error( $result ) )
                {
                    wp_send_json([
                        'msg' => $result->get_error_message() ,
                        'status' => 'error'
                    ],400);
                }

                $result = $this->otp_handler->send_otp_sms('+98', $value);
            
                if(is_wp_error($result)) {

                    wp_send_json([
                        'status' => 'error',
                        'msg' => $result->get_error_message(),
                    ], 401);
                }


                wp_send_json([
                    'status' => 'mobile',
                    'msg' => sprintf(__('Enter The Code Sent To %s', 'woodmartplus'), $value),
                ],200);
            }
            
            if( $this->check_is_account( $value ) )
            {
                wp_send_json([
                    'status' => 'account_login',
                    'msg' => "رمز عبور $value را وارد کنید"
                ],200);
            }

            wp_send_json([
                'status' => 'error',
                'msg' => 'کاربری با این مشخصات پیدا نشد'
            ],400);
            

        }

    }

    public function check_is_account( $account )
    {
        $user = get_user_by('login', $account );

        if( $user )
        {
            return true;
        }
        return false;
    }
    public function process_login_register_with_email( $email )
    {
        // check is registerd ?
        if( $this->email_is_registered( $email ) )
        {
            wp_send_json([
                'status' => 'email_login',
                'msg' => "رمز عبور $email را وارد کنید"
            ],200);
        }

        $result = $this->otp_handler_email->send_otp_email( $email );

        if( is_wp_error( $result ) )
        {
            wp_send_json([
                'status' => 'error',
                'msg' => $result->get_error_message()
            ],400);
        }

        wp_send_json([
            'status' => 'email_register',
            'msg' => sprintf(__('Enter The Code Sent To %s', 'woodmartplus'), $email),
        ],200);

    }
   

    public function process_woocmmerce_register()
    {
        $result = true;


        if(wp_verify_nonce($_POST['nonce_register'], 'woodplus_form_register')) {

            $username = 'no' == get_option('woocommerce_registration_generate_username') ? $_POST['username'] : '';
            $password = 'no' == get_option('woocommerce_registration_generate_password') ? $_POST['password'] : '';
            $email    = $_POST['email'];

            try {

                add_filter('dokan_register_nonce_check', '__return_false');

                $validation_error  = new WP_Error();
                $validation_error  = apply_filters('woocommerce_process_registration_errors', $validation_error, $username, $password, $email);

                if($validation_error->get_error_code()) {
                    wp_send_json([
                        'register' => false,
                        'msg' => $validation_error->get_error_message(),
                    ], 403);
                }

                $new_customer = wc_create_new_customer(sanitize_email($email), wc_clean($username), $password);

                if (is_wp_error($new_customer)) {

                    wp_send_json([
                        'register' => false,
                        'msg' => __('ارور:', 'woodmartplus') . $new_customer->get_error_message()
                    ], 403);
                }

                update_user_meta($new_customer , 'show_admin_bar_front','false');
                
                if (apply_filters('woocommerce_registration_auth_new_customer', true, $new_customer)) {
                    wc_set_customer_auth_cookie($new_customer);
                }

            } catch (Exception $e) {
                $result = false;
            }
        }

        if($result) {
            wp_send_json([
                'register' => true,
                'pwait' => __('لطفا صبر کنید...', 'woodmartplus'),
                'msg' => __('حساب شما با موفقیت ساخته شده در حال انتقال...', 'woodmartplus')
            ], 200);
        } else {

            wp_send_json([
                'register' => false,
                'msg' => __('ثبت نام انجام نشد.', 'woodmartplus'),
            ], 403);

        }
    }

    public function process_resend_otp()
    {
        $type = isset( $_POST['type_value'] ) && !empty( $_POST['type_value'] ) ? sanitize_text_field( $_POST['type_value'] ) : null;

        if( is_null( $type ) )
        {
            wp_send_json([
                'msg' => 'نوع ارسال مشخص نیست',
                'status' => 'error'
            ],400);
        }

        if( 'email' === $type )
        {
            $response = $this->resend_email_otp();

        }elseif( 'mobile' === $type )
        {
            $response = $this->resend_otp();

        }


        if(is_wp_error($response)) {
            wp_send_json([
                'status' => 'error',
                'msg' => $response->get_error_message()
            ], 401);
        }

        wp_send_json([
            'status' => 'success',
            'msg' => __('OTP Resent', 'woodmartplus'),
        ], 200);
    }

    public function resend_otp()
    {
        $phone_otp_data = $this->otp_handler->get_otp_data();

        if(!$phone_otp_data  || !isset($phone_otp_data[ 'phone_no' ]) || !$phone_otp_data[ 'phone_no' ] || !isset($phone_otp_data['phone_code'])) {
            return new Wp_Error('no-phone', __("Phone Number not found", 'woodmartplus'));
        }

        $otp = $this->otp_handler->send_otp_sms('+98', $phone_otp_data['phone_no']);
        return $otp;
    }

    public function resend_email_otp()
    {
        $email_otp_data = $this->otp_handler_email->get_user_otp_email_data();

        if(!$email_otp_data  || !isset($email_otp_data[ 'email' ]) ) {
            return new Wp_Error('no-email', __("ایمیل پیدا نشد", 'woodmartplus'));
        }

        $otp = $this->otp_handler_email->send_otp_email($email_otp_data['email']);
        return $otp;
    }

    public function process_verify_otp()
    {
        if(wp_verify_nonce($_POST['nonce_verify_otp'], '_form_verify_otp')) {

            $phone = isset($_POST['phone']) && !empty($_POST['phone']) ? sanitize_text_field($_POST['phone']) : null;

            if(!is_null($phone)) {

                $data_sended = $this->otp_handler->get_otp_data();

                $incorrect = (int) $data_sended['incorrect'];
                $otp = $data_sended['otp'];
                $otp_form = isset($_POST['otp_sended']) && !empty($_POST['otp_sended']) ? (int) sanitize_text_field($_POST['otp_sended']) : null;
                $ban_time 			= wplus_helper::get_otp_config('ban_time', 120);

                $time_passed = strtotime("now") - (int) $data_sended['created'];

                if($incorrect >= wplus_helper::get_otp_config('incorretct_otp', 4)) {

                    $unban_time_left = $ban_time - $time_passed;

                    if($unban_time_left < 0) {
                        $this->otp_handler->set_otp_data('incorrect', 0);
                    } else {

                        wp_send_json([
                            'status' => false,
                            'redirect' => true,
                            'msg' => sprintf(__('Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus'), $this->otp_handler->getTimeDuration($unban_time_left)),
                        ], 401);
                    }
                }

                if($otp === $otp_form) {

                    if(isset($data_sended['expiry']) && strtotime('now') > (int) $data_sended['expiry']) {
                        wp_send_json(array( 'status' => false,'redirect' => true, 'msg' => __('OTP Expired', 'woodmartplus') ), 401);
                    }

                    $this->otp_handler->set_otp_data(array(
                        'verified' 			=> true,
                        'form_token' 		=> '',
                        'incorrect' 		=> 0,
                        'sent_items' 		=> 0,
                        'expiry' 			=> '',
                        'created' 			=> '',
                    ));



                    $user_created = $this->register_user($phone);

                    if(is_wp_error($user_created)) {
                        wp_send_json([
                            'status' => false,
                            'msg' => $user_created->get_error_message()
                        ], 401);
                    }

                    wp_send_json([
                        'status' => true,
                        'msg' => __('Registration was successful , redirect...', 'woodmartplus'),
                    ], 200);

                } else {

                    $data_sended['incorrect'] = ++$incorrect;

                    $this->otp_handler->set_otp_data($data_sended);

                    wp_send_json([
                        'status' => false,
                        'msg' => __('invalid otp number', 'woodmartplus'),
                    ], 401);
                }

            }
        }
    }

    public function register_user($phone, $role = '')
    {
        $userName = $this->createCustomUserName();

        $detailToRegister = [
            'user_login' => $userName,
            'user_pass' => wp_generate_password(),
            'role' => 'customer',
        ];

        if(!empty($role)) {
            $detailToRegister['role'] = $role;
        }

        $userCreated = wp_insert_user($detailToRegister);

        if(is_wp_error($userCreated)) {
            return $userCreated;
        }
        update_user_meta($userCreated , 'show_admin_bar_front','false');
        update_user_meta($userCreated, '_wplus_phone', $phone);

        wp_set_auth_cookie($userCreated);

        return true;
    }

    public function createCustomUserName()
    {
        $int = rand(1, 999999999);
        $result = 'user' . $int;

        if(is_int(username_exists($result))) {

            $int = rand(1, 9999999999);
            $result = 'user' . $int;
            return $result;
        }

        return $result;
    }

    public function process_register_with_phone_number()
    {

        if(wp_verify_nonce($_POST['nonce_register'], 'woodplus_form_register')) {



            $phone = isset($_POST['phone_number']) && !empty($_POST['phone_number']) ? sanitize_text_field($_POST['phone_number']) : null;

            if(is_null($phone)) {
                wp_send_json([
                    'msg' => __('Enter the desired information correctly', 'woodmartplus'),
                ], 401);
            }

            $check_number = $this->validate_phone_number($phone);


            if(is_wp_error($check_number)) {
                wp_send_json([
                    'status' => false,
                    'msg' => $check_number->get_error_message(),
                ], 401);
            }

            if($this->is_user_registerd($phone)) {

                wp_send_json([
                    'status' => false,
                    'msg' => __('This user already exists', 'woodmartplus'),
                    'user_exists' => true,
                    'msg_login' => __('login', 'woodmartplus'),
                ], 401);
            }


            if($check_edit_number = $this->check_edit_number($phone)) {
                wp_send_json([
                    'status' => $check_edit_number['status'],
                    'msg' => $check_edit_number['message'],
                ], 200);
            }

            $result = $this->otp_handler->send_otp_sms('+98', $phone);

            if(is_wp_error($result)) {
                wp_send_json([
                    'status' => false,
                    'msg' => $result->get_error_message(),
                ], 401);
            }

            wp_send_json([
                'status' => true,
                'msg' => sprintf(__('Enter The Code Sent To %s', 'woodmartplus'), $phone),
            ], 200);

        }
    }

    public function process_woodplus_login()
    {
        if(wp_verify_nonce($_POST['nonce'], 'form_login_register')) {

            $phone = isset($_POST['phone']) && !empty($_POST['phone']) ? sanitize_text_field($_POST['phone']) : null;

            if(!is_null($phone)) {
                $check_number = $this->validate_phone_number($phone);

                if(is_wp_error($check_number)) {
                    wp_send_json([
                        'status' => false,
                        'message' => $check_number->get_error_message(),
                    ], 401);
                }

                if(!$this->is_user_registerd($phone)) {
                    wp_send_json([
                        'status' => false,
                        'message' => __('There is no user with this mobile number', 'woodmartplus'),
                    ], 401);
                }

                if($check_edit_number = $this->check_edit_number($phone)) {
                    wp_send_json([
                        'login_with_number' => $check_edit_number['status'],
                        'message' => $check_edit_number['message'],
                    ], 200);
                }


                $result = $this->otp_handler->send_otp_sms('+98', $phone);

                if(is_wp_error($result)) {
                    wp_send_json([
                        'status' => false,
                        'message' => $result->get_error_message(),
                    ], 401);
                }

                wp_send_json([
                    'login_with_number' => true,
                    'message' => sprintf(__('Enter The Code Sent To %s', 'woodmartplus'), $phone),
                ], 200);
            }

            $result = false;

            $creds = array(
                'user_login'    => trim($_POST['user_name']),
                'user_password' => $_POST['password'],
                'remember'      => isset($_POST['checkRemember']),
            );

            $validation_error = new WP_Error();
            $validation_error = apply_filters('woocommerce_process_login_errors', $validation_error, $_POST['user_name'], $_POST['password']);

            if ($validation_error->get_error_code()) {
                wp_send_json([
                    'loggedin' => false,
                    'message' =>  esc_html__('ارور:', 'woodmartplus') . $validation_error->get_error_message(),
                ], 403);
            }

            if (empty($creds['user_login'])) {
                wp_send_json([
                    'loggedin' => false,
                    'message'  => esc_html__('نام کاربری لازم است', 'woodmartplus')
                ], 403);
            }

            // On multisite, ensure user exists on current site, if not add them before allowing login.
            if (is_multisite()) {
                $user_data = get_user_by(is_email($creds['user_login']) ? 'email' : 'login', $creds['user_login']);

                if ($user_data && ! is_user_member_of_blog($user_data->ID, get_current_blog_id())) {
                    add_user_to_blog(get_current_blog_id(), $user_data->ID, 'customer');
                }
            }

            $user = wp_signon(apply_filters('woocommerce_login_credentials', $creds), is_ssl());
            if (! is_wp_error($user)) {
                $result = true;
            }

            if ($result) {

                wp_send_json([
                    'loggedin' => true,
                    'message' => esc_html__('ورود با موفقیت درحال انتقال...','woodmartplus')
                ], 200);

            } else {
                wp_send_json([
                    'success' => false,
                    'message' => esc_html__('نام کاربری یا رمز عبور اشتباه است.', 'woodmartplus')
                ], 403);
            }
        }

    }

    public function process_verify_otp_login()
    {

        if(wp_verify_nonce($_POST['nonce_verify_otp'], '_form_verify_otp_login')) {

            $phone = isset($_POST['phone']) && !empty($_POST['phone']) ? sanitize_text_field($_POST['phone']) : null;

            if(!is_null($phone)) {
                $data_sended = $this->otp_handler->get_otp_data();
                $incorrect = (int) $data_sended['incorrect'];
                $otp = $data_sended['otp'];
                $otp_form = isset($_POST['otp_sended']) && !empty($_POST['otp_sended']) ? (int) sanitize_text_field($_POST['otp_sended']) : null;
                $ban_time 			= wplus_helper::get_otp_config('ban_time', 120);

                $time_passed = strtotime("now") - (int) $data_sended['created'];

                if($incorrect >= wplus_helper::get_otp_config('incorretct_otp', 4)) {

                    $unban_time_left = $ban_time - $time_passed;

                    if($unban_time_left < 0) {
                        $this->otp_handler->set_otp_data('incorrect', 0);
                    } else {

                        wp_send_json([
                            'status' => false,
                            'redirect' => true,
                            'msg' => sprintf(__('Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus'), $this->otp_handler->getTimeDuration($unban_time_left)),
                        ], 401);
                    }
                }

                if($otp === $otp_form) {
                    if(isset($data_sended['expiry']) && strtotime('now') > (int) $data_sended['expiry']) {
                        wp_send_json(array( 'status' => false,'redirect' => true, 'msg' => __('OTP Expired', 'woodmartplus') ), 401);
                    }

                    $this->otp_handler->set_otp_data(array(
                        'verified' 			=> true,
                        'form_token' 		=> '',
                        'incorrect' 		=> 0,
                        'sent_items' 		=> 0,
                        'expiry' 			=> '',
                        'created' 			=> '',
                    ));

                    $result = $this->user_login($phone);
                    if(is_wp_error($result)) {
                        wp_send_json([
                            'status' => false,
                            'message' => $result->get_error_message(),
                        ], 401);
                    }

                    wp_send_json([
                        'status' => true,
                        'msg' => __('Registration was successful , redirect...', 'woodmartplus'),
                    ], 200);

                } else {

                    $data_sended['incorrect'] = ++$incorrect;

                    $this->otp_handler->set_otp_data($data_sended);

                    wp_send_json([
                        'status' => false,
                        'msg' => __('invalid otp number', 'woodmartplus'),
                    ], 401);
                }

            }

            wp_send_json([
                'status' => false,
                'msg' => __('we have problem with this request', 'woodmartplus'),
            ], 401);

        }
    }

    public function user_login(string $phone)
    {
        $user = $this->user_register_data($phone);

        if($user) {
            wp_clear_auth_cookie();
            wp_set_current_user($user[0]->ID);
            wp_set_auth_cookie($user[0]->ID);

            return true;
        }

        return new WP_Error('user-not-found', __('There is no user with this mobile number', 'woodmartplus'));
    }

    public function validate_phone_number($phone)
    {
        

        if(intval(substr($phone, 0, 2)) !== intval('09')) {

            return new WP_Error('invalid-number', 'شماره مورد نظر باید با 09 شروع شود');
        }

        if(strlen($phone) !== 11) {

            return new WP_Error('invalid-number', 'شماره موبایل وارد شده صحیح نمی باشد');
        }

        return true;
    }

    public function check_edit_number($phone)
    {
        $data_sended = $this->otp_handler->get_otp_data();
        if($data_sended && $data_sended['phone_no'] === $phone) {

            $expire_otp = $data_sended['expiry'];
            $time_now = strtotime("now");
            $time_loaded = $expire_otp - $time_now;

            if($time_loaded > 0) {

                return [
                    'status' => true,
                    'message' => sprintf(__('Enter The Code Sent To %s', 'woodmartplus'), $phone),
                ];
            }
        }
    }

    public function is_user_registerd($phone)
    {
        $user = $this->user_register_data($phone);

        if($user) {

            return true;
        }

        return false;
    }

    public function login_template_ui($page_template)
    {
        global $wp_query;

        if(is_page(woodplust_login_register::get_myaccount_slug()) && ! is_user_logged_in() && ! isset($wp_query->query['lost-password'])) {
            $page_template = DIR_PATH . 'template/myaccount/login.php';
        }

        return $page_template;
    }

    public static function get_myaccount_slug()
    {
        return get_post(get_option('woocommerce_myaccount_page_id'))->post_name;
    }

    public function save_option_data()
    {
        if(isset($_POST['save_otp_data']) && !empty($_POST['save_otp_data']) && 'save' === $_POST['save_otp_data']) {
            if(isset($_POST['woodplus_sms']) && !empty($_POST['woodplus_sms'])) {
                $new_array['woodplus_sms'] = [
                    'setting_loginregister_enable' => 'off',
                ];
                
                foreach($_POST['woodplus_sms'] as $key => $value) {
                    $new_array['woodplus_sms'][$key] = is_array($value) ? array_map('sanitize_text_field', $value) : sanitize_text_field($value);

                    
                    if( !wplus_helper::check_panel_is_active() )
                    {
                        
                        if( $key == 'register_login_type' )
                        {
                            $new_array['woodplus_sms'][$key] = 'layout-4';
                        }
                        add_action( 'admin_notices', [ $this,'admin_warning' ],999);
                    }
                }

                update_option('woodplus_sms', $new_array);
            }
        }
    }

    public function admin_warning( $messages )
    {
        $notice = <<<EOT
        <div class="notice notice-error">
                <p> برای استفاده از ثبت نام و ورود هوشمند ابتدا اطلاعات پنل اس ام اس خود را تکمیل کنید </p>
            </div>
        EOT;
            
        echo $notice;
    }

    public function email_is_registered( $email )
    {
        
        if( $this->get_user_by_email( $email ) )
        {
            return true;
        }
        return false;
    }

    public function get_user_by_email( $email )
    {
        
        $user = get_user_by('email',$email);
        
        if( $user )
        {
            return $user;
        }

        return false;
    }

    public function user_register_data($phone)
    {
        $digist_phone = substr($phone,1);
        
        $args = [
            'meta_key' => ['_wplus_phone','digits_phone_no'],
            'meta_value' => [$digist_phone,$phone],
            'number' => 1
        ];

        $user = get_users($args);

        if(!empty($user)) {
            return $user;
        }

        return false;
    }

    public static function get_otp_option($option, $defualt = '')
    {

        if($option) {

        }
    }

    public function get_option_data()
    {
        return get_option('woodplus_sms');
    }



}

new woodplust_login_register();
