<?php

class wplus_install {


    public function __construct()
    {
            register_activation_hook( WPLUS_FILE, [$this,'installConfig'] );
    }

    public function installConfig()
    {
        foreach( $this->get_config_wplus() as $key => $value )
        {
            if( !get_option( $key ) )
            {
                update_option( $key, $value );
            }
        }
    }

    public function get_config_wplus()
    {
        $op = [];
        $email = get_option('new_admin_email');

        $op[ 'wplus_general_option' ] = [

            'general_option' => [
                'recenlty_viwed_enable' => 'on',
                'enable_panel' => 'on',
                'title_page_dashboard' => 'به پنل کاربری وودمارت پلاس خوش آمدید ، شما میتوانید هر متنی که مدنظر شماست در این قسمت قرار بدهید',
                'width_dashboard' => 1400,
                'color_dashboard' => '#2196f3',
                'color_dashboard_hover' => '#eeee22',
                'recenlty_viewed_show_nummber' => 4,
                'font_dashboard' => 'YekanBakhRegular'
            ]
        ];

        $op['woodplus_sms'] = [
            'woodplus_sms' => [
                'setting_loginregister_enable' => 'on',
                'logo_login_register' => '',
                'register_login_type' => 'layout-4',
                'termsـandـconditions' => 'default',
                'otp' => 
                    [
                        'number_otp' => '4',
                        'incorretct_otp' => '4',
                        'expire_otp' => '30',
                        'otp_resend' => '3',
                        'ban_time' => '100',
                        'wating_resend' => '30',
                    ],
                'operator_name' => 'faraz',
                'title_login_register' => 'ثبت نام ورود',
                'after_title_text' => 'رمز عبور حساب کاربری خود را تعیین کنید. سعی کنید از عبارت های سخت و پیچیده استفاده کنید.',
                'description_login_register' => 'ورود و ثبت نام در حساب کاربری خود ، به معنای پذیرش قوانین و مقررات وبسایت وودمارت میباشد. [wplus_term_condion]',
                'more_description_login_register' => 'ثبت نام در این سایت به شما امکان می دهد به وضعیت و سابقه سفارش خود دسترسی داشته باشید. فقط کافی است فیلدهای زیر را پر کنید، و ما در کمترین زمان یک حساب کاربری جدید برای شما راه اندازی خواهیم کرد. ما فقط از شما اطلاعات لازم را برای سریعتر و آسان تر کردن فرآیند خرید می خواهیم.',
                'email_send_from' => $email ? $email : '',
                'text_send_otp_email' => 'کد یکبار مصرف:',
            ]
        ];

        $op['woodplus_option_notification'] = [
            'notif_section' => 
            array (
                [
                    'title' => 'defualt title',
                    'date' => '1702911461',
                    'image' => '',
                    'description' => 'defualt description',
                ],
            ),
            'enable_notif_data' => 'on',
            'show_notif_number' => '2',
        ];
        $op['woodplus_option_offer'] = [
            'offer_section' => 
            array (
              [
                'title' => 'defualt title',
                'coupon' => '#defualt_coupon',
                'image' => '',
                'description' => 'defualt description',
              ],
            ),
            'enable_offer_data' => 'on',
            'show_offer_number' => '6',
        ];
        
        $op['woodplus_ticket'] = [
            'ticket' => 
                array (
                    'setting_ticket_enable' => 'on',
                    'text_before_send' => 'before send text',
                    'text_how_send' => 'how to send text',
                ),
        ];

        $op['wplus_factor'] = [
            'setting_factor_enable' => 'on',
            'color_factor' => '#41d3c0',
            'width_factor' => '1200',
        ];

        return $op;
    }

}

new wplus_install;