<?php

use Elementor\Control_Select2;

class woodplus_choose_product_elementor_controller extends Control_Select2{

    
    public function get_type()
    {
        return 'chooseproduct';
    }

    public function enqueue()
    {
        
        wp_register_script('select2ajax',plugin_dir_url(__FILE__).'assets/js/select2ajax.js',['jquery'],'',true);
        wp_enqueue_script('select2ajax');

        wp_localize_script('select2ajax', 'woodplusAjaxElementorSelect2', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
        ));
    }

    protected function get_default_settings() {
        
        return [
            'options'        => [],
            'multiple'       => false,
            'select2options' => [],
        ];
    }

    public function content_template() 
    {
        $control_uid = $this->get_control_uid();
        ?>
            <div>
                <label  class="elementor-control-title" for="<?= $control_uid ?>">{{ data.label }}</label>

                <select class="product-include-select" style="width:100%" id="<?= $control_uid ?>" data-setting="{{ data.name }}" {{ multiple }} ></select>

                <input type="hidden" class="product-include-select-save-value" data-setting="{{ data.name }}">

            </div>
        <?php
    }

}