/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-07-26 18:19:27 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=570 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=22100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1685 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=49544 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=13784 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1523 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=345 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` double NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_woodapp_wc_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_woodapp_wc_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'علاقه مندی های من',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("30", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2023-09-26 15:12:02", "2023-09-26 15:12:02", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-26 15:12:43", "2023-09-26 18:42:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("164", "action_scheduler/migration_hook", "failed", "2023-09-26 21:22:44", "2023-09-26 21:22:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1695763364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1695763364;}", "1", "1", "2023-09-26 21:23:02", "2023-09-27 00:53:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("264", "rocket_preload_job_check_finished", "failed", "2023-10-31 12:06:33", "2023-10-31 12:06:33", "10", "[1698753933]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698753993;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698753993;}", "4", "1", "2023-10-31 12:06:35", "2023-10-31 15:36:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("539", "woocommerce_cleanup_draft_orders", "complete", "2024-06-29 07:00:23", "2024-06-29 07:00:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719644423;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719644423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-06-29 07:00:51", "2024-06-29 10:30:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("558", "woocommerce_cleanup_draft_orders", "complete", "2024-07-17 12:55:37", "2024-07-17 12:55:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721220937;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721220937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-17 13:12:59", "2024-07-17 16:42:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("559", "woocommerce_cleanup_draft_orders", "complete", "2024-07-18 13:12:59", "2024-07-18 13:12:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721308379;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721308379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-18 13:25:32", "2024-07-18 16:55:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("560", "woocommerce_cleanup_draft_orders", "complete", "2024-07-19 13:25:32", "2024-07-19 13:25:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721395532;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721395532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-19 13:42:51", "2024-07-19 17:12:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("561", "woocommerce_cleanup_draft_orders", "complete", "2024-07-20 13:42:51", "2024-07-20 13:42:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721482971;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721482971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-20 13:43:40", "2024-07-20 17:13:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("562", "woocommerce_cleanup_draft_orders", "complete", "2024-07-21 13:43:40", "2024-07-21 13:43:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721569420;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721569420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-21 13:46:29", "2024-07-21 17:16:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("563", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-07-21 11:36:58", "2024-07-21 11:36:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1721561818;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1721561818;}", "5", "1", "2024-07-21 11:37:00", "2024-07-21 15:07:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("564", "woocommerce_cleanup_draft_orders", "complete", "2024-07-22 13:46:29", "2024-07-22 13:46:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721655989;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721655989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-22 13:53:06", "2024-07-22 17:23:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("565", "woocommerce_cleanup_draft_orders", "complete", "2024-07-23 13:53:06", "2024-07-23 13:53:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721742786;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721742786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-23 13:54:28", "2024-07-23 17:24:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("566", "woocommerce_cleanup_draft_orders", "complete", "2024-07-24 13:54:28", "2024-07-24 13:54:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721829268;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721829268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-24 13:57:32", "2024-07-24 17:27:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("567", "woocommerce_cleanup_draft_orders", "complete", "2024-07-25 13:57:32", "2024-07-25 13:57:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721915852;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721915852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-25 14:01:49", "2024-07-25 17:31:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("568", "woocommerce_cleanup_draft_orders", "complete", "2024-07-26 14:01:49", "2024-07-26 14:01:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1722002509;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1722002509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-26 14:01:59", "2024-07-26 17:31:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("569", "woocommerce_cleanup_draft_orders", "pending", "2024-07-27 14:01:59", "2024-07-27 14:01:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1722088919;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1722088919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("537", "woocommerce_cleanup_draft_orders", "complete", "2024-06-26 08:26:41", "2024-06-26 08:26:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719390401;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719390401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-06-26 08:40:14", "2024-06-26 12:10:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("538", "woocommerce_cleanup_draft_orders", "complete", "2024-06-27 08:40:14", "2024-06-27 08:40:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719477614;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719477614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-06-28 07:00:23", "2024-06-28 10:30:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("540", "woocommerce_cleanup_draft_orders", "complete", "2024-06-30 07:00:51", "2024-06-30 07:00:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719730851;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719730851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-06-30 07:01:42", "2024-06-30 10:31:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("541", "woocommerce_cleanup_draft_orders", "complete", "2024-07-01 07:01:42", "2024-07-01 07:01:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719817302;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719817302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-01 08:37:20", "2024-07-01 12:07:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("542", "action_scheduler/migration_hook", "complete", "2024-06-30 12:14:31", "2024-06-30 12:14:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1719749671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1719749671;}", "1", "1", "2024-06-30 12:15:10", "2024-06-30 15:45:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("543", "woocommerce_cleanup_draft_orders", "complete", "2024-07-02 08:37:20", "2024-07-02 08:37:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719909440;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719909440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-02 08:42:02", "2024-07-02 12:12:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("544", "woocommerce_cleanup_draft_orders", "complete", "2024-07-03 08:42:02", "2024-07-03 08:42:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1719996122;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1719996122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-03 08:42:40", "2024-07-03 12:12:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("545", "woocommerce_cleanup_draft_orders", "complete", "2024-07-04 08:42:40", "2024-07-04 08:42:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720082560;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720082560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-04 08:50:06", "2024-07-04 12:20:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("546", "woocommerce_cleanup_draft_orders", "complete", "2024-07-05 08:50:06", "2024-07-05 08:50:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720169406;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720169406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-05 09:14:53", "2024-07-05 12:44:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("547", "woocommerce_cleanup_draft_orders", "complete", "2024-07-06 09:14:53", "2024-07-06 09:14:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720257293;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720257293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-06 09:15:17", "2024-07-06 12:45:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("548", "woocommerce_cleanup_draft_orders", "complete", "2024-07-07 09:15:17", "2024-07-07 09:15:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720343717;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720343717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-07 09:15:31", "2024-07-07 12:45:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("549", "woocommerce_cleanup_draft_orders", "complete", "2024-07-08 09:15:31", "2024-07-08 09:15:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720430131;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720430131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-08 09:46:19", "2024-07-08 13:16:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("550", "woocommerce_cleanup_draft_orders", "complete", "2024-07-09 09:46:19", "2024-07-09 09:46:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720518379;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720518379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-09 09:51:04", "2024-07-09 13:21:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("551", "woocommerce_cleanup_draft_orders", "complete", "2024-07-10 09:51:04", "2024-07-10 09:51:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720605064;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720605064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-10 10:13:11", "2024-07-10 13:43:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("552", "woocommerce_cleanup_draft_orders", "complete", "2024-07-11 10:13:11", "2024-07-11 10:13:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720692791;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720692791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-11 10:40:58", "2024-07-11 14:10:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("553", "woocommerce_cleanup_draft_orders", "complete", "2024-07-12 10:40:58", "2024-07-12 10:40:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720780858;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720780858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-12 11:24:49", "2024-07-12 14:54:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("554", "woocommerce_cleanup_draft_orders", "complete", "2024-07-13 11:24:49", "2024-07-13 11:24:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720869889;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720869889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-13 11:37:52", "2024-07-13 15:07:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "woocommerce_cleanup_draft_orders", "complete", "2024-07-14 11:37:52", "2024-07-14 11:37:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1720957072;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1720957072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-14 12:52:49", "2024-07-14 16:22:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("556", "woocommerce_cleanup_draft_orders", "complete", "2024-07-15 12:52:49", "2024-07-15 12:52:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721047969;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721047969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-15 12:54:15", "2024-07-15 16:24:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("557", "woocommerce_cleanup_draft_orders", "complete", "2024-07-16 12:54:15", "2024-07-16 12:54:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1721134455;s:18:\"\0*\0first_timestamp\";i:1695706633;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1721134455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-07-16 12:55:37", "2024-07-16 16:25:37", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "30", "action created", "2023-09-26 15:12:02", "2023-09-26 15:12:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "30", "action started via Async Request", "2023-09-26 15:12:43", "2023-09-26 15:12:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "30", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2023-09-26 15:12:43", "2023-09-26 15:12:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("467", "164", "ایجاد فعالیت", "2023-09-26 21:21:44", "2023-09-26 21:21:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("468", "164", "عملیات توسط Async Request شروع شد", "2023-09-26 21:23:02", "2023-09-26 21:23:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("469", "164", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-26 21:23:02", "2023-09-26 21:23:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("767", "264", "ایجاد فعالیت", "2023-10-31 12:05:33", "2023-10-31 12:05:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("772", "264", "عملیات توسط Async Request شروع شد", "2023-10-31 12:06:35", "2023-10-31 12:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("773", "264", "اقدام از طریق Async Request انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-10-31 12:06:35", "2023-10-31 12:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1594", "539", "ایجاد فعالیت", "2024-06-28 07:00:23", "2024-06-28 07:00:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1593", "538", "عملیات توسط WP Cron کامل شد", "2024-06-28 07:00:23", "2024-06-28 07:00:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1592", "538", "عملیات توسط WP Cron شروع شد", "2024-06-28 07:00:23", "2024-06-28 07:00:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1651", "558", "ایجاد فعالیت", "2024-07-16 12:55:37", "2024-07-16 12:55:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1654", "559", "ایجاد فعالیت", "2024-07-17 13:12:59", "2024-07-17 13:12:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1650", "557", "عملیات توسط WP Cron کامل شد", "2024-07-16 12:55:37", "2024-07-16 12:55:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1649", "557", "عملیات توسط WP Cron شروع شد", "2024-07-16 12:55:37", "2024-07-16 12:55:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1653", "558", "عملیات توسط WP Cron کامل شد", "2024-07-17 13:12:59", "2024-07-17 13:12:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1652", "558", "عملیات توسط WP Cron شروع شد", "2024-07-17 13:12:58", "2024-07-17 13:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1657", "560", "ایجاد فعالیت", "2024-07-18 13:25:32", "2024-07-18 13:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1656", "559", "عملیات توسط WP Cron کامل شد", "2024-07-18 13:25:32", "2024-07-18 13:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1655", "559", "عملیات توسط WP Cron شروع شد", "2024-07-18 13:25:32", "2024-07-18 13:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1660", "561", "ایجاد فعالیت", "2024-07-19 13:42:51", "2024-07-19 13:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1659", "560", "عملیات توسط WP Cron کامل شد", "2024-07-19 13:42:51", "2024-07-19 13:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1658", "560", "عملیات توسط WP Cron شروع شد", "2024-07-19 13:42:51", "2024-07-19 13:42:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1663", "562", "ایجاد فعالیت", "2024-07-20 13:43:40", "2024-07-20 13:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1662", "561", "عملیات توسط WP Cron کامل شد", "2024-07-20 13:43:40", "2024-07-20 13:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1661", "561", "عملیات توسط WP Cron شروع شد", "2024-07-20 13:43:40", "2024-07-20 13:43:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1665", "563", "عملیات توسط Async Request شروع شد", "2024-07-21 11:37:00", "2024-07-21 11:37:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1664", "563", "ایجاد فعالیت", "2024-07-21 11:36:58", "2024-07-21 11:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1672", "565", "ایجاد فعالیت", "2024-07-22 13:53:06", "2024-07-22 13:53:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1671", "564", "عملیات توسط WP Cron کامل شد", "2024-07-22 13:53:06", "2024-07-22 13:53:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1670", "564", "عملیات توسط WP Cron شروع شد", "2024-07-22 13:53:06", "2024-07-22 13:53:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1675", "566", "ایجاد فعالیت", "2024-07-23 13:54:28", "2024-07-23 13:54:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1674", "565", "عملیات توسط WP Cron کامل شد", "2024-07-23 13:54:28", "2024-07-23 13:54:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1673", "565", "عملیات توسط WP Cron شروع شد", "2024-07-23 13:54:28", "2024-07-23 13:54:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1678", "567", "ایجاد فعالیت", "2024-07-24 13:57:32", "2024-07-24 13:57:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1677", "566", "عملیات توسط WP Cron کامل شد", "2024-07-24 13:57:32", "2024-07-24 13:57:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1676", "566", "عملیات توسط WP Cron شروع شد", "2024-07-24 13:57:32", "2024-07-24 13:57:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1681", "568", "ایجاد فعالیت", "2024-07-25 14:01:49", "2024-07-25 14:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1680", "567", "عملیات توسط WP Cron کامل شد", "2024-07-25 14:01:49", "2024-07-25 14:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1679", "567", "عملیات توسط WP Cron شروع شد", "2024-07-25 14:01:49", "2024-07-25 14:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1684", "569", "ایجاد فعالیت", "2024-07-26 14:01:59", "2024-07-26 14:01:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1683", "568", "عملیات توسط WP Cron کامل شد", "2024-07-26 14:01:59", "2024-07-26 14:01:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1682", "568", "عملیات توسط WP Cron شروع شد", "2024-07-26 14:01:59", "2024-07-26 14:01:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1588", "537", "ایجاد فعالیت", "2024-06-25 08:26:41", "2024-06-25 08:26:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1589", "537", "عملیات توسط WP Cron شروع شد", "2024-06-26 08:40:14", "2024-06-26 08:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1590", "537", "عملیات توسط WP Cron کامل شد", "2024-06-26 08:40:14", "2024-06-26 08:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1591", "538", "ایجاد فعالیت", "2024-06-26 08:40:14", "2024-06-26 08:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1595", "539", "عملیات توسط WP Cron شروع شد", "2024-06-29 07:00:51", "2024-06-29 07:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1596", "539", "عملیات توسط WP Cron کامل شد", "2024-06-29 07:00:51", "2024-06-29 07:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1597", "540", "ایجاد فعالیت", "2024-06-29 07:00:51", "2024-06-29 07:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1598", "540", "عملیات توسط WP Cron شروع شد", "2024-06-30 07:01:42", "2024-06-30 07:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1599", "540", "عملیات توسط WP Cron کامل شد", "2024-06-30 07:01:42", "2024-06-30 07:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1600", "541", "ایجاد فعالیت", "2024-06-30 07:01:42", "2024-06-30 07:01:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1601", "542", "ایجاد فعالیت", "2024-06-30 12:13:31", "2024-06-30 12:13:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1602", "542", "عملیات توسط WP Cron شروع شد", "2024-06-30 12:15:10", "2024-06-30 12:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1603", "542", "عملیات توسط WP Cron کامل شد", "2024-06-30 12:15:10", "2024-06-30 12:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1604", "541", "عملیات توسط WP Cron شروع شد", "2024-07-01 08:37:20", "2024-07-01 08:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1605", "541", "عملیات توسط WP Cron کامل شد", "2024-07-01 08:37:20", "2024-07-01 08:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1606", "543", "ایجاد فعالیت", "2024-07-01 08:37:20", "2024-07-01 08:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1607", "543", "عملیات توسط WP Cron شروع شد", "2024-07-02 08:42:02", "2024-07-02 08:42:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1608", "543", "عملیات توسط WP Cron کامل شد", "2024-07-02 08:42:02", "2024-07-02 08:42:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1609", "544", "ایجاد فعالیت", "2024-07-02 08:42:02", "2024-07-02 08:42:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1610", "544", "عملیات توسط WP Cron شروع شد", "2024-07-03 08:42:40", "2024-07-03 08:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1611", "544", "عملیات توسط WP Cron کامل شد", "2024-07-03 08:42:40", "2024-07-03 08:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1612", "545", "ایجاد فعالیت", "2024-07-03 08:42:40", "2024-07-03 08:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1613", "545", "عملیات توسط WP Cron شروع شد", "2024-07-04 08:50:06", "2024-07-04 08:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1614", "545", "عملیات توسط WP Cron کامل شد", "2024-07-04 08:50:06", "2024-07-04 08:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1615", "546", "ایجاد فعالیت", "2024-07-04 08:50:06", "2024-07-04 08:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1616", "546", "عملیات توسط WP Cron شروع شد", "2024-07-05 09:14:53", "2024-07-05 09:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1617", "546", "عملیات توسط WP Cron کامل شد", "2024-07-05 09:14:53", "2024-07-05 09:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1618", "547", "ایجاد فعالیت", "2024-07-05 09:14:53", "2024-07-05 09:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1619", "547", "عملیات توسط WP Cron شروع شد", "2024-07-06 09:15:17", "2024-07-06 09:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1620", "547", "عملیات توسط WP Cron کامل شد", "2024-07-06 09:15:17", "2024-07-06 09:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1621", "548", "ایجاد فعالیت", "2024-07-06 09:15:17", "2024-07-06 09:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1622", "548", "عملیات توسط WP Cron شروع شد", "2024-07-07 09:15:31", "2024-07-07 09:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1623", "548", "عملیات توسط WP Cron کامل شد", "2024-07-07 09:15:31", "2024-07-07 09:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1624", "549", "ایجاد فعالیت", "2024-07-07 09:15:31", "2024-07-07 09:15:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1625", "549", "عملیات توسط WP Cron شروع شد", "2024-07-08 09:46:19", "2024-07-08 09:46:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1626", "549", "عملیات توسط WP Cron کامل شد", "2024-07-08 09:46:19", "2024-07-08 09:46:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1627", "550", "ایجاد فعالیت", "2024-07-08 09:46:19", "2024-07-08 09:46:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1628", "550", "عملیات توسط WP Cron شروع شد", "2024-07-09 09:51:04", "2024-07-09 09:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1629", "550", "عملیات توسط WP Cron کامل شد", "2024-07-09 09:51:04", "2024-07-09 09:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1630", "551", "ایجاد فعالیت", "2024-07-09 09:51:04", "2024-07-09 09:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1631", "551", "عملیات توسط WP Cron شروع شد", "2024-07-10 10:13:11", "2024-07-10 10:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1632", "551", "عملیات توسط WP Cron کامل شد", "2024-07-10 10:13:11", "2024-07-10 10:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1633", "552", "ایجاد فعالیت", "2024-07-10 10:13:11", "2024-07-10 10:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1634", "552", "عملیات توسط WP Cron شروع شد", "2024-07-11 10:40:58", "2024-07-11 10:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1635", "552", "عملیات توسط WP Cron کامل شد", "2024-07-11 10:40:58", "2024-07-11 10:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1636", "553", "ایجاد فعالیت", "2024-07-11 10:40:58", "2024-07-11 10:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1637", "553", "عملیات توسط WP Cron شروع شد", "2024-07-12 11:24:49", "2024-07-12 11:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1638", "553", "عملیات توسط WP Cron کامل شد", "2024-07-12 11:24:49", "2024-07-12 11:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1639", "554", "ایجاد فعالیت", "2024-07-12 11:24:49", "2024-07-12 11:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1640", "554", "عملیات توسط WP Cron شروع شد", "2024-07-13 11:37:52", "2024-07-13 11:37:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1641", "554", "عملیات توسط WP Cron کامل شد", "2024-07-13 11:37:52", "2024-07-13 11:37:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1642", "555", "ایجاد فعالیت", "2024-07-13 11:37:52", "2024-07-13 11:37:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1643", "555", "عملیات توسط WP Cron شروع شد", "2024-07-14 12:52:49", "2024-07-14 12:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1644", "555", "عملیات توسط WP Cron کامل شد", "2024-07-14 12:52:49", "2024-07-14 12:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1645", "556", "ایجاد فعالیت", "2024-07-14 12:52:49", "2024-07-14 12:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1646", "556", "عملیات توسط WP Cron شروع شد", "2024-07-15 12:54:15", "2024-07-15 12:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1647", "556", "عملیات توسط WP Cron کامل شد", "2024-07-15 12:54:15", "2024-07-15 12:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1648", "557", "ایجاد فعالیت", "2024-07-15 12:54:15", "2024-07-15 12:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1666", "563", "عملیات توسط Async Request کامل شد", "2024-07-21 11:37:00", "2024-07-21 11:37:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1667", "562", "عملیات توسط WP Cron شروع شد", "2024-07-21 13:46:29", "2024-07-21 13:46:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1668", "562", "عملیات توسط WP Cron کامل شد", "2024-07-21 13:46:29", "2024-07-21 13:46:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1669", "564", "ایجاد فعالیت", "2024-07-21 13:46:29", "2024-07-21 13:46:29");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "2", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "2", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "2", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "3", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("7", "3", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("8", "3", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("9", "3", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("10", "3", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("11", "4", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("12", "4", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("13", "4", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("14", "4", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("15", "4", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("16", "5", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("17", "5", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("18", "5", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("19", "5", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("20", "5", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("21", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("22", "6", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("23", "6", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("24", "6", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("25", "6", "wd_total_vote", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "128", "admina", "info@gmail.com", "https://demoes.aramis-co.ir/basenew", "46.100.52.129", "2023-09-30 00:46:16", "2023-09-29 21:16:16", "محصول عالی است", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36 Edg/117.0.2045.40", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("3", "94", "admina", "info@gmail.com", "https://demoes.aramis-co.ir/basenew", "46.100.52.129", "2023-09-30 00:53:08", "2023-09-29 21:23:08", "عالی بود", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36 Edg/117.0.2045.40", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("4", "198", "admina", "info@gmail.com", "https://demoes.aramis-co.ir/basenew", "46.100.52.129", "2023-09-30 16:59:08", "2023-09-30 13:29:08", "عالی بود", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36 Edg/117.0.2045.47", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("5", "1369", "عباس نجفی", "win1.iran@gmail.com", "", "5.125.4.147", "2023-10-19 18:04:20", "2023-10-19 14:34:20", "خیلی عالی بود", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "1368", "pypthu", "govji9@gmail.com", "", "5.112.96.213", "2024-03-13 14:28:18", "2024-03-13 10:58:18", "lpujpopp[ppotp=yp=op-p", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "review", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("8", "basenew", "48da23e95ee078552926_20240726181823", "21", "2024-07-26 18:19:27", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-07-26 18:18:23\";s:7:\"Version\";s:5:\"1.5.9\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.6.17\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:8;s:4:\"Name\";s:7:\"basenew\";s:4:\"Hash\";s:35:\"48da23e95ee078552926_20240726181823\";s:8:\"NameHash\";s:43:\"basenew_48da23e95ee078552926_20240726181823\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:53:\"basenew_48da23e95ee078552926_20240726181823_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:55:\"basenew_48da23e95ee078552926_20240726181823_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:62:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2439;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17092;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-07-26 18:18:23\";s:7:\"Version\";s:5:\"1.5.9\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:7:\"10.6.17\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"basenew\";s:4:\"Hash\";s:35:\"48da23e95ee078552926_20240726181823\";s:8:\"NameHash\";s:43:\"basenew_48da23e95ee078552926_20240726181823\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:61:\"basenew_48da23e95ee078552926_20240726181823_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:76:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:56:\"basenew_48da23e95ee078552926_20240726181823_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:151:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/backups-dup-lite/tmp/basenew_48da23e95ee078552926_20240726181823_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:71:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-admin\";i:1;s:74:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes\";i:2;s:83:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:62:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew\";i:1;s:62:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew\";i:2;s:73:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content\";i:3;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/uploads\";i:4;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/plugins\";i:5;s:84:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/mu-plugins\";i:6;s:80:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:94:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demoes.aramis-co.ir/basenew", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demoes.aramis-co.ir/basenew", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "دمو کلاسیک", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:364:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:23:\"^/([^/]*)/page/([^/]*)?\";s:61:\"index.php?page_id=0&wishlist_id=$matches[1]&paged=$matches[2]\";s:15:\"^/page/([^/]*)?\";s:37:\"index.php?page_id=0&paged=$matches[1]\";s:11:\"^/([^/]*)/?\";s:43:\"index.php?page_id=0&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:51:\"e-landing-page/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?e-landing-page=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"e-landing-page/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("48205", "_transient_timeout_woocommerce_admin_remote_free_extensions_specs", "1722582365", "off");
INSERT INTO `wp_options` VALUES("48206", "_transient_woocommerce_admin_remote_free_extensions_specs", "a:1:{s:5:\"fa_IR\";a:5:{s:10:\"obw/basics\";O:8:\"stdClass\":3:{s:3:\"key\";s:10:\"obw/basics\";s:5:\"title\";s:46:\"اصول اولیه را دریافت کنید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:205:\"کارت‌های اعتباری و سایر روش‌های پرداخت محبوب را با <a href=\"https://woocommerce.com/products/woocommerce-payments\" target=\"_blank\">WooPayments</a> بپذیرید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:31:\"حمل و نقل ووکامرس\";s:11:\"description\";s:139:\"چاپ برچسب های حمل و نقل با <a href=\"https://woocommerce.com/products/shipping\" target=\"_blank\">WooCommerce Shipping</a>\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:13:\"product_types\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:5:\"count\";}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";i:1;s:7:\"default\";a:0:{}s:9:\"operation\";s:2:\"!=\";}}i:1;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"product_types.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:9:\"downloads\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:2:\"!=\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"مالیات ووکامرس\";s:11:\"description\";s:158:\"با <a href=\"https://woocommerce.com/products/tax\" target=\"_blank\">مالیات WooCommerce</a> مالیات بر فروش خودکار دریافت کنید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"جت پک\";s:11:\"description\";s:123:\"افزایش سرعت و امنیت با <a href=\"https://woocommerce.com/products/jetpack\" target=\"_blank\">جت‌پک</a>\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:7:\"jetpack\";}}}}}s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";}}}s:8:\"obw/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:8:\"obw/grow\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:152:\"با <a href=\"https://woocommerce.com/products/mailpoet\" target=\"_blank\">MailPoet</a> سطح ایمیل مارکتینگ خود را ارتقا دهید\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:61;i:1;i:120;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";}i:1;O:8:\"stdClass\":8:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:142:\"هدایت فروش‌ها با <a href=\"https://woocommerce.com/products/google-listings-and-ads\" target=\"_blank\">Google Listings and Ads</a>\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";}i:2;O:8:\"stdClass\":7:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:137:\"محصولات خود را در مقابل Pinners در جستجوی ایده ها و چیزهایی برای خرید قرار دهید.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:36:\"فیسبوک برای ووکامرس\";s:11:\"description\";s:186:\"فهرست محصولات و ایجاد تبلیغات در فیس‌بوک و اینستاگرام با <a href=\"https://woocommerce.com/products/facebook/\">Facebook for WooCommerce</a>\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:24:\"facebook-for-woocommerce\";}}}s:15:\"task-list/reach\";O:8:\"stdClass\":3:{s:3:\"key\";s:15:\"task-list/reach\";s:5:\"title\";s:41:\"با مشتریان تماس بگیرید\";s:7:\"plugins\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:189:\"ایمیل‌های پیگیری خرید، خبرنامه‌ها و کمپین‌های تبلیغاتی را مستقیماً از داشبورد خود ایجاد و ارسال کنید.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailpoet.svg\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:12:\"mailpoet:alt\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:149:\"با Mailchimp کمپین‌های هدفمند ارسال، سبدهای خرید رها شده و موارد دیگر را بازیابی کنید.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:29:\"mailchimp-for-woocommerce:alt\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:217:\"با خودکارسازی بازاریابی ایمیلی و پیامکی هوشمند و تاثیرگذار و دیدگاه تلفیقی از تعاملات مشتری، مشتریان را رشد و حفظ کنید.\";s:9:\"image_url\";s:95:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:7:\"klaviyo\";}}}s:14:\"task-list/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:14:\"task-list/grow\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:326:\"به خریداران بیشتری دسترسی پیدا کنید و فروش را برای فروشگاه خود افزایش دهید. با گوگل ادغام شوید تا محصولات خود را به صورت رایگان فهرست کنید و کمپین های تبلیغاتی پولی راه اندازی کنید.\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:27:\"google-listings-and-ads:alt\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:30:\"TikTok برای ووکامرس\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/tiktok.svg\";s:11:\"description\";s:203:\"با تبلیغ محصولات خود در TikTok به بیش از یک میلیارد کاربر فعال ماهانه در سراسر جهان، فروش آنلاین خود را افزایش دهید.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:293:\"محصولات خود را در مقابل کاربران پینترست که در جستجوی ایده‌ها و چیزهایی برای خرید هستند قرار دهید. با پینترست شروع کنید و کل کاتالوگ محصولات خود را قابل مرور کنید.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"pinterest-for-woocommerce:alt\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:36:\"فیسبوک برای ووکامرس\";s:11:\"description\";s:96:\"لیست محصولات و ایجاد تبلیغات در فیس بوک و اینستاگرام.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:28:\"facebook-for-woocommerce:alt\";}}}s:17:\"obw/core-profiler\";O:8:\"stdClass\":3:{s:3:\"key\";s:17:\"obw/core-profiler\";s:5:\"title\";s:42:\"فروشگاه خود را رشد دهید\";s:7:\"plugins\";a:9:{i:0;O:8:\"stdClass\":10:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:161:\"پرداخت ها را ایمن بپذیرید و فعالیت پرداخت را مستقیماً از داشبورد فروشگاه خود مدیریت کنید\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";s:5:\"label\";s:45:\"با WooPayments پول دریافت کنید\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:123:\"https://woocommerce.com/products/woocommerce-payments?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:5;}i:1;O:8:\"stdClass\":9:{s:4:\"name\";s:31:\"حمل و نقل ووکامرس\";s:11:\"description\";s:158:\"برچسب های USPS و DHL را مستقیماً از داشبورد خود چاپ کنید و در هزینه حمل و نقل صرفه جویی کنید.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";s:5:\"label\";s:69:\"چاپ برچسب‌های حمل و نقل با WooCommerce Shipping\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:114:\"https://woocommerce.com/woocommerce-shipping?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:3;}i:2;O:8:\"stdClass\":10:{s:4:\"name\";s:9:\"جت پک\";s:11:\"description\";s:216:\"در زمان تولید محتوا صرفه‌جویی کنید — نوشته‌ها و برگه‌های وبلاگ با کیفیت بالا را با استفاده از هوش مصنوعی داشته باشید.\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";s:5:\"label\";s:72:\"تولید محتوا را با Jetpack AI Assistant تقویت کنید\";s:9:\"image_url\";s:114:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-jetpack.svg\";s:15:\"learn_more_link\";s:110:\"https://woocommerce.com/products/jetpack?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:8;}i:3;O:8:\"stdClass\":10:{s:4:\"name\";s:38:\"پینترست برای ووکامرس\";s:11:\"description\";s:97:\"محصولات خود را در مقابل یک مخاطب بسیار فعال قرار دهید.\";s:9:\"image_url\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-pinterest.svg\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";s:5:\"label\";s:77:\"محصولات خود را در پینترست به نمایش بگذارید\";s:15:\"learn_more_link\";s:128:\"https://woocommerce.com/products/pinterest-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:2;}i:4;O:8:\"stdClass\":10:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:149:\"با Mailchimp کمپین‌های هدفمند ارسال، سبدهای خرید رها شده و موارد دیگر را بازیابی کنید.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:60;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:3:\"key\";s:25:\"mailchimp-for-woocommerce\";s:5:\"label\";s:35:\"Reach your customers with MailChimp\";s:15:\"learn_more_link\";s:128:\"https://woocommerce.com/products/mailchimp-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:7;}i:5;O:8:\"stdClass\":10:{s:4:\"name\";s:17:\"میل‌پوئت\";s:11:\"description\";s:131:\"ایمیل‌های پیگیری خرید، خبرنامه‌ها و کمپین‌های تبلیغاتی را ارسال کنید.\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:61;i:1;i:120;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";s:5:\"label\";s:51:\"با MailPoet به مشتریان خود برسید\";s:9:\"image_url\";s:115:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-mailpoet.svg\";s:15:\"learn_more_link\";s:111:\"https://woocommerce.com/products/mailpoet?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:7;}i:6;O:8:\"stdClass\":11:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:138:\"با listings and ads رایگان به میلیون‌ها خریدار فعال در سراسر گوگل دسترسی پیدا کنید.\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";s:5:\"label\";s:64:\"با Google Listings & Ads، فروش را افزایش دهید\";s:15:\"learn_more_link\";s:126:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:6;}i:7;O:8:\"stdClass\":9:{s:4:\"name\";s:27:\"مالیات ووکامرس\";s:11:\"description\";s:172:\"به طور خودکار محاسبه کنید که چقدر مالیات بر فروش باید جمع‌آوری شود - بر اساس شهر، کشور یا ایالت.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";s:5:\"label\";s:91:\"با WooCommerce Tax نرخ‌های مالیاتی را خودکار دریافت کنید\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:106:\"https://woocommerce.com/products/tax?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:4;}i:8;O:8:\"stdClass\":10:{s:4:\"name\";s:30:\"TikTok برای ووکامرس\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-tiktok.svg\";s:11:\"description\";s:138:\"کمپین‌های تبلیغاتی ایجاد کنید و به یک میلیارد کاربر جهانی دسترسی پیدا کنید.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";s:5:\"label\";s:77:\"در تیک‌تاک کمپین‌های تبلیغاتی ایجاد کنید\";s:15:\"learn_more_link\";s:125:\"https://woocommerce.com/products/tiktok-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:1;}}}}}", "off");
INSERT INTO `wp_options` VALUES("3268", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `wp_options` VALUES("3270", "rcuPluginLastHealthyServerIndex", "2", "off");
INSERT INTO `wp_options` VALUES("3273", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:11:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:23:\"elementor/elementor.php\";i:6;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:7;s:21:\"safe-svg/safe-svg.php\";i:8;s:53:\"widget-importer-exporter/widget-importer-exporter.php\";i:9;s:27:\"woocommerce/woocommerce.php\";i:11;s:31:\"woodmart-core/woodmart-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("48221", "_transient_timeout_orders-all-statuses", "1722167098", "off");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "+3.5", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:2:{i:0;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-content/themes/woodmart/style.css\";i:1;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "221", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "2", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "1443", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1730030181", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:6:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:34:\"woodmart-woocommerce-layered-nav-3\";i:2;s:34:\"woodmart-woocommerce-layered-nav-2\";i:3;s:27:\"woocommerce_rating_filter-2\";i:4;s:26:\"woocommerce_price_filter-2\";i:5;s:32:\"woocommerce_product_categories-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("157", "current_theme", "Woodmart", "yes");
INSERT INTO `wp_options` VALUES("158", "theme_mods_woodmart", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:29;}s:18:\"custom_css_post_id\";i:411;}", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("160", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("161", "woodmart_is_activated", "", "yes");
INSERT INTO `wp_options` VALUES("669", "xts-header_524641-css-data", ":root{\n	--wd-top-bar-h: 40px;\n	--wd-top-bar-sm-h: 40px;\n	--wd-top-bar-sticky-h: .00001px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 90px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: .00001px;\n	--wd-header-general-brd-w: 1px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: .00001px;\n	--wd-header-bottom-sticky-h: .00001px;\n	--wd-header-bottom-brd-w: .00001px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n.whb-top-bar .wd-dropdown {\n	margin-top: 0px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 10px;\n}\n\n\n\n\n:root:has(.whb-general-header.whb-border-boxed) {\n	--wd-header-general-brd-w: .00001px;\n}\n\n@media (max-width: 1024px) {\n:root:has(.whb-general-header.whb-hidden-mobile) {\n	--wd-header-general-brd-w: .00001px;\n}\n}\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n\n		\n.whb-3ubz0regyf7lvc74o8j8 .searchform {\n	--wd-form-height: 46px;\n}\n.whb-row .whb-h8aoepyjtdk41b9fcqyy.wd-tools-element .wd-tools-inner, .whb-row .whb-h8aoepyjtdk41b9fcqyy.wd-tools-element > a > .wd-tools-icon {\n	color: rgba(255, 255, 255, 1);\n	background-color: rgba(214, 6, 68, 1);\n}\n.whb-row .whb-h8aoepyjtdk41b9fcqyy.wd-tools-element:hover .wd-tools-inner, .whb-row .whb-h8aoepyjtdk41b9fcqyy.wd-tools-element:hover > a > .wd-tools-icon {\n	color: rgba(255, 255, 255, 1);\n	background-color: rgba(214, 6, 68, 1);\n}\n.whb-h8aoepyjtdk41b9fcqyy.wd-tools-element.wd-design-8 .wd-tools-icon {\n	color: rgba(214, 6, 68, 1);\n	background-color: rgba(255, 255, 255, 1);\n}\n.whb-h8aoepyjtdk41b9fcqyy.wd-tools-element.wd-design-8:hover .wd-tools-icon {\n	color: rgba(214, 6, 68, 1);\n	background-color: rgba(255, 255, 255, 1);\n}\n.whb-general-header {\n	background-color: rgba(255, 255, 255, 1);border-color: rgba(238, 238, 238, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-header-bottom {\n	background-color: rgba(255, 255, 255, 1);\n}\n", "yes");
INSERT INTO `wp_options` VALUES("163", "xts-options-presets", "", "yes");
INSERT INTO `wp_options` VALUES("164", "xts-woodmart-options", "a:623:{s:12:\"last_message\";s:4:\"save\";s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:12:\"small-images\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:8:\"last_tab\";s:14:\"footer_section\";}", "yes");
INSERT INTO `wp_options` VALUES("165", "woodmart_setup_status", "", "yes");
INSERT INTO `wp_options` VALUES("166", "wd_import_theme_version", "", "yes");
INSERT INTO `wp_options` VALUES("167", "woodmart-plugins-update-time", "1722007036", "yes");
INSERT INTO `wp_options` VALUES("168", "woodmart_js_composer_version", "7.8", "yes");
INSERT INTO `wp_options` VALUES("169", "woodmart_revslider_version", "6.7.15", "yes");
INSERT INTO `wp_options` VALUES("123", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("124", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:23:{i:1722018006;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1722018773;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1722019028;a:2:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1722019047;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1722020989;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1722021223;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1722027600;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722046680;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722058373;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1722058514;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1722058517;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722058618;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1722058625;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722058626;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722058628;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722080228;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722091018;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1722249000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722287669;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722361410;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722403973;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722857878;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("44483", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("49137", "_transient_wc_layered_nav_counts_pa_color", "a:22:{i:0;b:0;s:32:\"fa294a0b51d0ef95cd9b53bd4b92736e\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"c1239056e894588a23fc71fe2ba82aac\";a:4:{i:21;i:1;i:22;i:1;i:23;i:1;i:24;i:1;}s:32:\"0e378bc0b444fc690c1c97665a26f8c1\";a:0:{}s:32:\"d584f1a93ecf6ce1c3f5867809305269\";a:0:{}s:32:\"475da53584b3fdb388b631806fb760c1\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"5e2f69aa0d70319108fde1b958c134eb\";a:0:{}s:32:\"3593f719ac25a280d288fb12d4708a1a\";a:0:{}s:32:\"08ce5432216aaffcc79e9b79ee194ae5\";a:0:{}s:32:\"8361f6a66686b69efd918d16a276b266\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"1803cfa4068c71850a7cd416fccbd980\";a:4:{i:21;i:2;i:22;i:2;i:23;i:2;i:24;i:2;}s:32:\"9eb71ad0e791f2e6389ea866ba85f0db\";a:0:{}s:32:\"54998861fe079426eccb1c362e72d009\";a:0:{}s:32:\"2eb56071d71a32ad9841738c5b52b4fd\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"f84d5f03b71227b1337a1c11096f240c\";a:0:{}s:32:\"57f91fce0f655d62cd28844246831963\";a:4:{i:21;i:2;i:22;i:2;i:23;i:2;i:24;i:2;}s:32:\"4cde21e6421d76db48a2f49d948dcb8d\";a:4:{i:21;i:3;i:22;i:3;i:23;i:3;i:24;i:3;}s:32:\"e836ef12fb790ba7ae24399cf99c4eff\";a:4:{i:21;i:1;i:22;i:1;i:23;i:1;i:24;i:1;}s:32:\"a38383d014fafaf3eb3851b8046f56f0\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"c5fb2c28938b5822925b19312fff0ee0\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"ca98f716a75194a3ac3ce38c5b445761\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}s:32:\"989604049dde95d03dd16f59cb0a364d\";a:4:{i:21;i:12;i:22;i:12;i:23;i:12;i:24;i:12;}}", "off");
INSERT INTO `wp_options` VALUES("48830", "_transient_timeout_wc_product_children_145", "1724347410", "off");
INSERT INTO `wp_options` VALUES("48831", "_transient_wc_product_children_145", "a:2:{s:3:\"all\";a:16:{i:0;i:146;i:1;i:147;i:2;i:148;i:3;i:149;i:4;i:150;i:5;i:151;i:6;i:152;i:7;i:153;i:8;i:154;i:9;i:155;i:10;i:156;i:11;i:157;i:12;i:158;i:13;i:159;i:14;i:160;i:15;i:161;}s:7:\"visible\";a:16:{i:0;i:146;i:1;i:147;i:2;i:148;i:3;i:149;i:4;i:150;i:5;i:151;i:6;i:152;i:7;i:153;i:8;i:154;i:9;i:155;i:10;i:156;i:11;i:157;i:12;i:158;i:13;i:159;i:14;i:160;i:15;i:161;}}", "off");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("122", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1695706558;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("134", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("135", "_transient_wp_core_block_css_files", "a:496:{i:0;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/editor-rtl.css\";i:1;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/editor-rtl.min.css\";i:2;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/editor.css\";i:3;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/editor.min.css\";i:4;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/style-rtl.css\";i:5;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/style-rtl.min.css\";i:6;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/style.css\";i:7;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/archives/style.min.css\";i:8;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/editor-rtl.css\";i:9;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/editor-rtl.min.css\";i:10;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/editor.css\";i:11;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/editor.min.css\";i:12;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/style-rtl.css\";i:13;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/style-rtl.min.css\";i:14;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/style.css\";i:15;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/style.min.css\";i:16;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/theme-rtl.css\";i:17;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/theme-rtl.min.css\";i:18;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/theme.css\";i:19;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/audio/theme.min.css\";i:20;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/editor-rtl.css\";i:21;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/editor-rtl.min.css\";i:22;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/editor.css\";i:23;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/editor.min.css\";i:24;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/style-rtl.css\";i:25;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/style-rtl.min.css\";i:26;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/style.css\";i:27;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/avatar/style.min.css\";i:28;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/block/editor-rtl.css\";i:29;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/block/editor-rtl.min.css\";i:30;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/block/editor.css\";i:31;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/block/editor.min.css\";i:32;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/editor-rtl.css\";i:33;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/editor-rtl.min.css\";i:34;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/editor.css\";i:35;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/editor.min.css\";i:36;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/style-rtl.css\";i:37;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/style-rtl.min.css\";i:38;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/style.css\";i:39;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/button/style.min.css\";i:40;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/editor-rtl.css\";i:41;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/editor-rtl.min.css\";i:42;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/editor.css\";i:43;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/editor.min.css\";i:44;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/style-rtl.css\";i:45;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/style-rtl.min.css\";i:46;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/style.css\";i:47;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/buttons/style.min.css\";i:48;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/calendar/style-rtl.css\";i:49;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/calendar/style-rtl.min.css\";i:50;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/calendar/style.css\";i:51;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/calendar/style.min.css\";i:52;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/editor-rtl.css\";i:53;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/editor-rtl.min.css\";i:54;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/editor.css\";i:55;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/editor.min.css\";i:56;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/style-rtl.css\";i:57;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/style-rtl.min.css\";i:58;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/style.css\";i:59;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/categories/style.min.css\";i:60;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/editor-rtl.css\";i:61;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/editor-rtl.min.css\";i:62;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/editor.css\";i:63;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/editor.min.css\";i:64;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/style-rtl.css\";i:65;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/style-rtl.min.css\";i:66;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/style.css\";i:67;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/style.min.css\";i:68;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/theme-rtl.css\";i:69;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/theme-rtl.min.css\";i:70;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/theme.css\";i:71;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/code/theme.min.css\";i:72;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/editor-rtl.css\";i:73;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/editor-rtl.min.css\";i:74;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/editor.css\";i:75;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/editor.min.css\";i:76;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/style-rtl.css\";i:77;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/style-rtl.min.css\";i:78;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/style.css\";i:79;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/columns/style.min.css\";i:80;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-content/style-rtl.css\";i:81;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-content/style-rtl.min.css\";i:82;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-content/style.css\";i:83;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-content/style.min.css\";i:84;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-template/style-rtl.css\";i:85;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-template/style-rtl.min.css\";i:86;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-template/style.css\";i:87;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comment-template/style.min.css\";i:88;s:124:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination-numbers/editor-rtl.css\";i:89;s:128:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination-numbers/editor-rtl.min.css\";i:90;s:120:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination-numbers/editor.css\";i:91;s:124:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination-numbers/editor.min.css\";i:92;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/editor-rtl.css\";i:93;s:120:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/editor-rtl.min.css\";i:94;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/editor.css\";i:95;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/editor.min.css\";i:96;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/style-rtl.css\";i:97;s:119:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/style-rtl.min.css\";i:98;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/style.css\";i:99;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-pagination/style.min.css\";i:100;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-title/editor-rtl.css\";i:101;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-title/editor-rtl.min.css\";i:102;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-title/editor.css\";i:103;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments-title/editor.min.css\";i:104;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/editor-rtl.css\";i:105;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/editor-rtl.min.css\";i:106;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/editor.css\";i:107;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/editor.min.css\";i:108;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/style-rtl.css\";i:109;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/style-rtl.min.css\";i:110;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/style.css\";i:111;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/comments/style.min.css\";i:112;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/editor-rtl.css\";i:113;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/editor-rtl.min.css\";i:114;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/editor.css\";i:115;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/editor.min.css\";i:116;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/style-rtl.css\";i:117;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/style-rtl.min.css\";i:118;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/style.css\";i:119;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/cover/style.min.css\";i:120;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/editor-rtl.css\";i:121;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/editor-rtl.min.css\";i:122;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/editor.css\";i:123;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/editor.min.css\";i:124;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/style-rtl.css\";i:125;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/style-rtl.min.css\";i:126;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/style.css\";i:127;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/details/style.min.css\";i:128;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/editor-rtl.css\";i:129;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/editor-rtl.min.css\";i:130;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/editor.css\";i:131;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/editor.min.css\";i:132;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/style-rtl.css\";i:133;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/style-rtl.min.css\";i:134;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/style.css\";i:135;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/style.min.css\";i:136;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/theme-rtl.css\";i:137;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/theme-rtl.min.css\";i:138;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/theme.css\";i:139;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/embed/theme.min.css\";i:140;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/editor-rtl.css\";i:141;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/editor-rtl.min.css\";i:142;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/editor.css\";i:143;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/editor.min.css\";i:144;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/style-rtl.css\";i:145;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/style-rtl.min.css\";i:146;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/style.css\";i:147;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/file/style.min.css\";i:148;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/footnotes/style-rtl.css\";i:149;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/footnotes/style-rtl.min.css\";i:150;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/footnotes/style.css\";i:151;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/footnotes/style.min.css\";i:152;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/freeform/editor-rtl.css\";i:153;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/freeform/editor-rtl.min.css\";i:154;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/freeform/editor.css\";i:155;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/freeform/editor.min.css\";i:156;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/editor-rtl.css\";i:157;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/editor-rtl.min.css\";i:158;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/editor.css\";i:159;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/editor.min.css\";i:160;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/style-rtl.css\";i:161;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/style-rtl.min.css\";i:162;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/style.css\";i:163;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/style.min.css\";i:164;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/theme-rtl.css\";i:165;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/theme-rtl.min.css\";i:166;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/theme.css\";i:167;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/gallery/theme.min.css\";i:168;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/editor-rtl.css\";i:169;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/editor-rtl.min.css\";i:170;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/editor.css\";i:171;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/editor.min.css\";i:172;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/style-rtl.css\";i:173;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/style-rtl.min.css\";i:174;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/style.css\";i:175;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/style.min.css\";i:176;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/theme-rtl.css\";i:177;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/theme-rtl.min.css\";i:178;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/theme.css\";i:179;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/group/theme.min.css\";i:180;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/heading/style-rtl.css\";i:181;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/heading/style-rtl.min.css\";i:182;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/heading/style.css\";i:183;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/heading/style.min.css\";i:184;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/html/editor-rtl.css\";i:185;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/html/editor-rtl.min.css\";i:186;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/html/editor.css\";i:187;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/html/editor.min.css\";i:188;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/editor-rtl.css\";i:189;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/editor-rtl.min.css\";i:190;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/editor.css\";i:191;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/editor.min.css\";i:192;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/style-rtl.css\";i:193;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/style-rtl.min.css\";i:194;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/style.css\";i:195;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/style.min.css\";i:196;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/theme-rtl.css\";i:197;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/theme-rtl.min.css\";i:198;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/theme.css\";i:199;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/image/theme.min.css\";i:200;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-comments/style-rtl.css\";i:201;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-comments/style-rtl.min.css\";i:202;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-comments/style.css\";i:203;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-comments/style.min.css\";i:204;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/editor-rtl.css\";i:205;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/editor-rtl.min.css\";i:206;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/editor.css\";i:207;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/editor.min.css\";i:208;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/style-rtl.css\";i:209;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/style-rtl.min.css\";i:210;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/style.css\";i:211;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/latest-posts/style.min.css\";i:212;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/list/style-rtl.css\";i:213;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/list/style-rtl.min.css\";i:214;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/list/style.css\";i:215;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/list/style.min.css\";i:216;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/editor-rtl.css\";i:217;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/editor-rtl.min.css\";i:218;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/editor.css\";i:219;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/editor.min.css\";i:220;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/style-rtl.css\";i:221;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/style-rtl.min.css\";i:222;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/style.css\";i:223;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/media-text/style.min.css\";i:224;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/more/editor-rtl.css\";i:225;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/more/editor-rtl.min.css\";i:226;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/more/editor.css\";i:227;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/more/editor.min.css\";i:228;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/editor-rtl.css\";i:229;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/editor-rtl.min.css\";i:230;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/editor.css\";i:231;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/editor.min.css\";i:232;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/style-rtl.css\";i:233;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/style-rtl.min.css\";i:234;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/style.css\";i:235;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-link/style.min.css\";i:236;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-submenu/editor-rtl.css\";i:237;s:119:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-submenu/editor-rtl.min.css\";i:238;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-submenu/editor.css\";i:239;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation-submenu/editor.min.css\";i:240;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/editor-rtl.css\";i:241;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/editor-rtl.min.css\";i:242;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/editor.css\";i:243;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/editor.min.css\";i:244;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/style-rtl.css\";i:245;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/style-rtl.min.css\";i:246;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/style.css\";i:247;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/navigation/style.min.css\";i:248;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/nextpage/editor-rtl.css\";i:249;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/nextpage/editor-rtl.min.css\";i:250;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/nextpage/editor.css\";i:251;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/nextpage/editor.min.css\";i:252;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/editor-rtl.css\";i:253;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/editor-rtl.min.css\";i:254;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/editor.css\";i:255;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/editor.min.css\";i:256;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/style-rtl.css\";i:257;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/style-rtl.min.css\";i:258;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/style.css\";i:259;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/page-list/style.min.css\";i:260;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/editor-rtl.css\";i:261;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/editor-rtl.min.css\";i:262;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/editor.css\";i:263;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/editor.min.css\";i:264;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/style-rtl.css\";i:265;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/style-rtl.min.css\";i:266;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/style.css\";i:267;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/paragraph/style.min.css\";i:268;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-author/style-rtl.css\";i:269;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-author/style-rtl.min.css\";i:270;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-author/style.css\";i:271;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-author/style.min.css\";i:272;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/editor-rtl.css\";i:273;s:119:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/editor-rtl.min.css\";i:274;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/editor.css\";i:275;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/editor.min.css\";i:276;s:114:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/style-rtl.css\";i:277;s:118:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/style-rtl.min.css\";i:278;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/style.css\";i:279;s:114:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-comments-form/style.min.css\";i:280;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-date/style-rtl.css\";i:281;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-date/style-rtl.min.css\";i:282;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-date/style.css\";i:283;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-date/style.min.css\";i:284;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/editor-rtl.css\";i:285;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/editor-rtl.min.css\";i:286;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/editor.css\";i:287;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/editor.min.css\";i:288;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/style-rtl.css\";i:289;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/style-rtl.min.css\";i:290;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/style.css\";i:291;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-excerpt/style.min.css\";i:292;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/editor-rtl.css\";i:293;s:120:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/editor-rtl.min.css\";i:294;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/editor.css\";i:295;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/editor.min.css\";i:296;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/style-rtl.css\";i:297;s:119:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/style-rtl.min.css\";i:298;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/style.css\";i:299;s:115:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-featured-image/style.min.css\";i:300;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-navigation-link/style-rtl.css\";i:301;s:120:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-navigation-link/style-rtl.min.css\";i:302;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-navigation-link/style.css\";i:303;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-navigation-link/style.min.css\";i:304;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/editor-rtl.css\";i:305;s:114:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/editor-rtl.min.css\";i:306;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/editor.css\";i:307;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/editor.min.css\";i:308;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/style-rtl.css\";i:309;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/style-rtl.min.css\";i:310;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/style.css\";i:311;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-template/style.min.css\";i:312;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-terms/style-rtl.css\";i:313;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-terms/style-rtl.min.css\";i:314;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-terms/style.css\";i:315;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-terms/style.min.css\";i:316;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-title/style-rtl.css\";i:317;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-title/style-rtl.min.css\";i:318;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-title/style.css\";i:319;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/post-title/style.min.css\";i:320;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/preformatted/style-rtl.css\";i:321;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/preformatted/style-rtl.min.css\";i:322;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/preformatted/style.css\";i:323;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/preformatted/style.min.css\";i:324;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/editor-rtl.css\";i:325;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/editor-rtl.min.css\";i:326;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/editor.css\";i:327;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/editor.min.css\";i:328;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/style-rtl.css\";i:329;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/style-rtl.min.css\";i:330;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/style.css\";i:331;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/style.min.css\";i:332;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/theme-rtl.css\";i:333;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/theme-rtl.min.css\";i:334;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/theme.css\";i:335;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/pullquote/theme.min.css\";i:336;s:121:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination-numbers/editor-rtl.css\";i:337;s:125:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination-numbers/editor-rtl.min.css\";i:338;s:117:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination-numbers/editor.css\";i:339;s:121:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination-numbers/editor.min.css\";i:340;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/editor-rtl.css\";i:341;s:117:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/editor-rtl.min.css\";i:342;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/editor.css\";i:343;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/editor.min.css\";i:344;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/style-rtl.css\";i:345;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/style-rtl.min.css\";i:346;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/style.css\";i:347;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-pagination/style.min.css\";i:348;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-title/style-rtl.css\";i:349;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-title/style-rtl.min.css\";i:350;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-title/style.css\";i:351;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query-title/style.min.css\";i:352;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query/editor-rtl.css\";i:353;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query/editor-rtl.min.css\";i:354;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query/editor.css\";i:355;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/query/editor.min.css\";i:356;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/style-rtl.css\";i:357;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/style-rtl.min.css\";i:358;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/style.css\";i:359;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/style.min.css\";i:360;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/theme-rtl.css\";i:361;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/theme-rtl.min.css\";i:362;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/theme.css\";i:363;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/quote/theme.min.css\";i:364;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/read-more/style-rtl.css\";i:365;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/read-more/style-rtl.min.css\";i:366;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/read-more/style.css\";i:367;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/read-more/style.min.css\";i:368;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/editor-rtl.css\";i:369;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/editor-rtl.min.css\";i:370;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/editor.css\";i:371;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/editor.min.css\";i:372;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/style-rtl.css\";i:373;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/style-rtl.min.css\";i:374;s:95:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/style.css\";i:375;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/rss/style.min.css\";i:376;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/editor-rtl.css\";i:377;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/editor-rtl.min.css\";i:378;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/editor.css\";i:379;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/editor.min.css\";i:380;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/style-rtl.css\";i:381;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/style-rtl.min.css\";i:382;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/style.css\";i:383;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/style.min.css\";i:384;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/theme-rtl.css\";i:385;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/theme-rtl.min.css\";i:386;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/theme.css\";i:387;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/search/theme.min.css\";i:388;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/editor-rtl.css\";i:389;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/editor-rtl.min.css\";i:390;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/editor.css\";i:391;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/editor.min.css\";i:392;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/style-rtl.css\";i:393;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/style-rtl.min.css\";i:394;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/style.css\";i:395;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/style.min.css\";i:396;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/theme-rtl.css\";i:397;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/theme-rtl.min.css\";i:398;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/theme.css\";i:399;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/separator/theme.min.css\";i:400;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/shortcode/editor-rtl.css\";i:401;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/shortcode/editor-rtl.min.css\";i:402;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/shortcode/editor.css\";i:403;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/shortcode/editor.min.css\";i:404;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/editor-rtl.css\";i:405;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/editor-rtl.min.css\";i:406;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/editor.css\";i:407;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/editor.min.css\";i:408;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/style-rtl.css\";i:409;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/style-rtl.min.css\";i:410;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/style.css\";i:411;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-logo/style.min.css\";i:412;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-tagline/editor-rtl.css\";i:413;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-tagline/editor-rtl.min.css\";i:414;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-tagline/editor.css\";i:415;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-tagline/editor.min.css\";i:416;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/editor-rtl.css\";i:417;s:111:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/editor-rtl.min.css\";i:418;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/editor.css\";i:419;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/editor.min.css\";i:420;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/style-rtl.css\";i:421;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/style-rtl.min.css\";i:422;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/style.css\";i:423;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/site-title/style.min.css\";i:424;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-link/editor-rtl.css\";i:425;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-link/editor-rtl.min.css\";i:426;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-link/editor.css\";i:427;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-link/editor.min.css\";i:428;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/editor-rtl.css\";i:429;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/editor-rtl.min.css\";i:430;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/editor.css\";i:431;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/editor.min.css\";i:432;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/style-rtl.css\";i:433;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/style-rtl.min.css\";i:434;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/style.css\";i:435;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/social-links/style.min.css\";i:436;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/editor-rtl.css\";i:437;s:107:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/editor-rtl.min.css\";i:438;s:99:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/editor.css\";i:439;s:103:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/editor.min.css\";i:440;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/style-rtl.css\";i:441;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/style-rtl.min.css\";i:442;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/style.css\";i:443;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/spacer/style.min.css\";i:444;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/editor-rtl.css\";i:445;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/editor-rtl.min.css\";i:446;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/editor.css\";i:447;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/editor.min.css\";i:448;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/style-rtl.css\";i:449;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/style-rtl.min.css\";i:450;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/style.css\";i:451;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/style.min.css\";i:452;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/theme-rtl.css\";i:453;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/theme-rtl.min.css\";i:454;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/theme.css\";i:455;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/table/theme.min.css\";i:456;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/tag-cloud/style-rtl.css\";i:457;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/tag-cloud/style-rtl.min.css\";i:458;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/tag-cloud/style.css\";i:459;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/tag-cloud/style.min.css\";i:460;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/editor-rtl.css\";i:461;s:114:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/editor-rtl.min.css\";i:462;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/editor.css\";i:463;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/editor.min.css\";i:464;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/theme-rtl.css\";i:465;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/theme-rtl.min.css\";i:466;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/theme.css\";i:467;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/template-part/theme.min.css\";i:468;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/term-description/style-rtl.css\";i:469;s:116:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/term-description/style-rtl.min.css\";i:470;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/term-description/style.css\";i:471;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/term-description/style.min.css\";i:472;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/editor-rtl.css\";i:473;s:113:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/editor-rtl.min.css\";i:474;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/editor.css\";i:475;s:109:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/editor.min.css\";i:476;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/style-rtl.css\";i:477;s:112:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/style-rtl.min.css\";i:478;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/style.css\";i:479;s:108:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/text-columns/style.min.css\";i:480;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/verse/style-rtl.css\";i:481;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/verse/style-rtl.min.css\";i:482;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/verse/style.css\";i:483;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/verse/style.min.css\";i:484;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/editor-rtl.css\";i:485;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/editor-rtl.min.css\";i:486;s:98:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/editor.css\";i:487;s:102:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/editor.min.css\";i:488;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/style-rtl.css\";i:489;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/style-rtl.min.css\";i:490;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/style.css\";i:491;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/style.min.css\";i:492;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/theme-rtl.css\";i:493;s:105:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/theme-rtl.min.css\";i:494;s:97:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/theme.css\";i:495;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/basenew/wp-includes/blocks/video/theme.min.css\";}", "yes");
INSERT INTO `wp_options` VALUES("142", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:14:\"info@gmail.com\";s:7:\"version\";s:5:\"6.6.1\";s:9:\"timestamp\";i:1721756006;}", "off");
INSERT INTO `wp_options` VALUES("186", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("44321", "_transient_timeout_wc_var_prices_128", "1722297452", "no");
INSERT INTO `wp_options` VALUES("44322", "_transient_wc_var_prices_128", "{\"version\":\"1714511326\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"129\":\"1000000\",\"130\":\"1000000\",\"131\":\"1000000\",\"132\":\"1000000\",\"133\":\"1000000\",\"134\":\"1000000\",\"135\":\"1000000\",\"136\":\"1000000\",\"137\":\"1000000\",\"138\":\"1000000\",\"139\":\"1000000\",\"140\":\"1000000\",\"141\":\"1000000\",\"142\":\"1000000\",\"143\":\"1000000\",\"144\":\"1000000\"},\"regular_price\":{\"129\":\"1000000\",\"130\":\"1000000\",\"131\":\"1000000\",\"132\":\"1000000\",\"133\":\"1000000\",\"134\":\"1000000\",\"135\":\"1000000\",\"136\":\"1000000\",\"137\":\"1000000\",\"138\":\"1000000\",\"139\":\"1000000\",\"140\":\"1000000\",\"141\":\"1000000\",\"142\":\"1000000\",\"143\":\"1000000\",\"144\":\"1000000\"},\"sale_price\":{\"129\":\"1000000\",\"130\":\"1000000\",\"131\":\"1000000\",\"132\":\"1000000\",\"133\":\"1000000\",\"134\":\"1000000\",\"135\":\"1000000\",\"136\":\"1000000\",\"137\":\"1000000\",\"138\":\"1000000\",\"139\":\"1000000\",\"140\":\"1000000\",\"141\":\"1000000\",\"142\":\"1000000\",\"143\":\"1000000\",\"144\":\"1000000\"}}}", "no");
INSERT INTO `wp_options` VALUES("1109", "_transient_orders-transient-version", "1696022176", "yes");
INSERT INTO `wp_options` VALUES("44325", "_transient_timeout_wc_var_prices_94", "1722297452", "no");
INSERT INTO `wp_options` VALUES("44326", "_transient_wc_var_prices_94", "{\"version\":\"1714511326\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"95\":\"1000000\",\"96\":\"1000000\",\"97\":\"1000000\",\"98\":\"1000000\",\"99\":\"1000000\",\"100\":\"1000000\",\"101\":\"1000000\",\"102\":\"1000000\",\"103\":\"1000000\",\"104\":\"1000000\",\"105\":\"1000000\",\"106\":\"1000000\",\"107\":\"1000000\",\"108\":\"1000000\",\"109\":\"1000000\",\"110\":\"1000000\"},\"regular_price\":{\"95\":\"1000000\",\"96\":\"1000000\",\"97\":\"1000000\",\"98\":\"1000000\",\"99\":\"1000000\",\"100\":\"1000000\",\"101\":\"1000000\",\"102\":\"1000000\",\"103\":\"1000000\",\"104\":\"1000000\",\"105\":\"1000000\",\"106\":\"1000000\",\"107\":\"1000000\",\"108\":\"1000000\",\"109\":\"1000000\",\"110\":\"1000000\"},\"sale_price\":{\"95\":\"1000000\",\"96\":\"1000000\",\"97\":\"1000000\",\"98\":\"1000000\",\"99\":\"1000000\",\"100\":\"1000000\",\"101\":\"1000000\",\"102\":\"1000000\",\"103\":\"1000000\",\"104\":\"1000000\",\"105\":\"1000000\",\"106\":\"1000000\",\"107\":\"1000000\",\"108\":\"1000000\",\"109\":\"1000000\",\"110\":\"1000000\"}}}", "no");
INSERT INTO `wp_options` VALUES("170", "wd_wishlist_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "woodmart_upgrade_database_wishlist", "1", "yes");
INSERT INTO `wp_options` VALUES("172", "woodmart_added_column_on_sale_in_product_db", "1", "yes");
INSERT INTO `wp_options` VALUES("173", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/fonts/woodmart-font-1-400.woff2?v=7.5.3\") format(\"woff2\");\n}\n\n:root {\n	--wd-header-banner-h: 40px;\n	--wd-text-font: YekanBakhFaNum;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 14px;\n	--wd-title-font: YekanBakhFaNum;\n	--wd-title-font-weight: 500;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: YekanBakhFaNum;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(214, 6, 68);\n	--wd-alternative-font: YekanBakhFaNum;\n	--wd-widget-title-font: YekanBakhFaNum;\n	--wd-widget-title-font-weight: 600;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 15px;\n	--wd-header-el-font: YekanBakhFaNum;\n	--wd-header-el-font-weight: 500;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 14px;\n	--wd-primary-color: rgb(214,6,68);\n	--wd-alternative-color: #fbbc34;\n	--wd-link-color: #333333;\n	--wd-link-color-hover: rgb(214,6,68);\n	--btn-default-font-family: IRANSansXFaNum;\n	--btn-default-bgcolor: rgb(214,6,68);\n	--btn-default-bgcolor-hover: rgb(214,6,68);\n	--btn-accented-font-family: IRANSansXFaNum;\n	--btn-accented-bgcolor: rgb(214,6,68);\n	--btn-accented-bgcolor-hover: rgb(214,6,68);\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.woodmart-woocommerce-layered-nav .wd-scroll-content {\n	max-height: 223px;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 800px;\n}\n.header-banner {\n	background-image: url(https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp);\n	background-repeat: no-repeat;\n	background-size: cover;\n	background-position: center center;\n}\n.page-title-default {\n	background-color: rgb(15,15,15);\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.footer-container {\n	background-color: #ffffff;\n	background-image: none;\n}\n.page .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.woodmart-archive-shop:not(.single-product) .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.single-product .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.woodmart-archive-blog .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.single-post .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.woodmart-archive-portfolio .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.single-portfolio .main-page-wrapper {\n	background-color: rgb(239,241,245);\n	background-image: none;\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-header-banner-h: 40px;\n	}\n\n}\n:root{\n--wd-container-w: 1290px;\n--wd-form-brd-radius: 35px;\n--btn-default-color: #fff;\n--btn-default-color-hover: #fff;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 35px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 35px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--wd-brd-radius: 12px;\n}\n\n@media (min-width: 1307px) {\n.platform-Windows .wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n@media (min-width: 1290px) {\nhtml:not(.platform-Windows) .wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n\n", "yes");
INSERT INTO `wp_options` VALUES("734", "elementor_allow_tracking", "no", "yes");
INSERT INTO `wp_options` VALUES("174", "xts-theme_settings_default-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("175", "xts-theme_settings_default-version", "7.5.3", "yes");
INSERT INTO `wp_options` VALUES("176", "xts-theme_settings_default-site-url", "a85740bab56cc45bb05bfcbfc9df85ba", "yes");
INSERT INTO `wp_options` VALUES("177", "woodmart-update-time", "1721929503", "yes");
INSERT INTO `wp_options` VALUES("178", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"7.5.2\";s:7:\"version\";s:5:\"7.5.2\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1721929503;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:57:\"https://xtemos.com/wp-json/xts/v1/download?theme=woodmart\";}", "yes");
INSERT INTO `wp_options` VALUES("183", "xts_backups_auto", "a:5:{i:1712667540;a:5:{s:5:\"title\";s:37:\"پشتیبان گیری خودکار.\";s:4:\"date\";s:19:\"2024-04-09 12:59:00\";s:4:\"auto\";b:1;s:7:\"options\";a:621:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:9:\"main-demo\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}i:1713086617;a:5:{s:5:\"title\";s:37:\"پشتیبان گیری خودکار.\";s:4:\"date\";s:19:\"2024-04-14 09:23:37\";s:4:\"auto\";b:1;s:7:\"options\";a:621:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:9:\"main-demo\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}i:1716239220;a:5:{s:5:\"title\";s:37:\"پشتیبان گیری خودکار.\";s:4:\"date\";s:19:\"2024-05-20 21:07:00\";s:4:\"auto\";b:1;s:7:\"options\";a:621:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:12:\"small-images\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}i:1719389075;a:5:{s:5:\"title\";s:37:\"پشتیبان گیری خودکار.\";s:4:\"date\";s:19:\"2024-06-26 08:04:35\";s:4:\"auto\";b:1;s:7:\"options\";a:621:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:12:\"small-images\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}i:1722017849;a:5:{s:5:\"title\";s:37:\"پشتیبان گیری خودکار.\";s:4:\"date\";s:19:\"2024-07-26 18:17:29\";s:4:\"auto\";b:1;s:7:\"options\";a:621:{s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_524641\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:41:\"https://demoes.aramis-co.ir/basenew/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:126:\"https://demoes.aramis-co.ir/basenew/wp-content/uploads/2023/10/663ce17cd81d8f4a867ba37fb62e2eee308c2e14_1694942765-scaled.webp\";s:2:\"id\";s:3:\"987\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:97:\"موبایل\r\nگوشی\r\nسامسونگ\r\nگوشی سامسونگ\r\nموبایل های پرفروش\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1290\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"270\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2023 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:109:\"<img src=\"https://demoes.aramis-co.ir/basenew/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:15:\"rgb(214, 6, 68)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(214,6,68)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(239,241,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:10:\"background\";s:13:\"rgb(214,6,68)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:20:\"demo_woodmart_select\";s:12:\"small-images\";s:9:\"pishnahad\";s:1:\"#\";s:14:\"site_viewportt\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:0:\"\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";}s:7:\"presets\";s:0:\"\";}}", "off");
INSERT INTO `wp_options` VALUES("817", "fs_active_plugins", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("807", "IPPSW_PER_PRODUCT_SHIPPING_VERSION", "2.2.8", "yes");
INSERT INTO `wp_options` VALUES("732", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `wp_options` VALUES("187", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("188", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.9.7\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1695706625;s:7:\"version\";s:3:\"5.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("189", "duplicator_version_plugin", "1.5.9", "yes");
INSERT INTO `wp_options` VALUES("400", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1724609966", "no");
INSERT INTO `wp_options` VALUES("49466", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1695706625;s:10:\"updateTime\";i:1722007207;}", "off");
INSERT INTO `wp_options` VALUES("192", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("193", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("194", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.10.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:8;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("196", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"UTPcJj;dOUiRE0xt2SdfFmUn8oyOq6D1.zyv1z&9Hx;d\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 7,\n    \"buildLastDate\": 1721562438,\n    \"buildFailedCount\": 2,\n    \"buildFailedLastDate\": 1701265906,\n    \"siteSizeMB\": 447.45999999999998,\n    \"siteNumFiles\": 19531,\n    \"siteDbSizeMB\": 79.030000000000001,\n    \"siteDbNumTables\": 59\n}", "yes");
INSERT INTO `wp_options` VALUES("197", "elementor_active_kit", "6", "yes");
INSERT INTO `wp_options` VALUES("198", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("397", "mc4wp_version", "4.9.14", "yes");
INSERT INTO `wp_options` VALUES("201", "action_scheduler_hybrid_store_demarkation", "7", "yes");
INSERT INTO `wp_options` VALUES("202", "schema-ActionScheduler_StoreSchema", "7.0.1695706626", "yes");
INSERT INTO `wp_options` VALUES("203", "schema-ActionScheduler_LoggerSchema", "3.0.1695706626", "yes");
INSERT INTO `wp_options` VALUES("337", "woocommerce_admin_install_timestamp", "1695706627", "yes");
INSERT INTO `wp_options` VALUES("338", "woocommerce_inbox_variant_assignment", "9", "yes");
INSERT INTO `wp_options` VALUES("206", "woocommerce_newly_installed", "no", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("211", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("214", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("216", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("219", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("222", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("224", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("225", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("226", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("227", "woocommerce_shop_page_id", "8", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_placeholder_image", "7", "yes");
INSERT INTO `wp_options` VALUES("231", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("232", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("233", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("234", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("236", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("237", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("240", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("241", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("242", "woocommerce_stock_email_recipient", "info@gmail.com", "no");
INSERT INTO `wp_options` VALUES("243", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("244", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("246", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("249", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("251", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `wp_options` VALUES("252", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("48187", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("254", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("255", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("256", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("257", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("258", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("260", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("261", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("262", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("263", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("264", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("265", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("266", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("267", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("268", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("269", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("270", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("271", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wp_options` VALUES("272", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("273", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("274", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("275", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("276", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("277", "woocommerce_registration_privacy_policy_text", "Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_checkout_privacy_policy_text", "Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("280", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("281", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("282", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("283", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("284", "woocommerce_email_from_name", "دمو کلاسیک", "no");
INSERT INTO `wp_options` VALUES("285", "woocommerce_email_from_address", "info@gmail.com", "no");
INSERT INTO `wp_options` VALUES("286", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("287", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_email_base_color", "#7f54b3", "no");
INSERT INTO `wp_options` VALUES("289", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("290", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("291", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("292", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("293", "woocommerce_cart_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("294", "woocommerce_checkout_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("295", "woocommerce_myaccount_page_id", "11", "no");
INSERT INTO `wp_options` VALUES("296", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("297", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("298", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("299", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("300", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("301", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("302", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("304", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("305", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("306", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("307", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("308", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("309", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("310", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("311", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("312", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("313", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("314", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("315", "woocommerce_feature_product_block_editor_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("316", "woocommerce_custom_orders_table_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("317", "woocommerce_custom_orders_table_data_sync_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("318", "woocommerce_custom_orders_table_created", "yes", "yes");
INSERT INTO `wp_options` VALUES("319", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("320", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("321", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("322", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("323", "wc_downloads_approved_directories_mode", "enabled", "yes");
INSERT INTO `wp_options` VALUES("324", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("325", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("326", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("1048", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("329", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("396", "wc_admin_show_legacy_coupon_menu", "0", "yes");
INSERT INTO `wp_options` VALUES("331", "woocommerce_refund_returns_page_id", "12", "yes");
INSERT INTO `wp_options` VALUES("334", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:14:\"info@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:14:\"info@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("335", "woocommerce_version", "9.1.2", "yes");
INSERT INTO `wp_options` VALUES("336", "woocommerce_db_version", "8.2.1", "yes");
INSERT INTO `wp_options` VALUES("346", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "yes");
INSERT INTO `wp_options` VALUES("342", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("343", "action_scheduler_lock_async-request-runner", "66a3e8ad2f82b6.59988105|1722018025", "no");
INSERT INTO `wp_options` VALUES("344", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("345", "wc_blocks_version", "11.8.0-dev", "yes");
INSERT INTO `wp_options` VALUES("347", "elementor_version", "3.23.1", "yes");
INSERT INTO `wp_options` VALUES("348", "elementor_install_history", "a:4:{s:6:\"3.16.4\";i:1695706628;s:6:\"3.17.1\";i:1698753933;s:6:\"3.17.3\";i:1701264717;s:6:\"3.23.1\";i:1721561818;}", "yes");
INSERT INTO `wp_options` VALUES("349", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("350", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"lV3GDZArACmzHhwFiSnwzMas5u8lPzak\";}", "yes");
INSERT INTO `wp_options` VALUES("351", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("352", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("353", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("354", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("355", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:32:\"فیلتر براساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("356", "widget_woocommerce_product_categories", "a:2:{i:2;a:8:{s:5:\"title\";s:32:\"دسته بندی محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:1;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("357", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("358", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("359", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("360", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("361", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("362", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("363", "widget_woocommerce_rating_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:37:\"فیلتر بر اساس امتیاز\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("364", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("365", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("366", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("367", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("368", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("369", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("370", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("371", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("372", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("373", "widget_woodmart-woocommerce-layered-nav", "a:3:{i:2;a:11:{s:5:\"title\";s:33:\"فیلتر بر اساس برند\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:17:\"search_by_filters\";b:0;}i:3;a:11:{s:5:\"title\";s:31:\"فیلتر بر اساس رنگ\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:17:\"search_by_filters\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("374", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("375", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("376", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("377", "widget_wd-widget-stock-status", "a:2:{i:2;a:4:{s:5:\"title\";s:21:\"وضعیت محصول\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("378", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("379", "duplicator_notifications", "a:4:{s:6:\"update\";i:1721993390;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("388", "wcpay_was_in_use", "no", "yes");
INSERT INTO `wp_options` VALUES("818", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("819", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:7653;a:3:{s:4:\"slug\";s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:74:\"woocommerce-shipping-gateway-per-product/woocommerce-product-shippings.php\";}}s:11:\"plugin_data\";a:1:{s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:74:\"woocommerce-shipping-gateway-per-product/woocommerce-product-shippings.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1695763301;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:6:\"2.5.12\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"2.3.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:19:\"demoes.aramis-co.ir\";s:9:\"server_ip\";s:12:\"195.28.10.27\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1695763301;s:7:\"version\";s:5:\"2.3.4\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1695763311;s:7:\"version\";s:5:\"2.3.4\";}}}s:13:\"file_slug_map\";a:1:{s:74:\"woocommerce-shipping-gateway-per-product/woocommerce-product-shippings.php\";s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";}s:7:\"plugins\";a:1:{s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";O:9:\"FS_Plugin\":24:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:40:\"WooCommerce Shipping gateway per Product\";s:4:\"slug\";s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";s:12:\"premium_slug\";s:59:\"DreamfoxMediaPaymentgatewayperProductforWoocommerce-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:74:\"woocommerce-shipping-gateway-per-product/woocommerce-product-shippings.php\";s:7:\"version\";s:5:\"2.3.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:7:\"Premium\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;s:10:\"public_key\";s:32:\"pk_f21a7bb601e07d62b89f55c3a832c\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"7653\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"6d85228f375aa5cec26a546445bf7b09\";s:13:\"admin_notices\";a:1:{s:48:\"dfm-shipping-gateway-per-product-for-woocommerce\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("814", "_transient_woocommerce_shipping_task_zone_count_transient", "1", "yes");
INSERT INTO `wp_options` VALUES("398", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("399", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("401", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"07c2f0675ddd247d2325\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"bda84b1be3361607d04a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"ca04183222edaf8a26be\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"3b21c127321dcdffaeba\",\"dependencies\":[\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"389607d443f2591c0913\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"1c879273bd5c193cad0a\",\"dependencies\":[\"react\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"00ce86264fca4977b16a\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"6eb6865831aa5a75475d\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"4f21a9f43ea5bfa7f02e\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"eb7a7398126f71912b09\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors-frontend.js\",\"version\":\"cbe41c7abb3949767748\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"5980872eb77817dd6b18\",\"dependencies\":[\"react\",\"react-dom\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"211abb6906805368a551\",\"dependencies\":[\"react\",\"react-dom\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-dropdown.js\",\"version\":\"8997b5406dcf18064a4e\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-interactivity-checkbox-list.js\",\"version\":\"c33101c7e57ca780e0d8\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/active-filters.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters.js\",\"version\":\"07254c2f32c26d21c0ef\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/active-filters-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/active-filters-frontend.js\",\"version\":\"b7ae146ebe7863f9f6b8\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/all-products.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products.js\",\"version\":\"de63136b925fe4405f95\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-products-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-products-frontend.js\",\"version\":\"34225df31c9fc4fb4ad9\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/all-reviews.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/all-reviews.js\",\"version\":\"4421b2ba149150ba3a80\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-escape-html\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/reviews-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-frontend.js\",\"version\":\"4462be41b0f004e9751b\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-a11y\",\"wp-api-fetch\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/attribute-filter.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter.js\",\"version\":\"f29cfa920e0887b73f22\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/attribute-filter-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/attribute-filter-frontend.js\",\"version\":\"16c1a488449ef9ea8eaa\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/breadcrumbs.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/breadcrumbs.js\",\"version\":\"c78bceea82834e964257\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/catalog-sorting.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/catalog-sorting.js\",\"version\":\"6c2e6a0a2cd09107cf04\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/legacy-template.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/legacy-template.js\",\"version\":\"761a9a4979bac75875d4\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/classic-shortcode.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/classic-shortcode.js\",\"version\":\"77bba6e2f771a40e1cec\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/coming-soon.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/coming-soon.js\",\"version\":\"c6d2e77a8930f58cbff8\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/customer-account.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/customer-account.js\",\"version\":\"a04e4ad5cf91d59eae45\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/featured-category.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-category.js\",\"version\":\"c7075e8fffe37d9ad21d\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/featured-product.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/featured-product.js\",\"version\":\"d3af59655b446a53100c\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\"]},\"assets\\/client\\/blocks\\/filter-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper.js\",\"version\":\"7f2269e03957a553e47c\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/filter-wrapper-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filter-wrapper-frontend.js\",\"version\":\"3f6c3d73d1a34928ee1e\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/handpicked-products.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/handpicked-products.js\",\"version\":\"acf80e15b27dca063f23\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart.js\",\"version\":\"e1653c56caa176335fc5\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/mini-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-frontend.js\",\"version\":\"eba896c62201a23c4175\",\"dependencies\":[\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/store-notices.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/store-notices.js\",\"version\":\"2e8dc38e57382d79fce0\",\"dependencies\":[\"react\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-deprecated\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/price-filter.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter.js\",\"version\":\"67ddaae590e2c2e1d5ff\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/price-filter-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-filter-frontend.js\",\"version\":\"922d545864d8a6b66758\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-best-sellers.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-best-sellers.js\",\"version\":\"421922b42cf4c6de6a74\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-button.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-button.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-button-interactivity-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-button-interactivity-frontend.js\",\"version\":\"cb28f5957f4ece0c48e5\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-interactivity\",\"wp-a11y\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-categories.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-categories.js\",\"version\":\"19dfea34dec3553590a0\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\"]},\"assets\\/client\\/blocks\\/product-category.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-category.js\",\"version\":\"2cb7ddb399fe6f29c932\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection.js\",\"version\":\"60457e28bcaf0b01fea7\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-editor\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-collection-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection-frontend.js\",\"version\":\"37b3a37d0211278e6a0c\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-collection-no-results.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-collection-no-results.js\",\"version\":\"d1c4e65a98c9f79e8930\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery.js\",\"version\":\"c7b111b60716451682e0\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-gallery-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-frontend.js\",\"version\":\"c340254c6c31444370fb\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image.js\",\"version\":\"32b186af1c3d64a75d46\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-gallery-large-image-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-gallery-large-image-frontend.js\",\"version\":\"dd8201c48d0f0223ee5a\",\"dependencies\":[\"wc-interactivity\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/product-new.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-new.js\",\"version\":\"8af7bb3cd67cd0e42b9a\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-on-sale.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-on-sale.js\",\"version\":\"a056ece38962718de3a1\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-template.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-template.js\",\"version\":\"9a52b21fe92db2169c0b\",\"dependencies\":[\"react\",\"wc-blocks-shared-context\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query.js\",\"version\":\"37b83ec461eb8aa409c1\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-query-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-query-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-results-count.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-results-count.js\",\"version\":\"f5e7da47100ae9363279\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-search.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-search.js\",\"version\":\"1a4b65a4e4891b2f8194\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/product-summary.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-summary.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-tag.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-tag.js\",\"version\":\"342af558ffb7a1357f15\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/product-title.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-title-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-title-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/product-top-rated.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/product-top-rated.js\",\"version\":\"6fb347850bc724a274ea\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/products-by-attribute.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/products-by-attribute.js\",\"version\":\"cacbde7aaa9a7d3d39e1\",\"dependencies\":[\"react\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-server-side-render\",\"wp-url\"]},\"assets\\/client\\/blocks\\/rating-filter.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/rating-filter.js\",\"version\":\"bc7fe305a38c3e85049a\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/reviews-by-category.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-category.js\",\"version\":\"4cb7066b850f401e4c1b\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/reviews-by-product.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/reviews-by-product.js\",\"version\":\"e8a05f6b98cd05f62626\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-element\",\"wp-escape-html\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/single-product.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/single-product.js\",\"version\":\"0e8dba50189e03650508\",\"dependencies\":[\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-store-data\",\"wc-types\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-element\",\"wp-escape-html\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/stock-filter.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter.js\",\"version\":\"16111b0cef1b2df6fae5\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/stock-filter-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/stock-filter-frontend.js\",\"version\":\"df719537684ceaec2832\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/page-content-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/page-content-wrapper.js\",\"version\":\"b17d813006ab6721c0bf\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-status.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-status.js\",\"version\":\"2c059192f836902afc42\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-summary.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-summary.js\",\"version\":\"bce30c87f99abc744d6b\",\"dependencies\":[\"react\",\"wc-price-format\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-date\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-totals.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-totals.js\",\"version\":\"3578f6bba1fdfa8f4584\",\"dependencies\":[\"react\",\"wc-price-format\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-totals-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-totals-wrapper.js\",\"version\":\"186984378635e6e08423\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-downloads.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-downloads.js\",\"version\":\"1d9816820e49da031b6c\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-downloads-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-downloads-wrapper.js\",\"version\":\"7d7efbae89a188570068\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-billing-address.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-billing-address.js\",\"version\":\"129b99c02e2f0bbd408a\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-shipping-address.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-shipping-address.js\",\"version\":\"0371dc375c63dd728238\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-billing-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-billing-wrapper.js\",\"version\":\"fce4c23d911cc8526506\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-shipping-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-shipping-wrapper.js\",\"version\":\"b923bf1dbf6392c32509\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-information.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-information.js\",\"version\":\"f4a1c3f8c632681e85dd\",\"dependencies\":[\"react\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-fields-wrapper.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-fields-wrapper.js\",\"version\":\"4b25a3e20f302075ad71\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/order-confirmation-additional-fields.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/order-confirmation-additional-fields.js\",\"version\":\"da73c5eb34820cd26854\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-block-editor\",\"wp-blocks\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/cart.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart.js\",\"version\":\"08d8564dbaa16cf625ad\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-frontend.js\",\"version\":\"1c5ebcb58df698a17253\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-context\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-items-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-items-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-totals-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/filled-cart-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-taxes-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-products-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-heading-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-accepted-payment-methods-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-order-summary-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/proceed-to-checkout-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-subtotal-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-cross-sells-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-items-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-items-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/empty-cart-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-fee-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/order-summary-discount-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-totals-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-taxes-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-subtotal-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-totals-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-cart-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-cart-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/empty-cart-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-cart-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-totals-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-totals-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-items-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-items-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-line-items-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-line-items-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-express-payment-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-express-payment-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/proceed-to-checkout-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/proceed-to-checkout-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-accepted-payment-methods-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-coupon-form-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-discount-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-fee-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-heading-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-order-summary-shipping-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-cross-sells-products-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout.js\",\"version\":\"fe5f1472c4d91167d951\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-editor\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-notices\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/checkout-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-frontend.js\",\"version\":\"d7549457c5d1658f35f3\",\"dependencies\":[\"lodash\",\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-blocks-shared-hocs\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-api-fetch\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-plugins\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-warning\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/checkout-blocks\\/totals-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/totals-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-shipping-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-taxes-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-coupon-form-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/actions-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/actions-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/terms-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/terms-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/fields-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/fields-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/additional-information-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/express-payment-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/payment-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/payment-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/terms-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/terms-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-cart-items-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/fields-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/fields-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/payment-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/payment-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-address-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-method-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-subtotal-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/pickup-options-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/contact-information-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-note-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-note-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/shipping-methods-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/actions-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/actions-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-fee-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/billing-address-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/order-summary-discount-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-blocks\\/totals-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-blocks\\/totals-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-express-payment--checkout-blocks\\/express-payment-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-actions-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-actions-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-additional-information-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-additional-information-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-billing-address-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-billing-address-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-contact-information-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-contact-information-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-express-payment-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-express-payment-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-fields-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-fields-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-note-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-note-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-cart-items-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-coupon-form-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-discount-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-fee-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-shipping-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-subtotal-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-taxes-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-order-summary-totals-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-payment-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-payment-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-address-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-address-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-methods-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-shipping-method-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-shipping-method-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-pickup-options-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-pickup-options-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-terms-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-terms-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/checkout-totals-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/checkout-totals-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents.js\",\"version\":\"20afb0107a7fbe5c6151\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-data\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/empty-mini-cart-contents-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/filled-mini-cart-contents-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-footer-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-footer-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-items-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-items-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-products-table-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-products-table-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-shopping-button-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-cart-button-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-checkout-button-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-items-counter-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-title-label-block.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-title-label-block.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"a25687e7db9e8541a6f0\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"64d11b5b30724a537c38\",\"dependencies\":[\"react\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/basenew\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.1.2\",\"dependencies\":[]}},\"version\":\"wc-9.1.2\",\"hash\":\"50c323c0b6058617bac60c4de9c0d6fb\"}", "no");
INSERT INTO `wp_options` VALUES("48192", "elementor_1_elementor_updater_batch_446ead4aa8c8e65ebbe3004ea1ae", "a:1:{i:0;a:1:{s:8:\"callback\";a:2:{i:0;s:31:\"Elementor\\Core\\Upgrade\\Upgrades\";i:1;s:16:\"_on_each_version\";}}}", "off");
INSERT INTO `wp_options` VALUES("48193", "_transient_wc_attribute_taxonomies", "a:2:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:5:\"brand\";s:15:\"attribute_label\";s:8:\"برند\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"color\";s:15:\"attribute_label\";s:6:\"رنگ\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}", "on");
INSERT INTO `wp_options` VALUES("48178", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("48179", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("48180", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("48181", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("48182", "woocommerce_store_id", "39c8c74f-51e9-45e4-9a5a-f4305a92fef9", "auto");
INSERT INTO `wp_options` VALUES("402", "_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs", "1722582364", "no");
INSERT INTO `wp_options` VALUES("403", "_transient_woocommerce_admin_payment_gateway_suggestions_specs", "a:1:{s:5:\"fa_IR\";a:24:{s:6:\"affirm\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"affirm\";s:5:\"title\";s:6:\"Affirm\";s:7:\"content\";s:169:\"Affirm’s tailored Buy Now Pay Later programs remove price as a barrier, turning browsers into buyers, increasing average order value, and expanding your customer base.\";s:5:\"image\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:7:\"plugins\";a:0:{}s:13:\"external_link\";s:59:\"https://woocommerce.com/products/woocommerce-gateway-affirm\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}s:23:\"recommendation_priority\";i:8;}s:8:\"afterpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"afterpay\";s:5:\"title\";s:8:\"Afterpay\";s:7:\"content\";s:125:\"Afterpay allows customers to receive products immediately and pay for purchases over four installments, always interest-free.\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:3:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";}s:23:\"recommendation_priority\";i:9;}s:14:\"airwallex_main\";O:8:\"stdClass\":11:{s:2:\"id\";s:14:\"airwallex_main\";s:5:\"title\";s:18:\"Airwallex Payments\";s:7:\"content\";s:115:\"Boost international sales and save on FX fees. Accept 60+ local payment methods including Apple Pay and Google Pay.\";s:5:\"image\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/airwallex.png\";s:12:\"square_image\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex-square.png\";s:7:\"plugins\";a:1:{i:0;s:33:\"airwallex-online-payments-gateway\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:17:{i:0;s:2:\"GB\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"EE\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"GR\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";i:11;s:2:\"PT\";i:12;s:2:\"AU\";i:13;s:2:\"NZ\";i:14;s:2:\"HK\";i:15;s:2:\"SG\";i:16;s:2:\"CN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";N;}s:24:\"amazon_payments_advanced\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"amazon_payments_advanced\";s:5:\"title\";s:10:\"Amazon Pay\";s:7:\"content\";s:94:\"Enable a familiar, fast checkout for hundreds of millions of active Amazon customers globally.\";s:5:\"image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-amazon-payments-advanced\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:18:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CY\";i:4;s:2:\"DK\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"DE\";i:8;s:2:\"GB\";i:9;s:2:\"HU\";i:10;s:2:\"IE\";i:11;s:2:\"IT\";i:12;s:2:\"LU\";i:13;s:2:\"NL\";i:14;s:2:\"PT\";i:15;s:2:\"SL\";i:16;s:2:\"SE\";i:17;s:2:\"JP\";}s:23:\"recommendation_priority\";i:7;}s:4:\"bacs\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"bacs\";s:5:\"title\";s:20:\"Direct bank transfer\";s:7:\"content\";s:32:\"Take payments via bank transfer.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/bacs.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/bacs.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";N;}s:3:\"cod\";O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"cod\";s:5:\"title\";s:16:\"Cash on delivery\";s:7:\"content\";s:36:\"Take payments in cash upon delivery.\";s:5:\"image\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/cod.svg\";s:11:\"image_72x72\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/cod.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";N;}s:4:\"eway\";O:8:\"stdClass\":11:{s:2:\"id\";s:4:\"eway\";s:5:\"title\";s:4:\"Eway\";s:7:\"content\";s:171:\"The Eway extension for WooCommerce allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway.png\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/eway.png\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway-square.png\";s:7:\"plugins\";a:1:{i:0;s:24:\"woocommerce-gateway-eway\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:7;}s:3:\"kco\";O:8:\"stdClass\":10:{s:2:\"id\";s:3:\"kco\";s:5:\"title\";s:15:\"Klarna Checkout\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-checkout-for-woocommerce\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"NO\";i:1;s:2:\"SE\";i:2;s:2:\"FI\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:15:\"klarna_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:15:\"klarna_payments\";s:5:\"title\";s:15:\"Klarna Payments\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:19:{i:0;s:2:\"MX\";i:1;s:2:\"US\";i:2;s:2:\"CA\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CH\";i:6;s:2:\"DK\";i:7;s:2:\"ES\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GB\";i:12;s:2:\"IT\";i:13;s:2:\"NL\";i:14;s:2:\"NO\";i:15;s:2:\"PL\";i:16;s:2:\"SE\";i:17;s:2:\"NZ\";i:18;s:2:\"AU\";}s:23:\"recommendation_priority\";i:6;}s:30:\"mollie_wc_gateway_banktransfer\";O:8:\"stdClass\":11:{s:2:\"id\";s:30:\"mollie_wc_gateway_banktransfer\";s:5:\"title\";s:6:\"Mollie\";s:7:\"content\";s:128:\"Effortless payments by Mollie: Offer global and local payment methods, get onboarded in minutes, and supported in your language.\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie.svg\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mollie.png\";s:12:\"square_image\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie-square.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"mollie-payments-for-woocommerce\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:11:{i:0;s:2:\"AT\";i:1;s:2:\"BE\";i:2;s:2:\"CH\";i:3;s:2:\"ES\";i:4;s:2:\"FI\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"GB\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:7:\"payfast\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payfast\";s:5:\"title\";s:7:\"Payfast\";s:7:\"content\";s:299:\"The Payfast extension for WooCommerce enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs. Selecting this extension will configure your store to use South African rands as the selected currency.\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/payfast.png\";s:11:\"image_72x72\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payfast.png\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-payfast-gateway\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"ZA\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:17:\"payoneer-checkout\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"payoneer-checkout\";s:5:\"title\";s:17:\"Payoneer Checkout\";s:7:\"content\";s:202:\"Payoneer Checkout is the next generation of payment processing platforms, giving merchants around the world the solutions and direction they need to succeed in today’s hyper-competitive global market.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payoneer.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payoneer.png\";s:7:\"plugins\";a:1:{i:0;s:17:\"payoneer-checkout\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"HK\";i:1;s:2:\"CN\";}s:23:\"recommendation_priority\";i:11;}s:8:\"paystack\";O:8:\"stdClass\":11:{s:2:\"id\";s:8:\"paystack\";s:5:\"title\";s:8:\"Paystack\";s:7:\"content\";s:127:\"Paystack helps African merchants accept one-time and recurring payments online with a modern, safe, and secure payment gateway.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack.png\";s:12:\"square_image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack-square.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paystack.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-paystack\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GH\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NG\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"ZA\";i:1;s:2:\"GH\";i:2;s:2:\"NG\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:7:\"payubiz\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payubiz\";s:5:\"title\";s:20:\"PayU for WooCommerce\";s:7:\"content\";s:169:\"Enable PayU’s exclusive plugin for WooCommerce to start accepting payments in 100+ payment methods available in India including credit cards, debit cards, UPI, & more!\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payu.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payu.png\";s:7:\"plugins\";a:1:{i:0;s:10:\"payu-india\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:12:\"ppcp-gateway\";O:8:\"stdClass\":11:{s:2:\"id\";s:12:\"ppcp-gateway\";s:5:\"title\";s:15:\"PayPal Payments\";s:7:\"content\";s:78:\"Safe and secure payments using credit cards or your customer\'s PayPal account.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/paypal.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paypal.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paypal.svg\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:49:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:48:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";}s:19:\"category_additional\";a:49:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";i:48;s:2:\"IN\";}s:23:\"recommendation_priority\";i:4;}s:8:\"razorpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"razorpay\";s:5:\"title\";s:8:\"Razorpay\";s:7:\"content\";s:133:\"The official Razorpay extension for WooCommerce allows you to accept credit cards, debit cards, netbanking, wallet, and UPI payments.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/razorpay.svg\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/razorpay.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-razorpay\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:18:\"square_credit_card\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"square_credit_card\";s:5:\"title\";s:6:\"Square\";s:7:\"content\";s:169:\"Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/square-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/square.png\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}i:1;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:12:\"brick-mortar\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:18:\"brick-mortar-other\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"no_im_selling_offline\";s:7:\"default\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:34:\"im_selling_both_online_and_offline\";s:7:\"default\";s:0:\"\";}}}}}}}}}s:14:\"category_other\";a:8:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"IE\";i:3;s:2:\"ES\";i:4;s:2:\"FR\";i:5;s:2:\"GB\";i:6;s:2:\"AU\";i:7;s:2:\"JP\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:6:\"stripe\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"stripe\";s:5:\"title\";s:6:\"Stripe\";s:7:\"content\";s:112:\"Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/stripe.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/stripe.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/stripe.svg\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AT\";i:5;s:2:\"BE\";i:6;s:2:\"BG\";i:7;s:2:\"CH\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"EE\";i:12;s:2:\"ES\";i:13;s:2:\"FI\";i:14;s:2:\"FR\";i:15;s:2:\"DE\";i:16;s:2:\"GB\";i:17;s:2:\"GR\";i:18;s:2:\"HU\";i:19;s:2:\"IE\";i:20;s:2:\"IT\";i:21;s:2:\"LV\";i:22;s:2:\"LT\";i:23;s:2:\"LU\";i:24;s:2:\"MT\";i:25;s:2:\"NL\";i:26;s:2:\"NO\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"RO\";i:30;s:2:\"SK\";i:31;s:2:\"SL\";i:32;s:2:\"SE\";i:33;s:2:\"AU\";i:34;s:2:\"NZ\";i:35;s:2:\"HK\";i:36;s:2:\"JP\";i:37;s:2:\"SG\";i:38;s:2:\"ID\";i:39;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:2;}s:23:\"woo-mercado-pago-custom\";O:8:\"stdClass\":11:{s:2:\"id\";s:23:\"woo-mercado-pago-custom\";s:5:\"title\";s:12:\"Mercado Pago\";s:7:\"content\";s:198:\"Set up your payment methods and accept credit and debit cards, cash, bank transfers and money from your Mercado Pago account. Offer safe and secure payments with Latin America’s leading processor.\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mercadopago.png\";s:11:\"image_72x72\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mercadopago.png\";s:7:\"plugins\";a:1:{i:0;s:23:\"woocommerce-mercadopago\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}}}}s:16:\"is_local_partner\";b:1;s:14:\"category_other\";a:8:{i:0;s:2:\"AR\";i:1;s:2:\"CL\";i:2;s:2:\"CO\";i:3;s:2:\"EC\";i:4;s:2:\"PE\";i:5;s:2:\"UY\";i:6;s:2:\"MX\";i:7;s:2:\"BR\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:3;}s:20:\"woocommerce_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:1:\"<\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:1:\"<\";}}}}s:23:\"recommendation_priority\";i:1;}s:47:\"woocommerce_payments:without-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:47:\"woocommerce_payments:without-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:37:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:44:\"woocommerce_payments:with-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:44:\"woocommerce_payments:with-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:212:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies – with no setup costs or monthly fees – and you can now accept in-person payments with the Woo mobile app.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:25:\"woocommerce_payments:bnpl\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"woocommerce_payments:bnpl\";s:5:\"title\";s:38:\"Activate BNPL instantly on WooPayments\";s:7:\"content\";s:185:\"The world’s favorite buy now, pay later options and many more are right at your fingertips with WooPayments — all from one dashboard, without needing multiple extensions and logins.\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:2:\">=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}s:23:\"recommendation_priority\";N;}s:8:\"zipmoney\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"zipmoney\";s:5:\"title\";s:27:\"Zip Co - Buy Now, Pay Later\";s:7:\"content\";s:84:\"Give your customers the power to pay later, interest free and watch your sales grow.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/zipmoney.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/zipmoney.png\";s:7:\"plugins\";a:1:{i:0;s:29:\"zipmoney-payments-woocommerce\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}}}", "no");
INSERT INTO `wp_options` VALUES("406", "_elementor_installed_time", "1695706634", "yes");
INSERT INTO `wp_options` VALUES("407", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:19:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:19:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:19:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:19:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:19:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:19:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:19:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:19:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:19:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:19:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:19:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:19:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:19:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:19:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:19:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:19:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:19:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:19:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:19:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:19:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:19:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:19:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:19:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:19:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:19:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:19:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:19:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:19:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:19:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:19:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:19:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:19:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:19:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:19:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:19:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:19:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:19:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:19:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:19:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:19:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:19:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:19:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:19:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:19:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:19:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:19:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:19:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:19:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:19:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:19:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:19:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:19:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:19:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:19:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:19:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:19:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:19:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:19:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:19:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:19:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:19:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:19:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:19:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:19:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:19:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:19:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:19:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:19:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:19:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:19:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:19:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:19:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:19:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:19:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:19:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:19:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:19:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:19:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:19:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:19:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:19:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:19:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:19:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:19:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:19:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:19:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:19:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:19:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:19:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:19:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:19:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:19:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:19:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:19:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:19:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:19:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:19:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:19:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:19:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:19:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:19:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:19:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:19:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:19:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:19:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:19:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:19:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:19:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:19:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:19:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:19:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:19:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:19:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:19:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:19:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:19:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:19:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:19:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:19:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:19:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:19:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:19:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:19:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:19:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:19:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:19:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:19:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:350;a:19:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:19:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:19:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:19:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:19:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:355;a:19:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:356;a:19:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:19:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:19:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:19:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:360;a:19:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:19:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:19:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:363;a:19:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:19:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:19:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:19:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:19:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:19:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:19:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:19:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:371;a:19:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:372;a:19:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:373;a:19:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:374;a:19:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:19:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:19:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:19:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:19:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:19:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:380;a:19:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:19:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:19:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:19:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:19:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:19:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:19:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:19:{s:4:\"tmpl\";i:1282;s:2:\"id\";i:22417;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1647354987;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:19:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:19:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:19:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:19:{s:4:\"tmpl\";i:1252;s:2:\"id\";i:22146;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1647177514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:19:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:19:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:18:\"editor_l