<?php
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>
<div id="woolentor_general_tabs" class="woolentor-admin-main-tab-pane">
    <div class="woolentor-admin-main-tab-pane-inner">
        <!-- Banner Start -->
        <div class="woolentor-admin-banner">
            <img src="<?php echo esc_url(WOOLENTOR_ADDONS_PL_URL.'includes/admin/assets/images/banner/welcome.png'); ?>" alt="<?php echo esc_attr__('Welcome To WooLentor','woolentor');?>">
        </div>
        <!-- Banner End -->

        <!-- Infoboxes Start -->
        <div class="woolentor-admin-infoboxes">

            <!-- Infobox Start -->
            <div class="woolentor-admin-infobox">
                <div class="woolentor-admin-infobox-icon"><i class="wli wli-file"></i></div>
                <div class="woolentor-admin-infobox-content">
                    <h3 class="woolentor-admin-infobox-title"><?php echo esc_html__('Documentation','woolentor'); ?></h3>
                    <p class="woolentor-admin-infobox-text"><?php echo esc_html__('We\'ve organized the documentation and kept it up to date on a regular basis. This manual will assist you in using our plugin effectively.','woolentor');?></p>
                    <a href="https://woolentor.com/documentation/" class="woolentor-admin-btn woolentor-admin-btn-primary-outline" target="_blank"><?php echo esc_html__('Get Now','woolentor'); ?></a>
                </div>
            </div>
            <!-- Infobox End -->

            <!-- Infobox Start -->
            <div class="woolentor-admin-infobox">
                <div class="woolentor-admin-infobox-icon"><i class="wli wli-play"></i></div>
                <div class="woolentor-admin-infobox-content">
                    <h3 class="woolentor-admin-infobox-title"><?php echo esc_html__('Video Tutorial','woolentor'); ?></h3>
                    <p class="woolentor-admin-infobox-text"><?php echo esc_html__('We create videos to make our customers comprehend the product quickly. Using video tutorials is a fantastic method to learn how to use our plugins. We\'ve compiled a list of videos for you.','woolentor'); ?></p>
                    <a href="https://www.youtube.com/watch?v=_MOgvsZJ6uA&list=PLk25BQFrj7wH9zCECMNCtEvvUKkpV5TYA&index=14" class="woolentor-admin-btn woolentor-admin-btn-primary-outline" target="_blank"><?php echo esc_html__('Video Tutorial','woolentor'); ?></a>
                </div>
            </div>
            <!-- Infobox End -->

            <!-- Infobox Start -->
            <div class="woolentor-admin-infobox">
                <div class="woolentor-admin-infobox-icon"><i class="wli wli-support"></i></div>
                <div class="woolentor-admin-infobox-content">
                    <h3 class="woolentor-admin-infobox-title"><?php echo esc_html__('Support','woolentor'); ?></h3>
                    <p class="woolentor-admin-infobox-text"><?php echo esc_html__('Please do not hesitate to contact us if you require assistance or want a free store set-up. We will assist you within 12-24 hours of receiving your inquiry.','woolentor');?></p>
                    <a href="https://woolentor.com/contact/" class="woolentor-admin-btn woolentor-admin-btn-primary-outline" target="_blank"><?php echo esc_html__('Get Support','woolentor'); ?></a>
                </div>
            </div>
            <!-- Infobox End -->

            <!-- Infobox Start -->
            <div class="woolentor-admin-infobox">
                <div class="woolentor-admin-infobox-icon"><i class="wli wli-feature-list"></i></div>
                <div class="woolentor-admin-infobox-content">
                    <h3 class="woolentor-admin-infobox-title"><?php echo esc_html__('Missing any Feature?','woolentor'); ?></h3>
                    <p class="woolentor-admin-infobox-text"><?php echo esc_html__('Have you ever noticed any missing features? Please notify us if you do. As soon as possible, our staff will add any necessary features based on your requests. Our commitment to our clients is second to none. We always attempt to fulfill their demands.','woolentor'); ?></p>
                    <a href="https://woolentor.com/contact/" class="woolentor-admin-btn woolentor-admin-btn-primary-outline" target="_blank"><?php echo esc_html__('Request','woolentor'); ?></a>
                </div>
            </div>
            <!-- Infobox End -->

        </div>
        <!-- Infoboxes End -->

        <!-- Subscribe Banner Start -->
        <div class="woolentor-admin-subscribe">
            <div class="woolentor-admin-subscribe-content">
                <h3 class="woolentor-admin-subscribe-title"><?php echo esc_html__('Subscribe and Get Offers','woolentor'); ?></h3>
                <p class="woolentor-admin-subscribe-text"><?php echo esc_html__('Sign up for our email list to get discounts, exclusive offers, the latest items, and news in your inbox.','woolentor');?></p>
            </div>
            <a href="https://hasthemes.com/subscribe-and-get-offers/" class="woolentor-admin-btn woolentor-admin-btn-primary" target="_blank"><?php echo esc_html__('Subscribe','woolentor'); ?></a>
        </div>
        <!-- Subscribe Banner End -->
    </div>
</div>