
<?php

    $currentTimeStamp = time();
    // $currentDateTime = date("Y-m-d H:i:s", $currentTimeStamp);

    $options = get_option('woodplus_option_notification');

    $default_options['notif_section'] = [
        'title' => '' ,
        'date' => $currentTimeStamp ,
        'image' => '' ,
        'description' => '' ,
    ];

    if( !isset( $options['notif_section'] ) && empty( $options['notif_section'] ) )
    {
        $options['notif_section'] = $default_options;
    }

?>
<div class="container woodmartplus-options-page" >
    <form action="" method="POST" style="display: flex; flex-direction: column; row-gap: 21px; width: 100%;">

        <div class="notif-setting">

            <div class="notif_setting_enable">
                <div class="setting_notif_eable_disable">
                    <h3><?php esc_html_e('Enable Notification','woodmartplus'); ?></h3>
                    <input type="checkbox" hidden="hidden" id="complated"  name="notification_data[setting_notif_enable]"   style="display:none" <?php echo isset( $options['enable_notif_data'] ) && 'on' === $options['enable_notif_data'] ? 'checked' : '' ?> >
                    <label class="switch" for="complated"></label>
                </div>
            </div>

            <div class="notif_show_items">
                    <div class="number-input">
                        <label for="notification_number"><?php esc_html_e('Show notification number','woodmartplus') ?>:</label>
                        <input type="number" id="notification_number" name="notification_data[show_notif_number]" min="1" max="6" value="<?php echo isset( $options['show_notif_number'] ) && !empty( $options['show_notif_number'] ) ? $options['show_notif_number'] : 4 ?>">
                    </div>
            </div>

        </div>
        <div class="notification-items-rea">

            <div class="notification-items" data-repeater-list="notification_data[notif_section]" >

            <?php foreach( $options['notif_section'] as $option ): ?>
                <div class="repeater-sections-notification" data-repeater-item>


                        <div class="notification-item-1 title-notification">
                            <label ><?php esc_html_e('عنوان کد','pgs-woo-api'); ?></label>
                            <input name="notification_data[notif_section][][notification_title]" type="text" value="<?php echo  esc_attr( $option['title'] ); ?>"  >
                        </div>

                        <div class="notification-item-2 notification-image">

                            <label ><?php esc_html_e('آپلود تصویر','pgs-woo-api'); ?></label>
                            <?php if( isset( $option['image'])  && !empty( $option['image'] ) ): ?>
                                <?php 
                                    $img_src = wp_get_attachment_image_src($option['image'],'medium');    
                                ?>
                                <div class="upload_image">
                                    <img src="<?php echo esc_url( $img_src[0] ); ?>" alt="">
                                </div>
                                <input type="hidden" name="notification_data[notif_section][][notification_image]" id="" class="upload_image_id" value="<?php echo  esc_attr( $option['image'] ); ?>" / >
                                <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Edit Image','woodmartplus'); ?></a>

                            <?php else: ?>

                                <div class="upload_image"></div>
                                <input type="hidden" name="notification_data[notif_section][][notification_image]" id="" class="upload_image_id" value="" / >
                                <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Add Image','woodmartplus'); ?></a>
                                <a href="javascript:void(0);" class="remove-image-button button-primary" style="display: none;" ><?php esc_html_e('remove image','woodmartplus'); ?></a>
                                
                            <?php endif; ?>
                            
                        </div>

                        <div class="notification-item-3 notification-description">
                            <label ><?php esc_html_e('توضیحات کوپن','pgs-woo-api'); ?></label>
                            <textarea name="notification_data[notif_section][][notification_description]" id="" cols="30" rows="10"><?php echo  esc_attr( $option['description'] ); ?></textarea>
                        </div>
                        
                        <input type="hidden" name="notification_data[notif_section][][date_create_notification]" class="date_notif_class" value="<?php echo  esc_attr( $option['date'] ); ?>" >
                        
                        <input data-repeater-delete type="button" class="button-primary" value="<?php esc_html_e('Delete','woodmartplus'); ?>" style="position: absolute; bottom: -30px; right: 70px;z-index: 1;"/>

                </div>
            <?php endforeach; ?>
            </div>

            <input class="button-primary" data-repeater-create type="button" value="<?php esc_html_e('Add','woodmartplus') ?>"/>

        </div>

        <button class="button-3" type="submit" name="notifications_save" value="save" ><?php esc_html_e('save data','woodmartplus'); ?></button>
    </form>
</div>