<?php

class woodplus_notification{


    public function __construct()
    {
        add_filter( 'woocommerce_account_menu_items', [$this , 'add_notification_item_tab'] );
        
        add_action( 'init', [ $this , 'new_end_point_myaccount_notifications_page' ] );

        add_action( 'woocommerce_account_notifications_endpoint', [ $this,'add_page_notification_myaccount' ] );

        add_filter( 'query_vars', [ $this , 'add_new_args_myaccount_notifications_page' ] );

        add_action('init', [$this, 'save_notification_option']);

    }

    public function add_notification_item_tab( $item )
    {
        $item['notifications'] = __( 'Notifications', 'woodmartplus' );
        return $item;
    }

    public function new_end_point_myaccount_notifications_page()
    {
        add_rewrite_endpoint( 'notifications', EP_ROOT | EP_PAGES );
    }

    public function add_page_notification_myaccount()
    {
        if( isset($_GET['show_notification'])  )
        {
            
            $id = absint( $_GET['show_notification'] );
            
            if( $this->show_notification( $id ) ){
                
                $data = [
                    'notifications' =>  $this->show_notification( $id ),
                ];
    
                return core_load_template('notifications.show',$data);
            }
        }

        if( !isset( $this->get_notification_option()['notif_section'] )  )
        {
            return core_load_template('notifications.empty');
        }

        $data = [
            'notifications' => $this->get_notification_option(),
        ];

        return core_load_template('notifications.index',$data);
    }

    public function add_new_args_myaccount_notifications_page($vars)
    {
        $vars[] = 'notifications';

        return $vars;
    }

    public function save_notification_option()
    {
        if( isset( $_POST['notifications_save'] ) && !empty( $_POST['notifications_save']  ) && 'save' === $_POST['notifications_save'] )
        {
            $new_notif_data ['notif_section'] = [
                [
                    'title' => '',
                    'date' => '',
                    'image' => '',
                    'description' => '',
                ]
            ];

            $new_notif_data['enable_notif_data'] = 'off';
            $new_notif_data['show_notif_number'] = 4;
         
            if(  !isset($_POST['notification_data']) )
            {
                delete_option('woodplus_option_notification');
                return ;
            }   

            
            if( isset( $_POST['notification_data'] ) )
            {

                if( isset( $_POST['notification_data']['setting_notif_enable'] ) && !empty( $_POST['notification_data']['setting_notif_enable'] ) )
                {
                    $enable_disable_notif = sanitize_text_field( $_POST['notification_data']['setting_notif_enable'] );

                    $new_notif_data['enable_notif_data'] = $enable_disable_notif;

                }

                if( isset( $_POST['notification_data']['show_notif_number'] ) && !empty( $_POST['notification_data']['show_notif_number'] ) )
                {
                    $show_notif_number = sanitize_text_field( $_POST['notification_data']['show_notif_number'] );

                    $new_notif_data['show_notif_number'] = $show_notif_number;

                }

                
                if( isset( $_POST['notification_data']['notif_section'] ) )
                {

                    foreach( $_POST['notification_data']['notif_section'] as $key => $data )
                    {
                        $new_notif_data['notif_section'][$key] = [
                            'title' => isset( $data['notification_title'] ) && !empty( $data['notification_title'] ) ? sanitize_text_field( $data['notification_title'] ) : '',
                            'date' => isset( $data['date_create_notification'] ) && !empty( $data['date_create_notification'] ) ? sanitize_text_field( $data['date_create_notification'] ) : '',
                            'image' => isset( $data['notification_image'] ) && !empty( $data['notification_image'] ) ? sanitize_text_field( $data['notification_image'] ) : '',
                            'description' => isset( $data['notification_description'] ) && !empty( $data['notification_description'] ) ? sanitize_text_field( $data['notification_description'] ) : '',
                            
                        ];
                    }
                }
                
                
                if( count($new_notif_data['notif_section']) <= 1 && !array_filter($new_notif_data['notif_section'][0]) )
                {
                    
                    unset($new_notif_data['notif_section']);
                }
              
                update_option('woodplus_option_notification',$new_notif_data);
            }


        }
    }

    public function get_notification_option()
    {
        return get_option('woodplus_option_notification');
    }

    public function show_notification( $id )
    {
        $notifications = $this->get_notification_option();
        
        if( isset( $notifications['notif_section'] ) )
        {

            if( isset( $notifications['notif_section'][$id] ) && !empty( $notifications['notif_section'][$id] ) )
            {

                return $notifications['notif_section'][$id];
            }

        }

        return false;
    }
}

new woodplus_notification;