<?php

class woodmartPlusInit
{
    public function __construct()
    {

        // add_action('woodplus_dashboard_head',[ $this, 'load_script_head' ]);

        add_action('admin_menu', [$this,'woodmartPlusAdminMenu'], 9);

        add_action('admin_enqueue_scripts', [$this, 'loadWoodmartPlusAdminScript']);

        
        if( 'on' === wplus_helper::get_general_option('enable_panel') )
        {
            add_action('template_redirect', [ $this, 'my_account_template_redirect' ]);

                // wc save value account;
            add_action('woocommerce_save_account_details', [$this , 'action_woocommerce_save_account_details'], 10, 1);

            add_action('woocommerce_save_account_details_errors', [$this,'check_phone_account_nummber']);

            //filter upload
            add_action('init', [$this,'buddyforms_allow_contributor_uploads']);

            add_filter('ajax_query_attachments_args', [$this,'filter_media']);

            add_action('custom_woocommerce_account_navigation', [ $this , 'load_mobile_navigation' ]);

            add_action('load_slider_template', [$this,'dashboard_load_slider_template'], 5);

            add_action('init', [$this, 'block_wp_admin_init' ], 0);
        }
        
        $this->loadFiles();
        $this->save_general_option();

    }
   
    public function block_wp_admin_init()
    {


        if (is_user_logged_in() && !wp_doing_ajax() && strpos(strtolower($_SERVER['REQUEST_URI']), '/wp-admin/') !== false) {

            if($this->wplus_check_user_role(['customer'])) {
                wp_redirect(get_option('siteurl'), 302);
            }
        }
    }

    public function dashboard_load_slider_template()
    {

        core_load_template('slider');
    }

    public static function get_myaccount_init_slug()
    {
        return get_post(get_option('woocommerce_myaccount_page_id'))->post_name;
    }

    public function load_mobile_navigation()
    {
        core_load_template('myaccount.mobile_navigation');
    }

    public function filter_media($query)
    {

        if($this->wplus_check_user_role(['customer'])) {
            $query['author'] = get_current_user_id();
        }
        
        return $query;
    }

    public function buddyforms_allow_contributor_uploads()
    {

        if($this->wplus_check_user_role(['customer'])) {
            add_filter('show_admin_bar', '__return_false');
        }
            
        if (current_user_can('customer') && !current_user_can('upload_files')) {

            $customer = get_role('customer');
            $customer->add_cap('upload_files');
            
        }
       
    }

    public function wplus_check_user_role($roles)
    {

        if (is_user_logged_in()) :

            $user = wp_get_current_user();

            $currentUserRoles = $user->roles;

            $isMatching = array_intersect($currentUserRoles, $roles);

            $response = false;

            if (!empty($isMatching)) :
                $response = true;
            endif;
            return $response;
        endif;
    }

    public function load_script_head()
    {
        add_action('wp_enqueue_scripts', [$this, 'woodmartPlusSLoadStyle']);
    }

    public function my_account_template_redirect()
    {
        global $wp,$wp_query;

        $white_list = [
            'my-account',
            'tickets',
            'orders',
            'view-order',
            'downloads',
            'notifications',
            'offers',
            'edit-address',
            'edit-account',
            'lost-password'
        ];

        $exp_url = explode('/', $wp->request);

        foreach($white_list as $value) {
            if(isset($wp_query->query['pagename']) && $wp_query->query['pagename'] == woodmartPlusInit::get_myaccount_init_slug() && isset($wp_query->query[$value])) {
                add_filter('page_template', [ $this, 'login_template_ui' ]);
                add_filter('woocommerce_locate_template', [$this , 'loadWoocommerceTempalte'], 999, 3);

            } elseif(count($exp_url) <= 1 &&  $exp_url[0] === woodmartPlusInit::get_myaccount_init_slug()) {
                add_filter('page_template', [ $this, 'login_template_ui' ]);
                add_filter('woocommerce_locate_template', [$this , 'loadWoocommerceTempalte'], 999, 3);
            }
        }

    }
    public function login_template_ui($page_template)
    {
        global $wp_query;

        if(is_page(woodmartPlusInit::get_myaccount_init_slug()) &&  is_user_logged_in()) {
            $page_template = DIR_PATH . 'template/myaccount/my-account.php';

        } elseif(isset($wp_query->query['lost-password'])) {

            if(isset($_GET['reset-link-sent']) && !empty($_GET['reset-link-sent']) && 'true' === $_GET['reset-link-sent']) {

                $page_template = DIR_PATH . 'template/myaccount/lost-password-confirmation.php';

            } elseif( isset($_GET['show-reset-form']) && !empty($_GET['show-reset-form']) && 'true' === $_GET['show-reset-form'] ){

                
                $page_template = DIR_PATH . 'template/myaccount/form-reset-password.php';
            }
            else {
                $page_template = DIR_PATH . 'template/myaccount/form-lost-password.php';
            }

        }

        return $page_template;
    }


    public function loadFiles()
    {
        if(!function_exists('jwoodmart_plus_date')) {
            include DIR_PATH . 'inc/jdf.php';
        }

        
        if( 'on' === wplus_helper::get_general_option('enable_panel') )
        {
            include DIR_PATH . 'inc/ticket/ticket.php';
            include DIR_PATH . 'inc/offer/offer.php';
            include DIR_PATH . 'inc/notification/notification.php';
            include DIR_PATH . 'inc/factor/factor.php';
    
            include DIR_PATH . 'inc/recently-viewed/recently-viewed.php';
        }

        include DIR_PATH . 'inc/sms/class-recaptcha.php';
        include DIR_PATH . 'inc/sms/login-register.php';
        include DIR_PATH . 'inc/elementor/elementor.php';

        // require_once DIR_PATH . 'inc/sms/otp-email-handler.php';
    }

    public function loadWoodmartPlusAdminScript()
    {

        wp_register_script('wplus-repater', WOODPLUS_ASSET . 'admin/js/jquery.repeater.min.js', ['jquery'], false, true);

        wp_register_script('wplus-admin', WOODPLUS_ASSET . 'admin/js/wplus-admin.js', ['jquery'], false, true);

        wp_register_script('wplus-admin-media', WOODPLUS_ASSET . 'admin/js/admin-media-uploader.js', ['jquery'], false, true);

        wp_enqueue_style('wplus-admin', WOODPLUS_ASSET . 'admin/css/wplus-admin.css');


    }

    public function woodmartPlusAdminMenu()
    {
        add_menu_page(__('woodmartPlus menu', 'woodmartplus'), __('woodmartplus', 'woodmartplus'), 'manage_options', 'woodmartplus-settings', [$this,'LoadTemplateAdminOffer']);
    }


    public function LoadTemplateAdminOffer()
    {
        $current_page = isset($_GET['tab']) && !empty($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'offers';
        $withe_list = ['offers','notifications','login_register','wplus_factor','ticket','general','video_tutorial'];

        if(!in_array($current_page, $withe_list)) {
            wp_die(__('You do not have access to this page', 'woodmartplus'));
        }
        $data = [
            'current_page' => $current_page
        ];

        wp_enqueue_media();
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');

        wp_enqueue_script('wplus-repater');
        wp_enqueue_script('wplus-admin');

        core_load_template('options.option', $data);
    }

    public function loadWoocommerceTempalte($template, $template_name, $template_path)
    {

        $new_dire_path = '';

        if(strpos($template, 'myaccount') && is_page(woodmartPlusInit::get_myaccount_init_slug())) {

            $template_directory = trailingslashit(DIR_PATH) . 'woocommerce/';

            $new_dire_path = $template_directory . $template_name;

        } elseif(strpos($template, 'order') && is_page(woodmartPlusInit::get_myaccount_init_slug())) {

            $template_directory = trailingslashit(DIR_PATH) . 'woocommerce/';

            $new_dire_path = $template_directory . $template_name;
        }

        return file_exists($new_dire_path) ? $new_dire_path : $template;
    }

    public function woodmartPlusSLoadStyle()
    {

        wp_enqueue_style('woodmart-plus-dashboard-style', WOODPLUS_ASSET . 'css/global.css', [], '7.3.0');

        wp_enqueue_script('w-plus', WOODPLUS_ASSET . 'js/w-plus.js', ['jquery'], false, true);

    }



    public function action_woocommerce_save_account_details($user_id)
    {

        if (isset($_POST['image'])) {

            update_user_meta($user_id, '_acount_image', sanitize_text_field($_POST['image']));
        }

        if(isset($_POST['account_display_phone']) && !empty($_POST['account_display_phone'])) {
            $phone = sanitize_text_field($_POST['account_display_phone']);
            update_user_meta($user_id, '_wplus_phone', $phone);
        }
    }

    public function check_phone_account_nummber($error)
    {
        $user_id = get_current_user_id();

        if(!get_user_meta($user_id, '_wplus_phone', true)) {
            if(isset($_POST['account_display_phone']) && !empty($_POST['account_display_phone'])) {
                $phone = sanitize_text_field($_POST['account_display_phone']);

                if($message = wplus_helper::account_validate_phone_number($phone)) {
                    $error->add('account_phone_error', $message);
                    return;
                }

                if(wplus_helper::phone_exists($phone)) {
                    $error->add('account_phone_error', __('phone is already exists', 'woodmartplus'));
                    return;
                }
            }
        }

    }

    public function account_field_phone_require($fields)
    {

        $fields['account_display_phone'] = __('phone number', 'woodmartplus');

        return $fields;
    }

    public function save_general_option()
    {
        if(isset($_POST['save_general_option']) && 'save' === $_POST['save_general_option']) {

            if(isset($_POST['general_option']) && !empty($_POST['general_option'])) {
                $santized_option['general_option'] = [
                    'recenlty_viwed_enable' => 'off'
                ];

                foreach($_POST['general_option'] as $key => $general_option) {
                    if(is_array($general_option)) {
                        foreach($general_option as $k => $option) {

                            if('slider_image' === $key) {
                                if(isset($option['image'])) {
                                    $santized_option['general_option'][$key][$k]['image'] = sanitize_text_field($option['image']);
                                }

                                if(isset($option['url'])) {
                                    $santized_option['general_option'][$key][$k]['url'] = sanitize_text_field($option['url']);
                                }


                            }
                        }

                    } else {

                        $santized_option['general_option'][$key] = sanitize_text_field($general_option);
                    }


                }
                update_option('wplus_general_option', $santized_option);
            }
        }
    }

}
