<?php

class woodplus_manage_select2_elementor{



    public function __construct()
    {
        add_action('wp_ajax_find_product',[ $this, 'process_ajax_find_product' ]);
        add_action('wp_ajax_save_product',[ $this,'process_ajax_save_product' ]);

        add_action('wp_ajax_find_product_exclude',[ $this,'process_find_product_to_exclude' ]);
        add_action('wp_ajax_save_product_exclude',[ $this, 'process_save_product_to_exclude' ]);

        add_action('wp_ajax_find_category_product',[ $this,'process_find_category_product' ]);
        add_action('wp_ajax_save_category_product', [ $this, 'process_save_category_product' ]);
    }

    public function process_find_category_product()
    {
      if( isset( $_GET['q'] ) && !empty( $_GET['q'] ) )
      {
        $args = [
            'search' => $_GET['q'],
            'taxonomy' => 'product_cat',
            'hide_empty' => true,
        ];

        $categires = get_categories($args );

        $response = [];

        foreach( $categires as $category )
        {
            $response[] = [
                'id' => $category->term_id,
                'text' => $category->cat_name,
            ];
        }

        wp_send_json($response);
      }
       
    }

    public function process_save_category_product()
    {

        $ids = explode(',',$_GET['ids']);

        $response = [];

        if (!empty($_GET['ids'])) {

            foreach($ids as $id) {

                $category = get_term_by('id', $id,'product_cat' );
                
                $response [] = [
                    'id' =>$category->term_id,
                    'text' =>$category->name
                ];

            }
            
                wp_send_json($response);
        }

        wp_send_json([
            'status' => false,
        ]);
    }

    public function process_find_product_to_exclude()
    {
        if( isset( $_GET['q'] ) && !empty( $_GET['q'] ) )
        {

            $args = array(
                's'        => $_GET['q'],
                'post_type'   => 'product',
                'post_status' => 'publish',
            );
            $products = wc_get_products($args);
            
            $response = [];
            
            foreach($products as $product ){
        
                $response[] = [
                    'id' =>$product->get_id(),
                    'text' => $product->get_title(),
                ];
            }
            wp_send_json($response);
        }

    }
    
    public function process_save_product_to_exclude()
    {

        $ids = explode(',',$_GET['ids']);

        $response = [];

        if (!empty($_GET['ids'])) {

            foreach($ids as $id) {

                $product = wc_get_product($id);

                $response [] = [
                    'id' =>$product->get_id(),
                    'text' =>$product->get_title()
                ];

            }
            
                wp_send_json($response);
        }

        wp_send_json([
            'status' => false,
        ]);
    }

    public function process_ajax_find_product()
    {
        $args = array(
            's'        => $_GET['q'],
            'post_type'   => 'product',
            'post_status' => 'publish',
        );
        $products = wc_get_products($args);
        
        $response = [];
        
        foreach($products as $product ){
    
            $response[] = [
                'id' =>$product->get_id(),
                'text' => $product->get_title(),
            ];
        }
        wp_send_json($response);
    }

    public function process_ajax_save_product()
    {

        $ids = explode(',',$_GET['ids']);

        $response = [];

        if (!empty($_GET['ids'])) {

            foreach($ids as $id) {

                $product = wc_get_product($id);

                $response [] = [
                    'id' =>$product->get_id(),
                    'text' =>$product->get_title()
                ];

            }
            
                wp_send_json($response);
        }

        wp_send_json([
            'status' => false,
        ]);
    }

}

new woodplus_manage_select2_elementor;