<?php
require_once 'notification.php';

class otp_handler{

    public $phone;
    public $ip_address;
	public $notification;
    

    public function __construct()
    {
		$this->notification = new notification();
        $this->ip_address = $this->get_default_ip_address();
		$this->cleanup();
        
    }
    
    public function only_send_otp( $phone_code , $phone_number )
    {
		$otp_created = $this->otp_generated();
		$operator = wplus_helper::get_operator_selected();

		if( is_wp_error( $operator ) )
		{
			return error_log( $operator->get_error_message() );
		}

		$data = wplus_helper::get_panel_detail($operator);

		$data['otp'] = $otp_created;
		$data['phone'] = $phone_number;
		
		$data = [
			'operator' => $operator,
			'detail_operator' => $data,
		];
		
		$object = wplus_helper::create_object_request($data);
	
		if(is_wp_error($object))
		{
			return error_log( $object->get_error_message() );
		}
		
        $this->notification->sendSms($operator,$object);

		return $otp_created;
    }

    public function send_otp_sms( $phone_code, $phone_no ){

		$ok_to_send_otp = $this->ok_to_send_otp( $phone_code, $phone_no );
		
		if( is_wp_error( $ok_to_send_otp ) ){
			return $ok_to_send_otp;
		}
		
		$phone_otp_data = $this->get_otp_data();
		
		if( $phone_otp_data){
			
			$sent_times 	= (int) $phone_otp_data['sent_times'];
			$incorrect 		= isset($phone_otp_data['incorrect']) ? $phone_otp_data['incorrect'] : ''; 
		}else{
			$incorrect = $sent_times = 0;
		}
		
		$otp = $this->only_send_otp( $phone_code, $phone_no );
		
		if( is_wp_error( $otp ) ){
			return $otp;
		}

	
		$sent_times++;
		
		$data = array(
			'phone_no' 		=> $phone_no,
			'phone_code' 	=> $phone_code,
			'otp' 			=> $otp,
			'created' 		=> strtotime('now'),
			'expiry' 		=> strtotime( wplus_helper::get_otp_config( 'expire_otp',120 ). ' seconds' ),
			'incorrect' 	=> $incorrect,
			'sent_times'	=> $sent_times,
			'verified' 		=> false,
			'form_token' 	=> false,
		);
		
		 $this->set_otp_data( $data );
		
		return $otp;
	}

    public function set_otp_data($key, $value = '')
    {
        $ip_address = $this->ip_address;
		$users 		= $this->get_otp_data();
		

		if( !is_array( $users ) ){
			$users = array();
		}

		if( !isset( $users[ $ip_address ] ) ){
			$users[ $ip_address ] = array();
		}
		
		if( is_array( $key ) ){
			$users[ $ip_address ] = wp_parse_args(
				$key,
				$users[ $ip_address ]
			);
		}else{
			$users[ $ip_address ][ $key ] = $value;
		}

		$users[ $ip_address ][ 'last_updated' ] = time();

		update_option( '_phone_user_detail', $users );

    }

    public function get_otp_data()
    {
        $users = get_option( '_phone_user_detail' );
		if( is_array( $users ) && isset( $users[ $this->ip_address ] ) ){
			return $users[ $this->ip_address ]; 
		}
		return $users;
    }

    public function otp_generated()
    {
		
        $number_of_digits = wplus_helper::get_otp_config( 'number_otp',4 ) ? wplus_helper::get_otp_config( 'number_otp',4 ) : 4 ;

        return rand( pow( 10, $number_of_digits - 1 ) , pow( 10, $number_of_digits ) - 1 );
    }

    public function get_default_ip_address(){

		if ( isset( $_SERVER['HTTP_X_REAL_IP'] ) ) { // WPCS: input var ok, CSRF ok.
			$ip = sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_REAL_IP'] ) );  // WPCS: input var ok, CSRF ok.
		} elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) { // WPCS: input var ok, CSRF ok.
			// Proxy servers can send through this header like this: X-Forwarded-For: client1, proxy1, proxy2
			// Make sure we always only send through the first IP in the list which should always be the client IP.
			$ip = (string) rest_is_ip_address( trim( current( preg_split( '/,/', sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) ) ) ) ); // WPCS: input var ok, CSRF ok.
		} elseif ( isset( $_SERVER['REMOTE_ADDR'] ) ) { // @codingStandardsIgnoreLine
			$ip = sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ); // @codingStandardsIgnoreLine
		} else{
			$ip = '';
		}
		$localhostCheck = array(
		    '127.0.0.1',
		    '::1'
		);
		

		$ip = in_array( $ip , $localhostCheck ) ? '' : $ip;
		
		return $ip;
	}

	public function ok_to_send_otp( $phone_code = '', $phone_no = '' ){

		$data = $this->get_otp_data();
		
		if( !is_array( $data ) || empty( $data ) ) return;


		$resend_limit 		= wplus_helper::get_otp_config( 'otp_resend',4 );
		$incorrect_limit 	= wplus_helper::get_otp_config( 'incorretct_otp',4 ); 
		$resend_wait_time 	= wplus_helper::get_otp_config( 'wating_resend',30 );
		$ban_time 			= wplus_helper::get_otp_config( 'ban_time',120 );
		
		$time_passed = strtotime("now") - (int) $data['created'];
		
		if( $data['sent_times'] > $resend_limit ){
			$unban_time_left = $ban_time - $time_passed;
			
			if(  $unban_time_left < 0  ){
				$this->set_otp_data( 'sent_times', 0 );
			}
			else{
				return new WP_Error( 'limit-reached', sprintf( __( 'OTP Limit reached. Please try again in %s.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
			}
		}
		
		if( $data['phone_no'] === $phone_no && $data['phone_code'] === $phone_code && $data['sent_times'] >= 1 &&  $resend_wait_time > $time_passed ){
			$unban_time_left = $resend_wait_time - $time_passed;
			return new WP_Error( 'resend-wait', sprintf( __( 'Please wait %s for a new OTP.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
		}

		
		if( $data['incorrect'] >= $incorrect_limit ){

			$unban_time_left = $ban_time - $time_passed;

			if( $unban_time_left < 0 ){

				$this->set_otp_data( 'incorrect', 0 );
			}
			else{
				return new WP_Error( 'tries-exceeded', sprintf( __( 'Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
			}
		}


	}

    public function getTimeDuration( $time ){
		return $time > 60 ? round($time/60). ' minutes' : $time. ' seconds';
	}


	public function get_otp_users(){

		return (array) get_option( '_phone_user_detail' );
		
	}

	public function cleanup(){

		$last_cleanup = (int) get_option( '_phone_user_detail_last_cleanup', true );

		$now = time();

		if( ( $now - $last_cleanup ) < ( apply_filters( '_cleanup_last_done', 24 ) * 1 ) ){
			return;
		}

		$users = $this->get_otp_users();

		if( empty( $users ) ) return;

		foreach ( $users as $ip_address => $user ) {
			//If user updated less than 10 mins ago, skip
			if( isset( $user[ 'last_updated' ] ) && ( $now - $user[ 'last_updated' ] ) < 600 ) continue;
			unset( $users[ $ip_address ] ); // remove ip address
		}

		update_option( '_phone_user_detail', $users );
		update_option( '_phone_user_detail_last_cleanup', $now );

	}

}