<?php


class wplus_helper{


    
    public static function rest_password_items()
    {
        if ( isset( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ] ) && 0 < strpos( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ], ':' ) ) {  // @codingStandardsIgnoreLine
            list( $rp_id, $rp_key ) = array_map( 'wc_clean', explode( ':', wp_unslash( $_COOKIE[ 'wp-resetpass-' . COOKIEHASH ] ), 2 ) ); // @codingStandardsIgnoreLine
            $userdata               = get_userdata( absint( $rp_id ) );
            $rp_login               = $userdata ? $userdata->user_login : '';
            $user                   = WC_Shortcode_My_Account::check_password_reset_key( $rp_key, $rp_login );

            // Reset key / login is correct, display reset password form with hidden key / login values.
            if ( is_object( $user ) ) {
                
                return [
                    'key' => $rp_key,
                    'login' => $rp_login,
                ];
                
            }
        }
    }

    public static function get_general_option( $option )
    {
        $options = get_option('wplus_general_option');

        if( !$options )
        {
            return false;
        }
        
        if( isset( $options['general_option'][$option] ) && !empty( $options['general_option'][$option] ) )
        {
            return $options['general_option'][$option];
        }

        return false;
    }

    public static function date_to_garegorian($timestamp, $format = '' )
    {
        if( empty( $format ) )
        {
            $format = get_option( 'date_format' );
        }
        
        if(function_exists('jwoodmart_plus_date')){
            
            return jwoodmart_plus_date($format, $timestamp);
    
        }
        return date($format , $timestamp);
    }

    public static function get_notif_config( $option_key , $defualt = '' )
    {
        $options = get_option('woodplus_option_notification');

        if( $options )
        {
            if( isset( $options[$option_key] ) && !empty( $options[$option_key] ) )    
            {
                return $options[$option_key];
            }
        }

        return $defualt;
    }   

    public static function get_notifs(  )
    {
      
        $all_notif = wplus_helper::get_notif_config('notif_section');

        $count =  wplus_helper::get_notif_config('show_notif_number') ?  (int) wplus_helper::get_notif_config('show_notif_number') : 3 ;
        
        
        $last_notif = [];

        if( $all_notif ){

            $last_to_first = array_reverse($all_notif);

            $i = 0;
    
            foreach($last_to_first as $key => $value)
            {
                
                if($count === $i)
                {
                    break;
                }

                $last_notif[] = $value;
    
                $i++;
            }
        }

        return $last_notif;
    }

    public static function get_offer_config( $option_key , $defualt = '' )
    {
        $options = get_option('woodplus_option_offer');

        if( $options )
        {
            if( isset( $options[$option_key] ) && !empty( $options[$option_key] ) )    
            {
                return $options[$option_key];
            }
        }

        return $defualt;
    }   

    public static function get_offers()
    {
        

        $all_notif = wplus_helper::get_offer_config('offer_section');
        $count = wplus_helper::get_offer_config('show_offer_number') ? (int) wplus_helper::get_offer_config('show_offer_number') : 3;

        $last_notif = [];

        if( $all_notif ){

            $last_to_first = array_reverse($all_notif);

            $i = 0;
    
            foreach($last_to_first as $key => $value)
            {
                if($count === $i)
                {
                    break;
                }

                $last_notif[] = $value;
    
                $i++;
            }
        }

        return $last_notif;
    }

    public static function get_otp_config( $option_key , $defualt = '' )
    {
        $options  = get_option( 'woodplus_sms' );
        
        if( !$options )
        {
            return $defualt;
        }

        foreach( $options['woodplus_sms'] as $key => $option )
        {
             if( isset( $option[$option_key] ) && !empty( $option[$option_key] ) )
             {
                return $option[$option_key];
             }
        }

        return $defualt;

    }

    public static function get_option_ticket( $option )
    {
        $options  = get_option( 'woodplus_ticket' );
        if( !isset( $option ) )
        {
            return false;
        }

        if( !isset( $options['ticket'][$option]  ) )
        {
            return false;
        }
        return $options['ticket'][$option];
    }

    public static function get_operator_selected()
    {
        $options  = get_option( 'woodplus_sms' );

        if( 'default' === $options['woodplus_sms']['operator_name'] )
        {
            return new WP_Error('101',__('First select operator'));
        }

        return $options['woodplus_sms']['operator_name'];
    }

    public static function get_type_login_register()
    {
        $options  = get_option( 'woodplus_sms' );

        if( isset( $options['woodplus_sms']['register_login_type'] ) && !empty( $options['woodplus_sms']['register_login_type'] ) )
        {
            return $options['woodplus_sms']['register_login_type'];
        }

        return 'layout-4';
    }

    public static function get_detail_login_register( $key , $defualt = '' )
    {
        $options  = get_option( 'woodplus_sms' );
        
        if( !$options )
        {
            return $defualt;
        }

        foreach( $options as $option )
        {
            if( isset( $option[$key] ) && !empty( $option[$key] ) )
            {
                return $option[$key];
            }
        }

        return $defualt;
    }

    public static function get_enable_disable_login_register()
    {
        $options  = get_option( 'woodplus_sms' );

        if( isset( $options['woodplus_sms']['setting_loginregister_enable'] ) && !empty( $options['woodplus_sms']['register_login_type'] ) )
        {
            return $options['woodplus_sms']['setting_loginregister_enable'];
        }

        return 'off';
    }

    public static function get_logo_login_register( $defualt = '' )
    {
        $options  = get_option( 'woodplus_sms' );
        if( isset( $options['woodplus_sms']['logo_login_register'] ) && !empty( $options['woodplus_sms']['logo_login_register'] ) )
        {
            $img_src = wp_get_attachment_image_src($options['woodplus_sms']['logo_login_register'],'medium'); 

            return $img_src[0];
        }
        return $defualt;
    }

    public static function get_background_img_color_login( $option )
    {
        $options = get_option( 'woodplus_sms' );

        if( 'img_background_login_register' === $option )
        {
            if( isset($options['woodplus_sms']['img_background_login_register']) && !empty( $options['woodplus_sms']['img_background_login_register'] ) )
            {
                $img_src = wp_get_attachment_image_src($options['woodplus_sms']['img_background_login_register'],'full'); 
                return $img_src[0];
            }
        }

        if( 'color_bg_login_register'  === $option )
        {
            if( isset($options['woodplus_sms']['color_bg_login_register']) && !empty( $options['woodplus_sms']['color_bg_login_register'] ) )
            {
                return $options['woodplus_sms']['color_bg_login_register'];
            }
        }

        if( 'logo_login_register_layout_3' === $option )
        {
            if( isset($options['woodplus_sms']['logo_login_register_layout_3']) && !empty( $options['woodplus_sms']['logo_login_register_layout_3'] ) )
            {
                $img_src = wp_get_attachment_image_src($options['woodplus_sms']['logo_login_register_layout_3'],'full'); 
                return $img_src[0];
            }
        }

        return false;
    }

    public static function get_image_login_register_layout_3( $option )
    {
        $options = get_option( 'woodplus_sms' );

        if( 'img_background_login_register' === $option )
        {
            if( isset($options['woodplus_sms']['img_background_login_register']) && !empty( $options['woodplus_sms']['img_background_login_register'] ) )
            {
                $img_src = wp_get_attachment_image_src($options['woodplus_sms']['img_background_login_register'],'full'); 
                return $img_src[0];
            }
        }

        if( 'color_bg_login_register'  === $option )
        {
            if( isset($options['woodplus_sms']['color_bg_login_register']) && !empty( $options['woodplus_sms']['color_bg_login_register'] ) )
            {
                return $options['woodplus_sms']['color_bg_login_register'];
            }
        }
        
        return false;
    }

    public static function get_panel_detail( $operator )
    {
        $options  = get_option( 'woodplus_sms' );

        if( isset( $options['woodplus_sms'][$operator] ) && !empty( $options['woodplus_sms'][$operator] ) )
        {
            return $options['woodplus_sms'][$operator];
        }
    }

    public static function create_object_request($data)
    {
    
        if(empty($data['detail_operator']))
        {
            return new WP_Error('operator-detail',__('Please Set Data Operator','woodmartplus'));
        }

        if(!file_exists( $request_file = DIR_PATH . 'inc/sms/request/' .  $data['operator'] . '-request.php' ))
        {
            return new WP_Error('operator-file-not-exist',__('Operator File Not Found','woodmartplus'));
        }

        require_once $request_file;
            
        $request_class =  $data['operator'] . 'Request';
        
        if(!class_exists($request_class))
        {
            return new WP_Error('class-not-exist',__('Class: ' . $request_class . ' Not Found'));
        }
       
        $object =  new $request_class( $data );
        
        return $object;
    }

    public static function get_user_order_status( $customer_orders )
    {
        $status = [];
        
        foreach( $customer_orders->orders as $customer_order )
        {
                $order = wc_get_order( $customer_order );  
                $status [] = $order->get_status();
        }

        return $status;
    }


    public static function render_product_attr($product)
    {
        $all_attributes = [];
        if(get_class($product) === 'WC_Product_Variation')
        {
            foreach($product->get_variation_attributes() as $taxonomy => $terms_slug)
            {
                
                $taxonomy_label = wc_attribute_label( str_replace('attribute_','',$taxonomy));
                
                
                $term_obj = get_term_by('slug',$terms_slug,str_replace('attribute_','',$taxonomy));
                $variations_attributes_and_values[$taxonomy] = array('label' => $taxonomy_label);

                    
                    $term_name = $term_obj->name; 
                    

                    $all_attributes [$taxonomy_label]= [
                        'name' => $term_name,
                    ];

            }

            return $all_attributes;
        }

        $attributes = $product->get_attributes();
        foreach($attributes as $key => $attribute)
        {   
            $attr_value =  wc_get_product_terms( $product->get_id(), $key, array( 'fields' => 'names' ) );

            if( $attr_value )
            {
                $label = wc_attribute_label($key);
                $all_attributes [$label] = $attr_value;
            }
           
        }
        
        return $all_attributes;


    }

    public static function get_total_discount_order($items)
    {
        $total_discount = 0;
        foreach ($items as $item) {

            $product = $item->get_product();
            if ($product->is_on_sale()) {
                $regular_price = $product->get_regular_price();
                $sale_price = $product->get_sale_price();
                $discount = ($regular_price - $sale_price) * $item->get_quantity();
                $total_discount += $discount;
            }
        }
        return $total_discount;
        // return esc_html('No discount','ganje-core');

    }

    public static function get_downloads_files( $donwloads )
    {

        $new_array = [];

        foreach( $donwloads as $key => $download )
        {
            
        $new_array[$download['order_id']][$download['product_name']]['name'] = $download['product_name'];
        $new_array[$download['order_id']][$download['product_name']]['access_expires'] = $download['access_expires'];
        $new_array[$download['order_id']][$download['product_name']]['downloads_remaining'] = $download['downloads_remaining'];
        $new_array[$download['order_id']][$download['product_name']]['file'][$key]['url'] = $download['download_url'];
        $new_array[$download['order_id']][$download['product_name']]['file'][$key]['name'] = $download['file']['name'];
        
        } 
        
        return $new_array;
    }

    public static function _woocommerce_form_field( $key, $args, $value = null ) {
        $defaults = array(
            'type'              => 'text',
            'label'             => '',
            'description'       => '',
            'placeholder'       => '',
            'maxlength'         => false,
            'minlength'         => false,
            'required'          => false,
            'autocomplete'      => false,
            'id'                => $key,
            'class'             => array(),
            'label_class'       => array(),
            'input_class'       => array(),
            'return'            => false,
            'options'           => array(),
            'custom_attributes' => array(),
            'validate'          => array(),
            'default'           => '',
            'autofocus'         => '',
            'priority'          => '',
        );
    
        $args = wp_parse_args( $args, $defaults );
        $args = apply_filters( 'woocommerce_form_field_args', $args, $key, $value );
    
        if ( is_string( $args['class'] ) ) {
            $args['class'] = array( $args['class'] );
        }
    
        if ( $args['required'] ) {
            $args['class'][] = 'validate-required';
            $required        = '&nbsp;<span class="required text_danger" title="' . esc_attr__( 'required', 'woocommerce' ) . '">*</span>';
        } else {
            $required = '&nbsp;<span class="optional">(' . esc_html__( 'optional', 'woocommerce' ) . ')</span>';
        }
    
        if ( is_string( $args['label_class'] ) ) {
            $args['label_class'] = array( $args['label_class'] );
        }
    
        if ( is_null( $value ) ) {
            $value = $args['default'];
        }
    
        // Custom attribute handling.
        $custom_attributes         = array();
        $args['custom_attributes'] = array_filter( (array) $args['custom_attributes'], 'strlen' );
    
        if ( $args['maxlength'] ) {
            $args['custom_attributes']['maxlength'] = absint( $args['maxlength'] );
        }
    
        if ( $args['minlength'] ) {
            $args['custom_attributes']['minlength'] = absint( $args['minlength'] );
        }
    
        if ( ! empty( $args['autocomplete'] ) ) {
            $args['custom_attributes']['autocomplete'] = $args['autocomplete'];
        }
    
        if ( true === $args['autofocus'] ) {
            $args['custom_attributes']['autofocus'] = 'autofocus';
        }
    
        if ( $args['description'] ) {
            $args['custom_attributes']['aria-describedby'] = $args['id'] . '-description';
        }
    
        if ( ! empty( $args['custom_attributes'] ) && is_array( $args['custom_attributes'] ) ) {
            foreach ( $args['custom_attributes'] as $attribute => $attribute_value ) {
                $custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $attribute_value ) . '"';
            }
        }
    
        if ( ! empty( $args['validate'] ) ) {
            foreach ( $args['validate'] as $validate ) {
                $args['class'][] = 'validate-' . $validate;
            }
        }
    
        $field           = '';
        $label_id        = $args['id'];
        $sort            = $args['priority'] ? $args['priority'] : '';
        
        $field_container = '<div class="solid_input %1$s" id="%2$s" data-priority="' . esc_attr( $sort ) . '">%3$s</div>';
        
        switch ( $args['type'] ) {
            case 'country':
                $countries = 'shipping_country' === $key ? WC()->countries->get_shipping_countries() : WC()->countries->get_allowed_countries();
    
                if ( 1 === count( $countries ) ) {
    
                    $field .= '<strong>' . current( array_values( $countries ) ) . '</strong>';
    
                    $field .= '<input type="hidden" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="' . current( array_keys( $countries ) ) . '" ' . implode( ' ', $custom_attributes ) . ' class="country_to_state" readonly="readonly" />';
    
                } else {
                    $data_label = ! empty( $args['label'] ) ? 'data-label="' . esc_attr( $args['label'] ) . '"' : '';
    
                    $field = '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="country_to_state country_select ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ? $args['placeholder'] : esc_attr__( 'Select a country / region&hellip;', 'woocommerce' ) ) . '" ' . $data_label . '><option value="">' . esc_html__( 'Select a country / region&hellip;', 'woocommerce' ) . '</option>';
    
                    foreach ( $countries as $ckey => $cvalue ) {
                        $field .= '<option value="' . esc_attr( $ckey ) . '" ' . selected( $value, $ckey, false ) . '>' . esc_html( $cvalue ) . '</option>';
                    }
    
                    $field .= '</select>';
    
                    $field .= '<noscript><button type="submit" name="woocommerce_checkout_update_totals" value="' . esc_attr__( 'Update country / region', 'woocommerce' ) . '">' . esc_html__( 'Update country / region', 'woocommerce' ) . '</button></noscript>';
    
                }
    
                break;
            case 'state':
                /* Get country this state field is representing */
                $for_country = isset( $args['country'] ) ? $args['country'] : WC()->checkout->get_value( 'billing_state' === $key ? 'billing_country' : 'shipping_country' );
                $states      = WC()->countries->get_states( $for_country );
    
                if ( is_array( $states ) && empty( $states ) ) {
    
                    $field_container = '<p class="form-row %1$s" id="%2$s" style="display: none">%3$s</p>';
    
                    $field .= '<input type="hidden" class="hidden" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="" ' . implode( ' ', $custom_attributes ) . ' placeholder="' . esc_attr( $args['placeholder'] ) . '" readonly="readonly" data-input-classes="' . esc_attr( implode( ' ', $args['input_class'] ) ) . '"/>';
    
                } elseif ( ! is_null( $for_country ) && is_array( $states ) ) {
                    $data_label = ! empty( $args['label'] ) ? 'data-label="' . esc_attr( $args['label'] ) . '"' : '';
    
                    $field .= '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="state_select ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ? $args['placeholder'] : esc_html__( 'Select an option&hellip;', 'woocommerce' ) ) . '"  data-input-classes="' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . $data_label . '>
                        <option value="">' . esc_html__( 'Select an option&hellip;', 'woocommerce' ) . '</option>';
    
                    foreach ( $states as $ckey => $cvalue ) {
                        $field .= '<option value="' . esc_attr( $ckey ) . '" ' . selected( $value, $ckey, false ) . '>' . esc_html( $cvalue ) . '</option>';
                    }
    
                    $field .= '</select>';
    
                } else {
    
                    $field .= '<input type="text" class="input-text ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" value="' . esc_attr( $value ) . '"  placeholder="' . esc_attr( $args['placeholder'] ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" ' . implode( ' ', $custom_attributes ) . ' data-input-classes="' . esc_attr( implode( ' ', $args['input_class'] ) ) . '"/>';
    
                }
    
                break;
            case 'textarea':
                $field .= '<textarea name="' . esc_attr( $key ) . '" class="input-text ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" id="' . esc_attr( $args['id'] ) . '" placeholder="' . esc_attr( $args['placeholder'] ) . '" ' . ( empty( $args['custom_attributes']['rows'] ) ? ' rows="2"' : '' ) . ( empty( $args['custom_attributes']['cols'] ) ? ' cols="5"' : '' ) . implode( ' ', $custom_attributes ) . '>' . esc_textarea( $value ) . '</textarea>';
    
                break;
            case 'checkbox':
                $field = '<label class="checkbox ' . implode( ' ', $args['label_class'] ) . '" ' . implode( ' ', $custom_attributes ) . '>
                        <input type="' . esc_attr( $args['type'] ) . '" class="input-checkbox ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="1" ' . checked( $value, 1, false ) . ' /> ' . $args['label'] . $required . '</label>';
    
                break;
            case 'text':
            case 'password':
            case 'datetime':
            case 'datetime-local':
            case 'date':
            case 'month':
            case 'time':
            case 'week':
            case 'number':
            case 'email':
            case 'url':
            case 'tel':
                $field .= '<input type="' . esc_attr( $args['type'] ) . '" class="input-text ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" placeholder="' . esc_attr( $args['placeholder'] ) . '"  value="' . esc_attr( $value ) . '" ' . implode( ' ', $custom_attributes ) . ' />';
                
    
                break;
            case 'hidden':
                $field .= '<input type="' . esc_attr( $args['type'] ) . '" class="input-hidden ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" value="' . esc_attr( $value ) . '" ' . implode( ' ', $custom_attributes ) . ' />';
    
                break;
            case 'select':
                $field   = '';
                $options = '';
    
                if ( ! empty( $args['options'] ) ) {
                    foreach ( $args['options'] as $option_key => $option_text ) {
                        if ( '' === $option_key ) {
                            // If we have a blank option, select2 needs a placeholder.
                            if ( empty( $args['placeholder'] ) ) {
                                $args['placeholder'] = $option_text ? $option_text : __( 'Choose an option', 'woocommerce' );
                            }
                            $custom_attributes[] = 'data-allow_clear="true"';
                        }
                        $options .= '<option value="' . esc_attr( $option_key ) . '" ' . selected( $value, $option_key, false ) . '>' . esc_html( $option_text ) . '</option>';
                    }
    
                    $field .= '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $args['id'] ) . '" class="select ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" ' . implode( ' ', $custom_attributes ) . ' data-placeholder="' . esc_attr( $args['placeholder'] ) . '">
                            ' . $options . '
                        </select>';
                }
    
                break;
            case 'radio':
                $label_id .= '_' . current( array_keys( $args['options'] ) );
    
                if ( ! empty( $args['options'] ) ) {
                    foreach ( $args['options'] as $option_key => $option_text ) {
                        $field .= '<input type="radio" class="input-radio ' . esc_attr( implode( ' ', $args['input_class'] ) ) . '" value="' . esc_attr( $option_key ) . '" name="' . esc_attr( $key ) . '" ' . implode( ' ', $custom_attributes ) . ' id="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '"' . checked( $value, $option_key, false ) . ' />';
                        $field .= '<label for="' . esc_attr( $args['id'] ) . '_' . esc_attr( $option_key ) . '" class="radio ' . implode( ' ', $args['label_class'] ) . '">' . esc_html( $option_text ) . '</label>';
                    }
                }
    
                break;
        }
    
        if ( ! empty( $field ) ) {
            $field_html = '';
    
            if ( $args['label'] && 'checkbox' !== $args['type'] ) {
                $field_html .= '<label for="' . esc_attr( $label_id ) . '" class="' . esc_attr( implode( ' ', $args['label_class'] ) ) . '">' . wp_kses_post( $args['label'] ) . $required . '</label>';
            }
    
            $field_html .= '<span class="woocommerce-input-wrapper">' . $field;
    
            if ( $args['description'] ) {
                $field_html .= '<span class="description" id="' . esc_attr( $args['id'] ) . '-description" aria-hidden="true">' . wp_kses_post( $args['description'] ) . '</span>';
            }
    
            $field_html .= '</span>';
    
            $container_class = esc_attr( implode( ' ', $args['class'] ) );
            $container_id    = esc_attr( $args['id'] ) . '_field';
            
            $field           = sprintf( $field_container, $container_class, $container_id, $field_html );
            
        }
        
        /**
         * Filter by type.
         */
        $field = apply_filters( 'woocommerce_form_field_' . $args['type'], $field, $key, $args, $value );
    
        /**
         * General filter on form fields.
         *
         * @since 3.4.0
         */
        $field = apply_filters( 'woocommerce_form_field', $field, $key, $args, $value );
    
        if ( $args['return'] ) {
            return $field;
        } else {
            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            echo $field;
            
        }
    }

    public static function account_validate_phone_number($phone)
	{
        $message = '';
		if(intval(substr($phone,0,2)) !== intval('09')){
            
            $message = 'شماره مورد نظر باید با 09 شروع شود';
			return $message;
		}

		if(strlen($phone) !== 11){

            $message = 'شماره موبایل وارد شده صحیح نمی باشد';
            return $message;
		}

		return false;
	}

    public static function phone_exists($phone)
    {

        $args = [
            'meta_key' => '_wplus_phone',
            'meta_value' => $phone,
        ];

        $user = get_users($args);
       
        if(!empty($user))
        {
            return true;
        }

        return false;
    }

    public static function _price_discount( $product )
    {
            
        $discount = 0;
        if ($product->is_on_sale() && $product->is_type( 'variable' )){
            
            $available_variations = $product->get_available_variations();
            for ($i = 0; $i < count($available_variations); ++$i) {
                $variation_id=$available_variations[$i]['variation_id'];
                $variable_product1= new WC_Product_Variation( $variation_id );
                $regular_price = $variable_product1->get_regular_price();
                $sales_price = $variable_product1->get_sale_price();
                if(is_numeric($regular_price) && is_numeric($sales_price)){
                    $percentage = round( (( $regular_price - $sales_price ) / $regular_price ) * 100 ) ;
                    if ($percentage > $discount) {
                        $discount = $percentage;
                    }
                }
            }
        }elseif($product->is_on_sale() && $product->is_type( 'simple' )){
            
            $regular_price	= $product->get_regular_price();
            $sales_price	= $product->get_sale_price();
            if(is_numeric($regular_price) && is_numeric($sales_price)){
                $discount = round( ( ( $regular_price - $sales_price ) / $regular_price ) * 100 );
            }
        }
        if( $discount > 0 ){
            $text_discount = $discount;
        }else{
            $text_discount = '';
        }
        return 	$text_discount;
    }

    public static function get_total_compressed_order()
    {
        $args = array(
			'meta_key'    => '_customer_user',
			'meta_value'  => get_current_user_id(),
			'post_type'   => wc_get_order_types( 'view-orders' ),
			'post_status' => 'wc-completed',
            'posts_per_page' => -1,
		);

        $orders = get_posts( $args );

        if( $orders )
        {
            return count($orders);
        }

        return 0;
    }

    public static function get_total_price_completed()
    {
        $args = array(
			'meta_key'    => '_customer_user',
			'meta_value'  => get_current_user_id(),
			'post_type'   => wc_get_order_types( 'view-orders' ),
			'post_status' => 'wc-completed',
            'posts_per_page' => -1,
		);

        $orders = get_posts( $args );

        $total = 0;

        if( $orders )
        {
            
            foreach( $orders as $order )
            {
                
                $order = wc_get_order( $order->ID );

                if( $order )    
                {
                    $total += $order->get_total();
                }
                
            }
            
        }
        return wc_price($total);
    }
    
    public static function get_approve_comment()
    {
        $user_id = get_current_user_id();

        $args = array (
            'user_id'        => $user_id,
            'comment_approve'    => 1,
            'number'         => -1,
        );
        
        $comments = get_comments( $args );

        if( $comments )
        {
            return count( $comments );
        }
        
        return 0;
    }

    public static function is_user_completed_information(  )
    {
        $user_id = get_current_user_id();

        if( $user_id )
        {
            $user_detail = get_user_by('id',$user_id);
            if( $user_detail->user_email &&
                get_user_meta($user_id,'nickname',true)&&
                get_user_meta($user_id,'first_name',true)&&
                get_user_meta($user_id,'last_name',true)&&
                get_user_meta($user_id,'_wplus_phone',true) &&
                get_user_meta($user_id,'_acount_image',true)
            )
            {
                return true;
            }
            return false;
        }
    }

    public static function get_fonts()
    {
        return [
            'IRANSansX'         => 'ایرانسنس',
            'DoranMedium'       => 'دوران',
            'YekanBakhRegular'  => 'یکان بخ'
        ];
    }

    public static function check_panel_is_active()
    {
        $operator = wplus_helper::get_operator_selected();
        
        if( is_wp_error( $operator ) )
        {
            return false;
        }


        $data = wplus_helper::get_panel_detail($operator);
        
        foreach( $data as $value )
        {
        
            if( empty( $value ) )
            {
                return false;
            }
        }
        return true;
    }

    public static function get_page_register()
    {
        $result = [];

        $args = [
            'post_type' => 'page',
            'post_status' => 'publish',
            'posts_per_page' => -1,
        ];
        $posts = get_posts($args);
        if( $posts )
        {
            // $result[$post->ID ]
            foreach($posts as $post)
            {
                $result[ $post->ID ] = $post->post_title;
            }
        }
        return $result;
    }

    public static function get_page_by_id() : string
    {

        $id = wplus_helper::get_detail_login_register('termsـandـconditions');
        
        $post = get_post( $id );

        if( $post )
        {   
            return get_permalink( $post->ID );
        }
        
        return false;
    }

    public static function generate_terms_condition()
    {
       $terms =  wplus_helper::get_detail_login_register('description_login_register');
                 
       if( $terms  )
       {
            if( strpos($terms,'[wplus_term_condion]') )
            {
                $url = wplus_helper::get_page_by_id() ? esc_url( wplus_helper::get_page_by_id() ) : '#';

                $replace = '<a href="'.$url.'" target="_blank" class="link_primary" >شرایط و قوانین</a>';

                $new_terms = str_replace('[wplus_term_condion]',$replace,$terms);

                return $new_terms;
            }
       }

       return $terms; 
    }

    public static function script_needed_other_plugin()
    {
        if( defined( 'PW_VERSION' ) && class_exists('Persian_Woocommerce_Address') )
        {
             PW()->address->inline_js(true); 
             ?><script src="<?php echo WOODPLUS_ASSET ?>js/iran_cities_wdplus.min.js" ></script><?php
        }
    }

    public static function woodplus_elementor_woocommerce_query($how_to_display, $data=[])
    {
        extract($data);
        
        $args = [
            'post_type' => 'product',
            'order'     => $order,
            'orderby'   => $orderby,
            'posts_per_page' => $posts_per_page,
        ];
    
        switch ($how_to_display){
    
    
            case 'all_product':
    
            break;
    
            case 'featured':
                $args['tax_query'] = [
                    [
                        'taxonomy' => 'product_visibility',
                        'field' => 'name',
                        'terms' => 'featured',
                        'operator' => 'IN'
                    ]
                ];
            break;
    
            case 'best_selle':
                $args['meta_key'] = 'total_sales';
                $args['orderby'] = 'meta_value_num';
            break;
    
            case 'select_product':
                $args ['post__in'] = $product_include;
            break;
    
            case 'on_sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;
        }
        if($category)
        {
            if(isset( $args['tax_query'] ))
            {
                $args['tax_query'][]= [
                    [
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $category,
                    ]
                ];
        
            }else{
                $args['tax_query'] = [
                    [
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $category,
                    ],
                ];
            }
            
        }
        
        if($product_exclude)
        {

            if( 'on_sale' === $how_to_display )
            {
                $ids_on_sale = array_merge( wc_get_product_ids_on_sale() );

                $diffrent_ids = array_diff( $ids_on_sale,$product_exclude );

                $args['post__in'] = $diffrent_ids;

            }else{

                $args['post__not_in'] = $product_exclude;
            }

            
        }
        
        return $args;
    }

    public static function  woodplus_count_down($product, $class='' , $check = false){
        
        if(!$product){
            return;
        }
    
        if ( $product->is_on_sale() ) {
            if ( $product->is_type( 'variable' ) ) {
                
                $variations = $product->get_available_variations( 'object' );
                $date_diff  = '';
                $sale_date  = '';
                foreach ( $variations as $variation ) {
                    
                    if ( $variation->is_on_sale() ) {
    
                        $new_date = get_post_meta( $variation->get_id(), '_sale_price_dates_to', true );
    
                        if ( ! $new_date || ( $date_diff && $date_diff != $new_date ) ) {
                            $date_diff = false;
                        } elseif ( $new_date ) {
                            if ( false !== $date_diff ) {
                                $date_diff = $new_date;
                            }
                            $sale_date = $new_date;
                        }
                        if ( false === $date_diff && $sale_date ) {
                            break;
                        }
                    }
                    
                }
                if ( $date_diff ) {
                    
                    $date_diff = date( 'Y/m/d H:i:s', (int) $date_diff );
                } elseif ( $sale_date ) {
                    
                    $date_diff = date( 'Y/m/d H:i:s', (int) $sale_date );
                }
                
            } else {
    
                $date_diff = $product->get_date_on_sale_to();
                if ( $date_diff ) {
                    $date_diff = $date_diff->date( 'Y/m/d H:i:s' );
                }
    
            }
            if ( $date_diff ) :

                $timezone = 'GMT';
                if ( apply_filters( 'woodmart_wp_timezone', false ) ) {
                    $timezone = wc_timezone_string();
                }

                if( true === $check )
                {
                    return true;
                }
              
               
                woodmart_enqueue_js_library( 'countdown-bundle' );
                woodmart_enqueue_js_script( 'countdown-element' );
                woodmart_enqueue_inline_style( 'countdown' );
                
                ob_start();
                if( $class == 'slider-timer' )
                {
                    ?>
                        <div class="wd-product-countdown wdplus-timer <?php echo esc_attr( $class ); ?>" data-end-date="<?php echo esc_attr( date( 'Y-m-d H:i:s', strtotime($date_diff) ) ) ?>" data-timezone="<?php echo $timezone; ?>">
                        </div>
                    <?php
                }elseif( $class == 'amazing-slider-timer' )
                {
                    ?>
                        <div class="wd-product-countdown wdplus-timer <?php echo esc_attr( $class ); ?>" data-end-date="<?php echo esc_attr( date( 'Y-m-d H:i:s', strtotime($date_diff) ) ) ?>" data-timezone="<?php echo $timezone; ?>">
                            <div class="timer-days"><svg width="37" height="37" viewBox="0 0 37 37" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="18.5" cy="18.5" r="17.5" stroke="#CACACA" stroke-width="2" /> <circle class="foreground-circle" cx="18.5" cy="18.5" r="17.5" stroke="#EE273A" stroke-width="2" stroke-dasharray="110" stroke-dashoffset="0" /> </svg><p></p> <p>روز</p></div> 
                            <div class="timer-hours"><svg width="37" height="37" viewBox="0 0 37 37" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="18.5" cy="18.5" r="17.5" stroke="#CACACA" stroke-width="2" /> <circle class="foreground-circle" cx="18.5" cy="18.5" r="17.5" stroke="#EE273A" stroke-width="2" stroke-dasharray="110" stroke-dashoffset="0" /> </svg><p></p> <p>ساعت</p></div> 
                            <div class="timer-min"><svg width="37" height="37" viewBox="0 0 37 37" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="18.5" cy="18.5" r="17.5" stroke="#CACACA" stroke-width="2" /> <circle class="foreground-circle" cx="18.5" cy="18.5" r="17.5" stroke="#EE273A" stroke-width="2" stroke-dasharray="110" stroke-dashoffset="0" /> </svg><p></p> <p>دقیقه</p></div> 
                            <div class="timer-second"><svg width="37" height="37" viewBox="0 0 37 37" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="18.5" cy="18.5" r="17.5" stroke="#CACACA" stroke-width="2" /> <circle class="foreground-circle" cx="18.5" cy="18.5" r="17.5" stroke="#EE273A" stroke-width="2" stroke-dasharray="110" stroke-dashoffset="0" /> </svg><p></p> <p>ثانیه</p></div>
                        </div>
                    <?php
                }
                $html = ob_get_clean();
                return $html;
            endif;
        }
    }

    public static function get_terms_by_id_product( $product )
    {
        if( !$product )
        {
            return;
        }

        $terms = get_terms([
            'taxonomy' => 'product_cat',
            'object_ids' => $product->get_id(),
        ]);

        if( !is_wp_error( $terms ) && is_array( $terms ) )
        {
            return end( $terms );
        }
        return false;
    }
}