<?php

class wplus_ticket{


    public function __construct()
    {
        $this->save_ticket_data_option();

        if( 'on' === wplus_helper::get_option_ticket( 'setting_ticket_enable' ) )
        {
            add_action('add_meta_boxes',[$this,'wplus_ticket_meta_boxes']);

            add_filter( 'woocommerce_account_menu_items', [$this,'add_ticket_tab_in_my_acoount'] );

            add_action( 'init', [$this,'add_end_point_ticket_woocmmerce_my_account'] );

            add_filter( 'query_vars', [$this , 'add_new_args_myaccount_ticket_page'] );

            add_action('woocommerce_account_tickets_endpoint',[$this,'add_page_tickets_myaccount']);

            add_filter('use_block_editor_for_post_type', [$this,'prefix_disable_gutenberg'], 10, 2);

            add_action( 'init', [$this,'ticket_register_post_type'],999);
            
            add_action('init',[$this,'customer_added_ticket']);

            add_action('save_post',[$this,'woodmartplus_replay_message_save'],999,2);

            add_filter( 'manage_edit-wplus_ticket_columns', array( $this, 'add_custom_columns_heads'),15 );
            
            add_action( 'manage_wplus_ticket_posts_custom_column', array( $this, 'add_custom_content_columns'), 10, 2 );

            //filter ticket admin
            add_action('restrict_manage_posts', array( $this,'woodmartplus_filters_in_post_type_ticket'));
            
            add_filter('parse_query',array( $this,'wplus_ticket_filter_query'));
        }

        
    }

    public function save_ticket_data_option( )
    {
        if( isset( $_POST['save_ticket_data'] ) && 'save' === $_POST['save_ticket_data'] ) 
        {
            
            
            if( isset( $_POST['ticket'] ) && !empty( $_POST['ticket'] ) )
            {
                $santized_data['ticket'] = [
                    'setting_ticket_enable' => 'off',
                ];

                foreach( $_POST['ticket'] as $key => $ticket_data )
                {
                    $santized_data['ticket'][$key] = is_array( $ticket_data ) ? array_map('sanitize_text_field',$ticket_data) : sanitize_text_field( $ticket_data );
                }
                
                update_option('woodplus_ticket',$santized_data);

            }
            
        }

    }

    public function woodmartplus_replay_message_save($post_id , $post_obj)
    {
       
        if ( !isset( $_POST['woodmartplus_admin_action'] ) || !wp_verify_nonce( $_POST['woodmartplus_admin_action'], 'woodmartplus_admin_replay_ticket' ) )
			return;

        if($post_obj->post_type != 'wplus_ticket')
			return;

        if( isset($_POST['wplus_ticket_status_select']) && !empty($_POST['wplus_ticket_status_select']) )
        {
            $status = isset($_POST['wplus_ticket_status_select']) && !empty($_POST['wplus_ticket_status_select']) ? sanitize_text_field($_POST['wplus_ticket_status_select']) : 'wplus_ticket_open';
            update_post_meta($post_id,'wplus_ticket_status',$status);
        }
        if(isset($_POST['wplus_ticket_reply_message']) && !empty($_POST['wplus_ticket_reply_message']))
        {
            $message = sanitize_text_field($_POST['wplus_ticket_reply_message']);
            
            $new_reply = array(
                'post_title'    => "",
                'post_content'  => $message,
                'post_status'   => 'publish',
                'post_parent'   => $post_id,
                'post_author'   => get_current_user_id(),
                'post_type'     => 'wplus_ticket_message',
            );
            
            $new_post_id = wp_insert_post( $new_reply );
            
            if(isset($_POST['arms_ticket_admin_uploaded']) && !empty($_POST['arms_ticket_admin_uploaded']))
            {
                update_post_meta($new_post_id,'wplus_ticket_manager_uploader',$_POST['arms_ticket_admin_uploaded']);
            }
        }
    }

    public function wplus_ticket_meta_boxes()
    {
        add_meta_box('woodmartplus-ticket-messages',esc_html__('Message','woodmartplus'),[$this,'wplus_ticket_show_message'],'wplus_ticket');
        add_meta_box('woodmartplus-ticket-replay-messages',esc_html__('Replay Message','woodmartplus'),[$this,'wplus_ticket_replay_message'],'wplus_ticket');
        add_meta_box('woodmartplus-ticket-status',esc_html__('Ticket Status','woodmartplus'),[$this,'wplus_ticket_status'],'wplus_ticket','side');
    }

    public function wplus_ticket_show_message()
    {
        global $post;
       
        $data = [
            'messages' => $this->get_message_by_id($post->ID),
            'detail_ticket' => $this->get_detail_ticket($post->ID)
        ];        
        return core_load_template('tickets.admin.message',$data);
    }

    public function wplus_ticket_replay_message()
    {

                
       return core_load_template('tickets.admin.replay-message');
    }

    public function wplus_ticket_status()
    {
        global $post;

        $status = $this->generate_ticket_status();
        $status_selected = get_post_meta($post->ID,'wplus_ticket_status',true);

        return core_load_template('tickets.admin.status',[
            'status' => $status,
            'status_selected' => $status_selected
        ]);
    }
    public function customer_added_ticket()
    {
        
        if( isset($_POST['send_ticket']) ){
            
            
            if(!isset($_POST['ticket_title']) || empty($_POST['ticket_title']))
            {
                return wc_add_notice( __('Title cannot be empty','woodmartplus'), 'error' );
            }

            if(!isset($_POST['departeman']) || empty($_POST['departeman']))
            {
                return wc_add_notice( __('Departman cannot be empty','woodmartplus'), 'error' );
            }

            if(isset($_POST['departeman']) && $_POST['departeman'] === 'departeman_order' )
            {
                
                if(!isset($_POST['ticket_customer_product']) || empty($_POST['ticket_customer_product']))
                {
                    return wc_add_notice( __('Select your Order','woodmartplus'), 'error' );
                }
            }

            if(!isset($_POST['wplus_ticket_priority']) || empty($_POST['wplus_ticket_priority']))
            {
                return wc_add_notice( __('Priority cannot be empty','woodmartplus'), 'error' );
            }

            if(!isset($_POST['ticket_description']) || empty($_POST['ticket_description']))
            {
                return wc_add_notice( __('description cannot be empty','woodmartplus'), 'error' );
            }

            $data = [
                'title' => sanitize_text_field($_POST['ticket_title']),
                'departeman' => sanitize_text_field($_POST['departeman']),
                'description' => sanitize_text_field($_POST['ticket_description']),
                'priority' => sanitize_text_field($_POST['wplus_ticket_priority']),
            ];
            
            if(isset($_POST['ticket_customer_product'])  && $_POST['departeman'] === 'departeman_order' )
            {
                $data['order']= sanitize_text_field($_POST['ticket_customer_product']);
            }

            if( isset($_POST['arms_uploaded']) && !empty($_POST['arms_uploaded']))
            {
                $data['upload'] = $_POST['arms_uploaded'];
            }
            
            return $this->add_new_ticket($data);
        }
        
        if(isset($_POST['customer_send_replay_message'])){

            if(!isset($_POST['customer_replay_message']) || empty($_POST['customer_replay_message']))
            {
                return wc_add_notice( __('description cannot be empty','woodmartplus'), 'error' );
            }

            $message = sanitize_text_field($_POST['customer_replay_message']);
            
            $result = $_GET['show_ticket'];
            $ticket_id = explode('_',$result);

            $new_reply = array(
                'post_title'    => "",
                'post_content'  => $message,
                'post_status'   => 'publish',
                'post_parent'   => $ticket_id[1],
                'post_author'   => get_current_user_id(),
                'post_type'     => 'wplus_ticket_message',
            );
            
            $new_post_id = wp_insert_post( $new_reply );

            update_post_meta($new_post_id,'woodmartplus_is_customer',true);
            
            update_post_meta($ticket_id[1] , 'wplus_ticket_status','wplus_ticket_open');
            
            if( isset($_POST['arms_uploaded']) && !empty($_POST['arms_uploaded']))
            {
                update_post_meta($new_post_id, 'wplus_ticket_customer_upload', $_POST['arms_uploaded']);
            }

            return wc_add_notice(__('Your ticket has been successfully sent','woodmartplus'),'success');
        }

    }

    public function add_new_ticket($data)
    {
        extract($data);

        $args = [
            'post_type' => 'wplus_ticket',
            'post_status'=> 'publish',
            'post_title' => $title,
            'post_author' => get_current_user_id(),
        ];

        $new_post_id = wp_insert_post( $args );
        update_post_meta($new_post_id,'wplus_ticket_departeman',$departeman);
        update_post_meta($new_post_id , 'wplus_ticket_status','wplus_ticket_open');
        update_post_meta($new_post_id,'wplus_ticket_priority',$priority);

        

        if(!empty($order))
        {
            update_post_meta($new_post_id,'wplus_ticket_order',$order);
        }
        $next_args = [
            'post_parent' => $new_post_id,
            'post_type' => 'wplus_ticket_message',
            'post_title' => '',
            'post_status'=> 'publish',
            'post_author' => get_current_user_id(),
            'post_content' => $description
        ];
        $customer_id = wp_insert_post( $next_args );
        update_post_meta($customer_id ,'woodmartplus_is_customer',true);
        if(!empty($upload))
        {
            update_post_meta($customer_id,'wplus_ticket_customer_upload',$upload);
        }

        return wc_add_notice(__('Your ticket has been successfully sent'),'success');
    }

    public function add_ticket_tab_in_my_acoount($item)
    {
        $item['tickets'] = __('Tickets' , 'woodmartplus');

        return $item;
    }
    public function add_end_point_ticket_woocmmerce_my_account()
    {
        add_rewrite_endpoint( 'tickets', EP_ROOT | EP_PAGES );
    }

    public function add_new_args_myaccount_ticket_page($vars)
    {
        $vars[] = 'tickets';
        return $vars;
    }
    
 
    public function add_page_tickets_myaccount()
    {
        
        wp_enqueue_media(); 
        wp_print_media_templates();
        if(isset($_GET['action']) && $_GET['action'] === 'new_ticket')
        {
            
            return core_load_template('tickets.front.add',[
                'departemans' => $this->generate_departeman(),
                'orders' => $this->get_order_by_user_id(),
                'priorities' => $this->generate_priority(),
                'how_tosend_text' => wplus_helper::get_option_ticket('text_how_send'),
                'before_send_text' => wplus_helper::get_option_ticket('text_before_send')
            ]);
        }
       
        if(isset($_GET['show_ticket']) && !empty($_GET['show_ticket']))
        {
            $param = sanitize_text_field($_GET['show_ticket']);
            $ticket_id = explode('_',$param);

            return core_load_template('tickets.front.show',[
                'messages' => $this->get_message_by_id($ticket_id[1]),
                'ticket' => $this->get_detail_ticket($ticket_id[1]),
                'closed' => $this->ticket_count('closed'),
                'object' => $this
            ]);
        }

        return core_load_template('tickets.front.index',[
            'all_tickets' => $this->get_detail_ticket(false),
            'in_progress' => $this->ticket_count('in_progress'),
            'open' => $this->ticket_count('open'),
            'closed' => $this->ticket_count('closed'),
            'answered' => $this->ticket_count('answered'),
            'object' => $this
        ]);
    }


    public function ticket_register_post_type()
    {
        
        $labels2 = [
            "name" => esc_html__( "woodmartplus tickets", "woodmartplus" ),
            "singular_name" => esc_html__( "woodmartplus ticket", "woodmartplus" ),
        ];
        $args2 = [
            "label" => esc_html__( "woodmartplus ticket", "woodmartplus" ),
            "labels" => $labels2,
            "description" => "",
            "public" => true,
            "publicly_queryable" => false,
            "show_ui" => true,
            "show_in_rest" => false,
            "has_archive" => true,
            "show_in_menu" => 'woodmartplus-settings',
            "show_in_nav_menus" => true,
            "delete_with_user" => false,
            "exclude_from_search" => false,
            "capability_type" => "post",
            "map_meta_cap" => true,
            "hierarchical" => false,
            "can_export" => false,
            "rewrite" => [ "slug" => "wplus_ticket", "with_front" => true ],
            "query_var" => true,
            "supports" => false,
            "show_in_graphql" => false,
        ];
        register_post_type( "wplus_ticket", $args2 );

        $labels = array(
			'name'                => _x( 'Ticket Message', 'Ticket', 'woodmartplus' ),
			'singular_name'       => _x( 'Ticket Message', 'Ticket', 'woodmartplus' ),
			'parent_item_colon'   => __( 'Parent Item:', 'woodmartplus' ),
			'all_items'           => __( 'All Messages', 'woodmartplus' ),
			'add_new_item'        => __( 'Add Message', 'woodmartplus' ),
			'add_new'             => __( 'Add Message', 'woodmartplus' ),
			'new_item'            => __( 'New Message', 'woodmartplus' ),
			'edit_item'           => __( 'Edit Message', 'woodmartplus' ),
			'update_item'         => __( 'Update Message', 'woodmartplus' ),
			'view_item'           => __( 'View Message', 'woodmartplus' ),
			'search_items'        => __( 'Search Message', 'woodmartplus' ),
			'not_found'           => __( 'Not found', 'woodmartplus' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'woodmartplus' ),
		);
		$args = array(
			'label'               => __( 'WooCommerce  Message', 'woodmartplus' ),
			'description'         => __( 'WooCommerce Ticket System', 'woodmartplus' ),
			'labels'              => $labels,
			'supports'            => array('editor' /* , 'author' */),
			'taxonomies'          => array( /*'category' , 'post_tag' */ ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,                                     
			'show_in_menu'        => false,
			'show_in_admin_bar'   => false,
			'show_in_nav_menus'   => false,
			'can_export'          => true,
			'has_archive'         => false,		
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'capability_type'     => 'shop_order'/* 'post' */
		);
        
		register_post_type( 'wplus_ticket_message', $args );
        
		flush_rewrite_rules();
    }

    public function prefix_disable_gutenberg($current_status, $post_type)
    {
        
        if ($post_type === 'wpluss_ticket') return false;
        return $current_status;
    }

    public function get_message_by_id($ticket_id)
    {
        
        $args = [
            'post_parent' => $ticket_id,
            'posts_per_page'   => -1,
            'post_type' => 'wplus_ticket_message',
            'orderby'          => 'date',
            'order'            => 'ASC',
            'suppress_filters' => true,
        ];
        
        $messages = get_posts($args);
        
        foreach($messages as $key => $message)
        {
            $messages[$key]->woodmartplus_is_customer = get_post_meta($message->ID, 'woodmartplus_is_customer', true) ? true : false;
        
        }
        return $messages;
        
    }

    public function get_detail_ticket($ticket_id = true)
    {
        if($ticket_id){

            return get_post($ticket_id);
        }
        
        $args = [
            'posts_per_page' => -1,
            'post_type' => 'wplus_ticket',
            'author' => get_current_user_id(),
        ];

        $all_ticket = get_posts($args);
        return $all_ticket;

    }
   
    public function generate_ticket_status()
    {
        $status = [
            'wplus_ticket_in_progress' =>[
                'output' => __('In progress','woodmartplus')
            ],
            'wplus_ticket_clossed' => [
                'output' => __('Closed','woodmartplus')
            ],
            'wplus_ticket_open' =>[
                'output' => __('Open','woodmartplus')
            ],
            'wplus_ticket_answered' =>[
                'output' => __('Answered','woodmartplus')
            ]
        ];
        return $status;
    }

    public function add_custom_columns_heads($column)
    {
        $new_column['title'] = $column['title'];
        $new_column['ticket_departman'] = __('Departman','woodmartplus');
        $new_column['ticket_author'] = __('Ticket author','woodmartplus');
        $new_column['ticket_status'] = __('Ticket Status','woodmartplus');
        $new_column['ticket_order'] = __('Order','woodmartplus');
        $new_column['ticket_priority'] = __('Priority','woodmartplus');
        $new_column['ticket_date_answered'] = __('Date answered','woodmartplus');
        unset($column['title']);

        foreach($column as $key => $cl)
        {
            $new_column[$key] = $cl ;
        }
        
        return $new_column;
    }

    public function add_custom_content_columns($column, $ticket_id)
    {
        $ticket = get_post($ticket_id);
        $date_format = get_option( 'date_format' );

        if($column === 'ticket_departman')
        {
            $slug = get_post_meta($ticket_id,'wplus_ticket_departeman',true);
            echo $this->get_name_departeman_by_slug($slug);
        }
        if($column === 'ticket_author')
        {
            $first_name = get_user_meta($ticket->post_author,'first_name',true);
            $last_name = get_user_meta($ticket->post_author,'last_name',true);
            $full_name = isset($first_name) && !empty($first_name) ? $first_name . ' ' . $last_name : __('Customer','woodmartplus');
            echo '<a href="'.admin_url("user-edit.php?user_id=$ticket->post_author").'">' . $full_name . '</a>';
            // echo $full_name;
        }
        if($column === 'ticket_status')
        {
            $output = '';
            $status = get_post_meta($ticket_id,'wplus_ticket_status',true);

            if($status === 'wplus_ticket_open'){
                $output = '<span style="background:red;color: white; padding: 4px; border-radius: 7px; font-size: 12px;">' . esc_html__('Open','woodmartplus') . '</span>';
            }
            elseif($status === 'wplus_ticket_in_progress')
            {
                $output = '<span style="background:#524cff;color: white; padding: 4px; border-radius: 7px; font-size: 12px;">' . esc_html__('In progress','woodmartplus') . '</span>';
            }
            elseif($status === 'wplus_ticket_clossed')
            {
                $output = '<span style="background: #ff8e4c; color: white; padding: 4px; border-radius: 7px; font-size: 12px;">' . esc_html__('Closed','woodmartplus') . '</span>';
            }
            elseif($status === 'wplus_ticket_answered')
            {
                $output = '<span style="background:#43ce07;color: white; padding: 4px; border-radius: 7px; font-size: 12px;">' . esc_html__('Answered','woodmartplus') . '</span>';
            }
            echo $output;
        }
        if($column === 'ticket_order')
        {
            $order_id = get_post_meta($ticket_id,'wplus_ticket_order',true);
            if($order_id):
            ?>
                <span><a href="<?php echo admin_url("post.php?post=$order_id&action=edit"); ?>">سفارشی <?php echo $order_id ?></a></span>
            <?php
            endif;
        }
        if($column === 'ticket_priority')
        {

            $slug = get_post_meta($ticket_id,'wplus_ticket_priority',true);
            echo $this->get_name_priority_by_slug($slug);
        }

        if($column === 'ticket_date_answered')
        {
            // $post_modified = woodmartplus_core_init::date_to_garegorian($date_format,strtotime($ticket->post_modified)) ;
            // echo $post_modified;
        }

    }

    public function ticket_count($role)
    {
        $all_ticket = $this->get_detail_ticket(false);
        $result = [];
        foreach($all_ticket as $ticket)
        {
            $status = get_post_meta($ticket->ID,'wplus_ticket_status',true); //wplus_ticket_open

            if($status === 'wplus_ticket_open' && $role === 'open')
            {
                // var_dump($ticket->ID);
                $result[] = $status;
            }
            elseif($status === 'wplus_ticket_answered' && $role === 'answered')
            {   
                $result[] = $status;
            }
            elseif($status === 'wplus_ticket_clossed' && $role === 'closed')
            {
                $result[] = $status;
            }
            elseif($status === 'wplus_ticket_in_progress' && $role === 'in_progress')
            {
                $result[] = $status;
            }
        }

        return $result;
    }

    public function get_order_by_user_id()
    {
        $result = [];
        $user_id = get_current_user_id();
        $args = [
            'numberposts' => -1,
            'meta_key' => '_customer_user',
            'orderby' => 'date',
            'order' => 'DESC',
            'meta_value' => $user_id,
            'post_type' => wc_get_order_types(),
            'post_status' => array_keys(wc_get_order_statuses()), #'post_status' => array('wc-processing'),
        ];
        $customer_orders = get_posts($args);

        foreach($customer_orders as $customer_order)
        {
            $order = wc_get_order($customer_order);
            $result [] = [
                'id' => $order->get_id(),
            ];
        }
        return $result;
    }

    public function generate_departeman()
    {
        $departeman = [
            'departeman_financial' =>[
                'output' => __('Financial','woodmartplus')
            ],
            'departeman_other' => [
                'output' => __('Other','woodmartplus')
            ],
            'departeman_order' =>[
                'output' => __('Order','woodmartplus')
            ]
        ];

        return apply_filters('woodmartplus_departeman_generated',$departeman);
    }

    public function get_name_departeman_by_slug($slug)
    {
        $departeman = $this->generate_departeman();
        return $departeman[$slug]['output'];
    }

    public function generate_priority()
    {
        $priority = [
            'priority_low' =>[
                'output' => __('Low','woodmartplus')
            ],
            'priority_normal' => [
                'output' => __('Normal','woodmartplus')
            ],
            'priority_high' =>[
                'output' => __('High','woodmartplus')
            ]
        ];

        return apply_filters('woodmartplus_departeman_generated',$priority);
    }

    public function get_name_priority_by_slug($slug)
    {
        $priorities = $this->generate_priority();
        return $priorities[$slug]['output'];
    }

    public function woodmartplus_filters_in_post_type_ticket()
    {
        global $typenow;

        if($typenow == 'wplus_ticket')
        {
            $status = $this->generate_ticket_status();
            ?>
            
            <select name="wplus_ticket_filter_by_status" >
                <option value="none"><?php esc_html_e('Filter by status','woodmartplus'); ?></option>
                <?php foreach($status as $key => $value): ?>
                        <option value="<?php echo $key ?>" ><?php echo esc_html($value['output']); ?></option>
                <?php endforeach; ?>
            </select>
            
            <?php
        }
    }

    public function wplus_ticket_filter_query($query)
    {
        global $pagenow;
        $qv = &$query->query_vars;

        if ($pagenow=='edit.php' && 
        isset($qv['post_type']) && $qv['post_type']=='wplus_ticket' && isset($_GET['wplus_ticket_filter_by_status']) && $_GET['wplus_ticket_filter_by_status'] != 'none') 
        {
            
         $qv['meta_query'][] = 
            array(
             //'relation' => 'OR',
              array(
                'key' => 'wplus_ticket_status',
                'compare' => '=',
                'value' => $_GET['wplus_ticket_filter_by_status']
              )
          );
        }
    }


}
new wplus_ticket();