<?php

class otp_email_handler {

    private $ip_address;
    private $option_user = 'user_otp_email_detial';

    public function __construct()
    {
        $this->ip_address = $this->get_default_ip_address();

        // $this->send_otp_email( 'mamadslayer5@gmail.com' );
    }

    public function send_otp_email( $email )
    {


        $ok_to_send_otp = $this->validate_user_otp_email( $email );

		if( is_wp_error( $ok_to_send_otp ) ){
			return $ok_to_send_otp;
		}

		$email_data = $this->get_user_otp_email_data();
		if( $email_data ){
			
			
			$sent_times 	= (int) $email_data['sent_times'];
			$incorrect 		= $email_data['incorrect'];
		}else{
			$incorrect = $sent_times = 0;
		}

		$otp = $this->only_send_otp_email( $email );

		if( is_wp_error( $otp ) ){
			return $otp;
		}

		$sent_times++;
		
		$data = array(
			'email' 		=> $email,
			'otp' 			=> $otp,
			'created' 		=> strtotime('now'),
			'expiry' 		=> strtotime( wplus_helper::get_otp_config( 'expire_otp',120 ). ' seconds' ),
			'incorrect' 	=> $incorrect,
			'sent_times'	=> $sent_times,
			'verified' 		=> false,
			'form_token' 	=> false,
		);
		
		 $this->set_otp_data( $data );
		
		return $otp;
    }

	public function only_send_otp_email( $email )
	{
		$otp_email = $this->generate_otp_email();

		$from = $this->get_from_email();
		$content = $this->get_text_to_send_email();

		if( !$from )
		{
			return new WP_Error('email-error','تنظیمات ایمیل درست نمیباشد');
		}
		
		$text = "$content$otp_email"; 
		
        $headers = "From: $from";


		$result = wp_mail( $email ,'کد تایید ایمیل', $text, $headers );

		

		if( !$result )
		{
			return new WP_Error('email-error','مشکلی پیش آمده');
		}

		return $otp_email;
	}

	public function get_text_to_send_email()
	{
		return wplus_helper::get_detail_login_register( 'text_send_otp_email','کد یکبار مصرف:' );
	}
	
	public function get_from_email()
	{
		$email = get_option('new_admin_email');

		$email = wplus_helper::get_detail_login_register( 'email_send_from',$email );

		if( $email )
		{
			return $email;
		}
		return false;
	}

    public function get_user_otp_email_otpion()
    {
        return get_option( $this->option_user );

        
    }

	public function get_user_otp_email_data()
    {
        $users = get_option( $this->option_user );

        if( is_array( $users ) && isset( $users[ $this->ip_address ] ) ){
			return $users[ $this->ip_address ]; 
		}
		return $users;
    }


    public function validate_user_otp_email( $email ){

		$data = $this->get_user_otp_email_data();
		
		if( !is_array( $data ) || empty( $data ) ) return;


		$resend_limit 		= wplus_helper::get_otp_config( 'otp_resend',4 );
		$incorrect_limit 	= wplus_helper::get_otp_config( 'incorretct_otp',4 ); 
		$resend_wait_time 	= wplus_helper::get_otp_config( 'wating_resend',30 );
		$ban_time 			= wplus_helper::get_otp_config( 'ban_time',120 );
		
		$time_passed = strtotime("now") - (int) $data['created'];
		
		if( $data['sent_times'] > $resend_limit ){
			$unban_time_left = $ban_time - $time_passed;
			
			if(  $unban_time_left < 0  ){
				$this->set_otp_data( 'sent_times', 0 );
			}
			else{
				return new WP_Error( 'limit-reached', sprintf( __( 'OTP Limit reached. Please try again in %s.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
			}
		}
		
		if( $data['email'] === $email  && $data['sent_times'] >= 1 &&  $resend_wait_time > $time_passed ){
			$unban_time_left = $resend_wait_time - $time_passed;
			return new WP_Error( 'resend-wait', sprintf( __( 'Please wait %s for a new OTP.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
		}

		
		if( $data['incorrect'] >= $incorrect_limit ){

			$unban_time_left = $ban_time - $time_passed;

			if( $unban_time_left < 0 ){

				$this->set_otp_data( 'incorrect', 0 );
			}
			else{
				return new WP_Error( 'tries-exceeded', sprintf( __( 'Maximum number of tries exceeded. Please try again in %s.', 'woodmartplus' ), $this->getTimeDuration( $unban_time_left) ) );
			}
		}


	} 

	public function set_otp_data($key, $value = '')
    {
        $ip_address = $this->ip_address;
		$users 		= $this->get_user_otp_email_otpion();
		
		if( !is_array( $users ) ){
			$users[ $ip_address ] = array();
		}
		
		if( !isset( $users[ $ip_address ] ) ){
			$users[ $ip_address ] = array();
		}
		
		if( is_array( $key ) ){

			$users[ $ip_address ] = wp_parse_args(
				$key,
				$users[ $ip_address ]
			);

		}else{

			$users[ $ip_address ][ $key ] = $value;
		}

		$users[ $ip_address ][ 'last_updated' ] = time();

		update_option( $this->option_user, $users );

    }

    public function getTimeDuration( $time ){
		return $time > 60 ? round($time/60). ' دقیقه' : $time. ' ثانیه';
	}

    public function generate_otp_email()
    {
        $number_of_digits = wplus_helper::get_otp_config( 'number_otp',4 ) ? wplus_helper::get_otp_config( 'number_otp',4 ) : 4 ;

        return rand( pow( 10, $number_of_digits - 1 ) , pow( 10, $number_of_digits ) - 1 );
    }

    public function get_default_ip_address(){

		if ( isset( $_SERVER['HTTP_X_REAL_IP'] ) ) { // WPCS: input var ok, CSRF ok.
			$ip = sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_REAL_IP'] ) );  // WPCS: input var ok, CSRF ok.
		} elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) { // WPCS: input var ok, CSRF ok.
			// Proxy servers can send through this header like this: X-Forwarded-For: client1, proxy1, proxy2
			// Make sure we always only send through the first IP in the list which should always be the client IP.
			$ip = (string) rest_is_ip_address( trim( current( preg_split( '/,/', sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) ) ) ) ); // WPCS: input var ok, CSRF ok.
		} elseif ( isset( $_SERVER['REMOTE_ADDR'] ) ) { // @codingStandardsIgnoreLine
			$ip = sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ); // @codingStandardsIgnoreLine
		} else{
			$ip = '';
		}
		$localhostCheck = array(
		    '127.0.0.1',
		    '::1'
		);
		

		// $ip = in_array( $ip , $localhostCheck ) ? '' : $ip;
		
		return $ip;
	}


}
