<?php 

$options = get_option('woodplus_sms');
$email = get_option('new_admin_email');


?>
<div class="container woodmartplus-options-page">

    <form action="" method="POST" style="display: flex; flex-direction: column; justify-content: space-between; gap: 18px;" >
    
        <div class="navbar-panel">
            <ul>
                <li class="active"> <?php esc_html_e( 'select register login type','woodmartplus' ) ?> </li>
                <li class=""> <?php esc_html_e( 'کد ارسالی به موبایل و ایمیل را کنترل کنید','woodmartplus' ) ?> </li>
                <li> <?php esc_html_e( 'Panel setting','woodmartplus' ) ?> </li>
                <li><?php esc_html_e('گوگل کپچا','woodmartplus') ?></li>
            </ul>
        </div>

        <div class="content-navbar-panel">
                <div class="panel-items active">

                    <div class="logo_login_register">
                        <h3><?php esc_html_e('Logo','woodmartplus'); ?></h3>
                        <?php if( isset( $options['woodplus_sms']['logo_login_register'])  && !empty( $options['woodplus_sms']['logo_login_register'] ) ): ?>
                            <?php 
                                $img_src = wp_get_attachment_image_src($options['woodplus_sms']['logo_login_register'],'medium');    
                            ?>
                             <div class="upload_image">
                                <img src="<?php echo esc_url( $img_src[0] ); ?>" alt="" width="15%">
                            </div>
                            <input type="hidden" name="woodplus_sms[logo_login_register]"  class="upload_image_id" value="<?php echo esc_attr( $options['woodplus_sms']['logo_login_register'] ) ?>" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Edit Image','woodmartplus'); ?></a>

                        <?php else: ?>

                        <div class="upload_image"></div>
                        <input type="hidden" name="woodplus_sms[logo_login_register]"  class="upload_image_id" value="" / >
                        <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Add Image','woodmartplus'); ?></a>
                        <a href="javascript:void(0);" class="remove-image-button" style="display: none;" ><?php esc_html_e('remove image','woodmartplus'); ?></a>

                        <?php endif; ?>
                    </div>
                    
                    <div class="image_background_login_register_section">
                        <h3><?php esc_html_e('تصویر پس زمینه ثبت نام ورود','woodmartplus') ?></h3>
                        <?php if( isset( $options['woodplus_sms']['img_background_login_register'])  && !empty( $options['woodplus_sms']['img_background_login_register'] ) ): ?>
                            <?php 
                                $img_src_bg = wp_get_attachment_image_src($options['woodplus_sms']['img_background_login_register'],'medium');    
                            ?>
                            <div class="upload_image">
                                <img src="<?php echo esc_url( $img_src_bg[0] ); ?>" alt="" width="15%">
                            </div>
                            <input type="hidden" name="woodplus_sms[img_background_login_register]"  class="upload_image_id" value="<?php echo esc_attr( $options['woodplus_sms']['img_background_login_register'] ) ?>" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Edit Image','woodmartplus'); ?></a>
                            <a href="javascript:void(0);" class="remove-image-button"  ><?php esc_html_e('remove image','woodmartplus'); ?></a>
                        <?php else: ?>
                            <div class="upload_image"></div>
                            <input type="hidden" name="woodplus_sms[img_background_login_register]"  class="upload_image_id" value="" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Add Image','woodmartplus'); ?></a>
                            <a href="javascript:void(0);" class="remove-image-button" style="display: none;" ><?php esc_html_e('remove image','woodmartplus'); ?></a>
                        <?php endif; ?>
                        
                    </div>

                    <div class="color_background_login_register">
                        <h3><?php esc_html_e('رنگ پس زمینه ورود و ثبت نام','woodmartplus') ?></h3>
                        <label for="color_picker"><?php esc_html_e('انتخاب رنگ') ?></label>
                        <input class="color_picke" id="color_picker" name="woodplus_sms[color_bg_login_register]" type="text" value="<?php echo isset( $options['woodplus_sms']['color_bg_login_register'] ) ? esc_html($options['woodplus_sms']['color_bg_login_register']): '' ?>" >
                    </div>
                    <div class="new-login-register">
                        <div class="setting_enable_disable_login_register">
                            <h3><?php esc_html_e('Enable login register','woodmartplus'); ?></h3>
                            <input type="checkbox" hidden="hidden" id="complated"  name="woodplus_sms[setting_loginregister_enable]"   style="display:none" <?php echo isset( $options['woodplus_sms']['setting_loginregister_enable'] ) && 'on' === $options['woodplus_sms']['setting_loginregister_enable'] ? 'checked' : '' ?> >
                            <label class="switch" for="complated"></label>
                        </div>    
                    </div>

                    <div class="select_register_login_type">
                        <label for="">نوع ثبت نام و ورود را انتخاب کنید</label>
                        <select name="woodplus_sms[register_login_type]" >
                            <option value="layout-2" <?php echo isset( $options['woodplus_sms']['register_login_type'] ) && 'layout-2' === $options['woodplus_sms']['register_login_type'] ? 'selected' : ''; ?> >هوشمند 2</option>
                            <option value="layout-3" <?php echo isset( $options['woodplus_sms']['register_login_type'] ) && 'layout-3' === $options['woodplus_sms']['register_login_type'] ? 'selected' : ''; ?> >هوشمند 3</option>
                            <option value="layout-4" <?php echo isset( $options['woodplus_sms']['register_login_type'] ) && 'layout-4' === $options['woodplus_sms']['register_login_type'] ? 'selected' : ''; ?> >ووکامرس</option>
                        </select>
                    </div>

                    <div class="login_register_image">

                        <h3><?php esc_html_e('تصویر ثبت نام ورود هوشمند 3','woodmartplus') ?></h3>
                        <?php if( isset( $options['woodplus_sms']['logo_login_register_layout_3'])  && !empty( $options['woodplus_sms']['logo_login_register_layout_3'] ) ): ?>
                            <?php 
                                $img_src_bg_layout_3 = wp_get_attachment_image_src($options['woodplus_sms']['logo_login_register_layout_3'],'medium');   
                            ?>
                                <div class="upload_image">
                                    <img src="<?php echo esc_url( $img_src_bg_layout_3[0] ); ?>" alt="" width="15%">
                                </div>
                                <input type="hidden" name="woodplus_sms[logo_login_register_layout_3]"  class="upload_image_id" value="<?php echo esc_attr( $options['woodplus_sms']['logo_login_register_layout_3'] ) ?>" / >
                                <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Edit Image','woodmartplus'); ?></a>
                                <a href="javascript:void(0);" class="remove-image-button"  ><?php esc_html_e('remove image','woodmartplus'); ?></a>
                        <?php else: ?>
                            <div class="upload_image"></div>
                            <input type="hidden" name="woodplus_sms[logo_login_register_layout_3]"  class="upload_image_id" value="" / >
                            <a href="javascript:void(0);" class="upload-image-button button-primary"><?= esc_html__('Add Image','woodmartplus'); ?></a>
                            <a href="javascript:void(0);" class="remove-image-button" style="display: none;" ><?php esc_html_e('remove image','woodmartplus'); ?></a>
                        <?php endif; ?>

                    </div>

                    <div class="some_text_login_register">
                        <h3>اطلاعات اضافی ثبت نام و ورود</h3>
                        <div class="title_text_login_register">
                            <label for="title_login_register" > عنوان ثبت نام و ورود </label>
                            <input type="text" id="title_login_register" name="woodplus_sms[title_login_register]" value="<?php echo isset( $options['woodplus_sms']['title_login_register'] ) ? esc_html( $options['woodplus_sms']['title_login_register'] ) : '' ?>" >
                        </div>

                        <div class="after_title_text">
                            <label for="after_title_text">توضیح نحوه ورود</label>
                            <input type="text" id="after_title_text" name="woodplus_sms[after_title_text]" value="<?php echo isset( $options['woodplus_sms']['after_title_text'] ) ? esc_html( $options['woodplus_sms']['after_title_text'] ) : '' ?>">
                        </div>

                        <div class="description_login_register">
                            <label for="desc_login_register">توضیح قوانین و شرایط</label>
                            <textarea name="woodplus_sms[description_login_register]" id="description_login_register" cols="50" rows="5"><?php echo isset( $options['woodplus_sms']['description_login_register'] ) ? esc_html( $options['woodplus_sms']['description_login_register'] ) : '' ?></textarea>
                            <p>برای قرار دادن صفحه قوانین و مقرارت از شورتکد استفاده کنید [wplus_term_condion]</p>
                        </div>
                        
                        <div class="more_description">
                            <label for="more_description_login_register">توضیحات اضافی ثبت نام و ورود</label>
                            <textarea name="woodplus_sms[more_description_login_register]" id="more_description_login_register" cols="50" rows="5"><?php echo isset( $options['woodplus_sms']['more_description_login_register'] ) ? esc_html( $options['woodplus_sms']['more_description_login_register'] ) : ''  ?></textarea>
                        </div>
                        
                    </div>

                    <div class="page_rules">
                    <h3>انتخاب برگه قوانین و مقرارت</h3>
                        <select name="woodplus_sms[termsـandـconditions]">
                            <option value="default">انتخاب گزینه</option>
                            <?php foreach( wplus_helper::get_page_register() as $key => $page ): ?>
                                <option value="<?php echo esc_attr( $key ) ?>" <?php echo isset( $options['woodplus_sms']['termsـandـconditions'] ) && $key == $options['woodplus_sms']['termsـandـconditions'] ? 'selected' : ''  ?> ><?php echo esc_html( $page ) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="panel-items">
                    <div class="inputs_items">
                        
                        
                        <div class="number-input">
                            <label for="text_send_otp_email"><?php esc_html_e('متن کد احراز هویت برای ایمیل','woodmartplus') ?>:</label>
                            <textarea name="woodplus_sms[text_send_otp_email]" id="text_send_otp_email" cols="30" rows="5"><?php echo isset($options['woodplus_sms']['text_send_otp_email']) && !empty( $options['woodplus_sms']['text_send_otp_email'] ) ? $options['woodplus_sms']['text_send_otp_email'] : '' ?></textarea>
                            <h5 style="margin-right: 22px;">برای مثال ، کد ارسال یکبار مصرف شما :</h5>
                        </div>

                        <div class="number-input">
                            <label for="send_email_from"><?php esc_html_e('ارسال ایمیل از آدرس','woodmartplus') ?>:</label>
                            <input type="text" name="woodplus_sms[email_send_from]" id="send_email_from" value="<?php echo isset($options['woodplus_sms']['email_send_from']) && !empty( $options['woodplus_sms']['email_send_from'] ) ? $options['woodplus_sms']['email_send_from'] : ($email ? $email : '') ?>">
                        </div>

                        <div class="number-input">
                            <label for="number_otp"><?php esc_html_e('Number of otp digits','woodmartplus'); ?>:</label>
                            <input type="number" id="number_otp" name="woodplus_sms[otp][number_otp]" min="1" max="100" value="<?php echo isset($options['woodplus_sms']['otp']['number_otp']) && !empty( $options['woodplus_sms']['otp']['number_otp'] ) ? $options['woodplus_sms']['otp']['number_otp'] : 4 ?>">
                        </div>

                        <div class="number-input">
                            <label for="incorretct_otp"><?php esc_html_e('Incorrect OTP limit','woodmartplus') ?>:</label>
                            <input type="number" id="incorretct_otp" name="woodplus_sms[otp][incorretct_otp]" min="1" max="6" value="<?php echo isset($options['woodplus_sms']['otp']['incorretct_otp']) && !empty( $options['woodplus_sms']['otp']['incorretct_otp'] ) ? $options['woodplus_sms']['otp']['incorretct_otp'] : 4 ?>">
                        </div>

                        <div class="number-input">
                            <label for="expire_otp"><?php esc_html_e('Expire OTP','woodmartplus') ?>:</label>
                            <input type="number" id="expire_otp" name="woodplus_sms[otp][expire_otp]" min="1" max="120" value="<?php echo isset($options['woodplus_sms']['otp']['expire_otp']) && !empty( $options['woodplus_sms']['otp']['expire_otp'] ) ? $options['woodplus_sms']['otp']['expire_otp'] : 50 ?>">
                        </div>

                        <div class="number-input">
                            <label for="otp_resend"><?php esc_html_e('Nummber OTP resend','woodmartplus') ?>:</label>
                            <input type="number" id="otp_resend" name="woodplus_sms[otp][otp_resend]" min="1" max="100" value="<?php echo isset($options['woodplus_sms']['otp']['otp_resend']) && !empty( $options['woodplus_sms']['otp']['otp_resend'] ) ? $options['woodplus_sms']['otp']['otp_resend'] : 4 ?>">
                        </div>

                        <div class="number-input">
                            <label for="ban_time"><?php esc_html_e('Ban time','woodmartplus') ?>:</label>
                            <input type="number" id="ban_time" name="woodplus_sms[otp][ban_time]" min="1" max="700" value="<?php echo isset($options['woodplus_sms']['otp']['ban_time']) && !empty( $options['woodplus_sms']['otp']['ban_time'] ) ? $options['woodplus_sms']['otp']['ban_time'] : 600 ?>">
                        </div>

                        <div class="number-input">
                            <label for="wating_resend"><?php esc_html_e('Wating resend','woodmartplus') ?>:</label>
                            <input type="number" id="wating_resend" name="woodplus_sms[otp][wating_resend]" min="1" max="120" value="<?php echo isset($options['woodplus_sms']['otp']['wating_resend']) && !empty( $options['woodplus_sms']['otp']['wating_resend'] ) ? $options['woodplus_sms']['otp']['wating_resend'] : 50 ?>">
                        </div>
                            
                       
                    </div>
                </div>

                <div class="panel-items">

                    <div class="select_operators"> 
                        <label > <?php esc_html_e('Choose operator','woodmartplus') ?> </label>
                        <select class="select_operator" name="woodplus_sms[operator_name]" id="">
                            <option value="default" <?php echo isset( $options['woodplus_sms']['operator_name'] ) && isset( $options['woodplus_sms']['operator_name'] ) && 'default' === $options['woodplus_sms']['operator_name'] ? 'selected' : '' ?> ><?php esc_html_e('default','woodmartplus') ?></option>
                            <option value="faraz" <?php echo isset( $options['woodplus_sms']['operator_name'] ) && isset( $options['woodplus_sms']['operator_name'] ) && 'faraz' === $options['woodplus_sms']['operator_name'] ? 'selected' : '' ?> ><?php esc_html_e('فراز اس ام اس','woodmartplus') ?></option>
                            <option value="smsir" <?php echo isset( $options['woodplus_sms']['operator_name'] ) && isset( $options['woodplus_sms']['operator_name'] ) && 'smsir' === $options['woodplus_sms']['operator_name'] ? 'selected' : '' ?> ><?php esc_html_e('Sms.ir','woodmartplus') ?></option>
                            <option value="melipayamak" <?php echo isset( $options['woodplus_sms']['operator_name'] ) && isset( $options['woodplus_sms']['operator_name'] ) && 'melipayamak' === $options['woodplus_sms']['operator_name'] ? 'selected' : '' ?> ><?php esc_html_e('ملی پیامک','woodmartplus') ?></option>
                        </select>
                    </div>

                    <div class="operator_fields">
                        <div class="defualt_fields">
                            <h1>ابتدا اپراتور پیامکی خود را مشخص نمایید</h1>    
                        </div>
                    
                        <div class="faraz_fields">

                                <div class="item">
                                    <label for=""><?php esc_html_e('faraz username','woodmartplus') ?></label>
                                    <input type="text" name="woodplus_sms[faraz][username]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['faraz']['username'] ) ? $options['woodplus_sms']['faraz']['username'] : '' ?>" >
                                </div>

                                <div class="item">
                                    <label for=""><?php esc_html_e('Farz password','woodmartplus') ?></label>
                                    <input type="text" name="woodplus_sms[faraz][password]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['faraz']['password'] ) ? $options['woodplus_sms']['faraz']['password'] : '' ?>" >
                                </div>

                                <div class="item">
                                    <label for=""><?php esc_html_e('Farz numbber','woodmartplus') ?></label>
                                    <input type="text" name="woodplus_sms[faraz][nummber]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['faraz']['nummber'] ) ? $options['woodplus_sms']['faraz']['nummber'] : '' ?>" >
                                </div>

                                <div class="item">
                                    <label for=""><?php esc_html_e('Farz pattern','woodmartplus') ?></label>
                                    <input type="text" name="woodplus_sms[faraz][pattern]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['faraz']['pattern'] ) ? $options['woodplus_sms']['faraz']['pattern'] : '' ?>" >
                                </div>
                                <h5>
                                    زمان ساخت پترن در وبسایت فراز فقط و فقط یک پارامتر ورودی استفاده کنید و نام پارامتر حتما verification-code باشد ، نمونه پترن (وودمارت پلاس خوش امدید : %verification-code% )
                                </h5>
                        </div>

                        <div class="sms_ir_fields">
                            <div class="item">
                                <label for=""><?php esc_html_e('کد امنیتی (apikey)','woodmartplus') ?></label>
                                <input type="text" name="woodplus_sms[smsir][apikey]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['smsir']['apikey'] ) ? $options['woodplus_sms']['smsir']['apikey'] : '' ?>" >
                            </div>

                            <div class="item">
                                <label for=""><?php esc_html_e('شناسه قالب پترن','woodmartplus') ?></label>
                                <input type="text" name="woodplus_sms[smsir][patternid]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['smsir']['patternid'] ) ? $options['woodplus_sms']['smsir']['patternid'] : '' ?>" >
                            </div>

                            <h5>
                                هنگام ساخت قالب (پترن) در وبسایت sms.ir دقت کنید که صرفا یک متغییر ورودی با نام #code# ایجاد کنید
                            </h5>
                        </div>

                        <div class="melipayamak_fiedls">

                            <div class="item">
                                <label for=""><?php esc_html_e('نام کاربری','woodmartplus') ?></label>
                                <input type="text" name="woodplus_sms[melipayamak][username]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['melipayamak']['username'] ) ? $options['woodplus_sms']['melipayamak']['username'] : '' ?>" >
                            </div>

                            <div class="item">
                                <label for=""><?php esc_html_e('کلید apikey','woodmartplus') ?></label>
                                <input type="text" name="woodplus_sms[melipayamak][apikey]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['melipayamak']['apikey'] ) ? $options['woodplus_sms']['melipayamak']['apikey'] : '' ?>" >
                            </div>

                            <div class="item">
                                <label for=""><?php esc_html_e('شماره الگو','woodmartplus') ?></label>
                                <input type="text" name="woodplus_sms[melipayamak][pattern]" value="<?php echo isset( $options['woodplus_sms'] ) && isset( $options['woodplus_sms']['melipayamak']['pattern'] ) ? $options['woodplus_sms']['melipayamak']['pattern'] : '' ?>" >
                            </div>

                            <h5>
                                هنگام ساخت پترن (الگو) در سایت ملی پیامک دقت کنید که از یک متغییر استفاده کنید برای مثال : (وودمارت پلاس خوش امدید : {0})
                            </h5>
                        </div>

                    </div>

                </div>
                <div class="panel-items">
                    <div class="google_reacptcha">
                        <h3><h3><?php esc_html_e('گوگل کپچا','woodmartplus'); ?></h3></h3>
                        <div class="setting_enable_disable_login_register">
                            <h3><?php esc_html_e('فعال کردن گوگل کپچا','woodmartplus'); ?></h3>
                            <input type="checkbox" hidden="hidden" id="recaptcha-enable"  name="woodplus_sms[setting_recaptcha_enable]"   style="display:none" <?php echo isset( $options['woodplus_sms']['setting_recaptcha_enable'] ) && 'on' === $options['woodplus_sms']['setting_recaptcha_enable'] ? 'checked' : '' ?> >
                            <label class="switch" for="recaptcha-enable"></label>
                        </div>    

                        <div class="item">
                            <label for="site_key">
                                گوگل سایت کی
                            </label>
                            <input type="text" id="site_key" class="recaptcha-site-key" name="woodplus_sms[google_recaptcha_site_key]" value="<?php echo isset( $options['woodplus_sms']['google_recaptcha_site_key'] ) ? esc_html( $options['woodplus_sms']['google_recaptcha_site_key'] ) : '' ?>">
                        </div>
                        <div class="item">
                            <label for="secret_key">
                                    گوگل سکرت کی
                                </label>
                            <input type="text" id="secret_key" class="recaptcha-secret-key" name="woodplus_sms[google_recaptcha_secret_key]" value="<?php echo isset( $options['woodplus_sms']['google_recaptcha_secret_key'] ) ? esc_html( $options['woodplus_sms']['google_recaptcha_secret_key'] ) : '' ?>" >
                        </div>
                        <h5>برای دریافت اطلاعات مورد نیاز از <a href="<?php echo esc_url( 'https://www.google.com/recaptcha/admin/create' ) ?>" target="_blank"> اینجا</a> اقدام کنید</h5>
                    </div>
                </div>
        </div>
    <button class="button-3" type="submit" name="save_otp_data" value="save"><?php esc_html_e('save data','woodmartplus'); ?></button>
    </form>

</div>