<?php


class woodplus_elementor{


    public function __construct()
    {
        define('ELEMENTOR_WOODPLUS_URL',DIR_URL.'inc/elementor/widgets/');

        add_action( 'elementor/widgets/register', [$this , 'register_new_widgets'] );
        add_action('elementor/elements/categories_registered', [$this,'woodplus_category_elementor']);    
        add_action('elementor/controls/register', [$this,'register_new_controls']);
        
        $this->include_some_file();
    }

    public function include_some_file()
    {
        require DIR_PATH . 'inc/elementor/elementor_controller/manage-select2.php';
    }

    public function woodplus_category_elementor($elementor_category)
    {

        $elementor_category->add_category(
            'woodplus_elementor',
            [
                  'title' => esc_html__('وودمارت پلاس راستچین', 'woodmartplus'),
            ],
        );
    }

    public function register_new_controls( $controls_manager )
    {
        require_once DIR_PATH . 'inc/elementor/elementor_controller/choose-product.php';
        require_once DIR_PATH . 'inc/elementor/elementor_controller/category-product.php';
        require_once DIR_PATH . 'inc/elementor/elementor_controller/exclude-product.php';

        $controls_manager->register(new \woodplus_choose_product_elementor_controller());
        $controls_manager->register(new \woodplus_category_product_elementor_controller());
        $controls_manager->register(new \woodplus_exclude_product_elementor_controller());
    }

    public function register_new_widgets($widgets_manager)
    {
        require_once DIR_PATH . 'inc/elementor/widgets/amazing-slider/amazing-slider.php';

        $widgets_manager->register( new \woodplus_rtl_amazing_slider() );
    }

}

new woodplus_elementor;